/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.treasuredata.client.AbstractBackOff;

public class ExponentialBackOff
extends AbstractBackOff {
    private int nextIntervalMillis;

    public ExponentialBackOff() {
        this(2000, 60000, 1.5);
    }

    public ExponentialBackOff(int initialIntervalMillis, int maxIntervalMillis, double multiplier) {
        super(initialIntervalMillis, maxIntervalMillis, multiplier);
        this.nextIntervalMillis = initialIntervalMillis;
    }

    @Override
    public int nextWaitTimeMillis() {
        int currentWaitTimeMillis = this.nextIntervalMillis;
        this.nextIntervalMillis = Math.min((int)((double)this.nextIntervalMillis * this.multiplier), this.maxIntervalMillis);
        ++this.executionCount;
        return currentWaitTimeMillis;
    }
}

