/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FilterMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import java.io.IOException;

class CachingMatchesIterator
extends FilterMatchesIterator
implements IntervalMatchesIterator {
    private int[] posAndOffsets = new int[16];
    private Query[] matchingQueries = new Query[4];
    private int count = 0;

    CachingMatchesIterator(IntervalMatchesIterator in) {
        super(in);
    }

    void cache() throws IOException {
        this.count = 0;
        MatchesIterator mi = this.in.getSubMatches();
        if (mi == null) {
            this.count = 1;
            this.posAndOffsets[0] = this.in.startPosition();
            this.posAndOffsets[1] = this.in.endPosition();
            this.posAndOffsets[2] = this.in.startOffset();
            this.posAndOffsets[3] = this.in.endOffset();
            this.matchingQueries[0] = this.in.getQuery();
        } else {
            while (mi.next()) {
                if (this.count * 4 >= this.posAndOffsets.length) {
                    this.posAndOffsets = ArrayUtil.grow(this.posAndOffsets, (this.count + 1) * 4);
                    this.matchingQueries = ArrayUtil.grow(this.matchingQueries, this.count + 1);
                }
                this.posAndOffsets[this.count * 4] = mi.startPosition();
                this.posAndOffsets[this.count * 4 + 1] = mi.endPosition();
                this.posAndOffsets[this.count * 4 + 2] = mi.startOffset();
                this.posAndOffsets[this.count * 4 + 3] = mi.endOffset();
                this.matchingQueries[this.count] = mi.getQuery();
                ++this.count;
            }
        }
    }

    @Override
    public boolean next() throws IOException {
        return this.in.next();
    }

    @Override
    public int startOffset() throws IOException {
        return this.posAndOffsets[2];
    }

    @Override
    public int endOffset() throws IOException {
        return this.posAndOffsets[(this.count - 1) * 4 + 3];
    }

    @Override
    public MatchesIterator getSubMatches() {
        return new MatchesIterator(){
            int upto = -1;

            @Override
            public boolean next() {
                ++this.upto;
                return this.upto < CachingMatchesIterator.this.count;
            }

            @Override
            public int startPosition() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4];
            }

            @Override
            public int endPosition() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 1];
            }

            @Override
            public int startOffset() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 2];
            }

            @Override
            public int endOffset() {
                return CachingMatchesIterator.this.posAndOffsets[this.upto * 4 + 3];
            }

            @Override
            public MatchesIterator getSubMatches() {
                return null;
            }

            @Override
            public Query getQuery() {
                return CachingMatchesIterator.this.matchingQueries[this.upto];
            }
        };
    }

    @Override
    public Query getQuery() {
        return this.matchingQueries[0];
    }

    @Override
    public int gaps() {
        return ((IntervalMatchesIterator)this.in).gaps();
    }

    @Override
    public int width() {
        return ((IntervalMatchesIterator)this.in).width();
    }
}

