/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FilterMatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchesIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MatchesUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ConjunctionMatchesIterator
implements IntervalMatchesIterator {
    final IntervalIterator iterator;
    final List<? extends IntervalMatchesIterator> subs;
    boolean cached = true;

    ConjunctionMatchesIterator(IntervalIterator iterator2, List<? extends IntervalMatchesIterator> subs) {
        this.iterator = iterator2;
        this.subs = subs;
    }

    @Override
    public boolean next() throws IOException {
        if (this.cached) {
            this.cached = false;
            return true;
        }
        return this.iterator.nextInterval() != Integer.MAX_VALUE;
    }

    @Override
    public int startPosition() {
        return this.iterator.start();
    }

    @Override
    public int endPosition() {
        return this.iterator.end();
    }

    @Override
    public int startOffset() throws IOException {
        int start = Integer.MAX_VALUE;
        for (MatchesIterator matchesIterator : this.subs) {
            int v = matchesIterator.startOffset();
            if (v == -1) {
                return -1;
            }
            start = Math.min(start, v);
        }
        return start;
    }

    @Override
    public int endOffset() throws IOException {
        int end = -1;
        for (MatchesIterator matchesIterator : this.subs) {
            int v = matchesIterator.endOffset();
            if (v == -1) {
                return -1;
            }
            end = Math.max(end, v);
        }
        return end;
    }

    @Override
    public MatchesIterator getSubMatches() throws IOException {
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        for (MatchesIterator matchesIterator : this.subs) {
            MatchesIterator sub = matchesIterator.getSubMatches();
            if (sub == null) {
                sub = new SingletonMatchesIterator(matchesIterator);
            }
            subMatches.add(sub);
        }
        return MatchesUtils.disjunction(subMatches);
    }

    @Override
    public Query getQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int gaps() {
        return this.iterator.gaps();
    }

    @Override
    public int width() {
        return this.iterator.width();
    }

    static class SingletonMatchesIterator
    extends FilterMatchesIterator {
        boolean exhausted = false;

        SingletonMatchesIterator(MatchesIterator in) {
            super(in);
        }

        @Override
        public boolean next() {
            if (this.exhausted) {
                return false;
            }
            this.exhausted = true;
            return true;
        }
    }
}

