/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.iterators;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import java.io.IOException;

public final class TaxonomyChildrenOrdinalIterator
implements OrdinalIterator {
    private final OrdinalIterator sourceOrds;
    private final ParallelTaxonomyArrays.IntArray parents;
    private final int parentOrd;

    public TaxonomyChildrenOrdinalIterator(OrdinalIterator sourceOrds, ParallelTaxonomyArrays.IntArray parents, int parentOrd) {
        this.sourceOrds = sourceOrds;
        this.parents = parents;
        assert (parentOrd != -1) : "Parent Ordinal is not valid";
        this.parentOrd = parentOrd;
    }

    @Override
    public int nextOrd() throws IOException {
        int ord = this.sourceOrds.nextOrd();
        while (ord != -1) {
            if (this.parents.get(ord) == this.parentOrd) {
                return ord;
            }
            ord = this.sourceOrds.nextOrd();
        }
        return -1;
    }
}

