(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards');

    /**
     * Was previously located here: src/main/platypus/static/dataiku/js/dashboards/view.js
     */
    app.controller('DashboardViewController', function($scope, $location, $stateParams, $state, Notification, DashboardUtils, DashboardPageUtils) {

        if (typeof($scope.uiState)==='undefined'){
            $scope.uiState = {};
        }

        $scope.isInExport = getCookie('dku_graphics_export') === 'true';

        if (DashboardUtils.isDashboardEmbeddedInAWorkspace()) {
            // Implementing show/hide filters button in workspace is too complex, so we always force the visibility of filter panels
            DashboardUtils.toggleAllFilterPanels($scope.dashboard, true);
        } else {
            DashboardUtils.showFiltersPanelForPagesWithFilters($scope.dashboard);
        }

        $scope.getNextVisiblePageIdx = () => {
            let nextVisiblePageIdx;
            if ($scope.uiState.currentPageIdx === $scope.dashboard.pages.length-1) {
                return;
            }
            for (let i = $scope.uiState.currentPageIdx + 1; i < $scope.dashboard.pages.length; i++) {
                if ($scope.dashboard.pages[i].show) {
                    nextVisiblePageIdx = i;
                    break;
                }
            }
            return nextVisiblePageIdx;
        };

        $scope.hasNextVisiblePage = () => {
            return !_.isNil($scope.getNextVisiblePageIdx());
        };

        $scope.getPreviousVisiblePageIdx = () => {
            let prevVisiblePageIdx;
            if (!$scope.uiState.currentPageIdx) {
                return;
            }
            for (let i = $scope.uiState.currentPageIdx - 1; i >= 0; i--) {
                if ($scope.dashboard.pages[i].show) {
                    prevVisiblePageIdx = i;
                    break;
                }
            }
            return prevVisiblePageIdx;
        };

        $scope.hasPreviousVisiblePage = () => {
            return !_.isNil($scope.getPreviousVisiblePageIdx());
        };

        $scope.$watch('fullScreen', function(nv) {
            const wrapper = $('body')[0];
            if (nv == null) {
                return;
            }

            if (nv) {
                requestFullscreen();
            } else {
                exitFullscreen();
            }
            $state.go($state.current, { fullScreen: (nv && nv != 'false') ? true : null }, { location: true, inherit:true, notify:false, reload:false });

            $scope.$on('$destroy', () => {
                exitFullscreen();
            });

            function handleFullscreenExit() {
                if (!document.fullscreenElement) {
                    $scope.fullScreen = false;
                    document.removeEventListener('fullscreenchange', handleFullscreenExit);
                }
            }

            function requestFullscreen() {
                const startFsNames = ['requestFullscreen', 'mozRequestFullScreen', 'webkitRequestFullScreen'];
                executeFirstAvailableFunction(startFsNames, wrapper);
                document.addEventListener('fullscreenchange', handleFullscreenExit);
            }

            function exitFullscreen() {
                if (document.fullscreenElement ||
                    document.webkitFullscreenElement ||
                    document.mozFullScreenElement) { // Can't exit fullscreen if there is no element in fullscreen
                    const stopFsNames = ['exitFullscreen', 'cancelFullScreen', 'webkitCancelFullScreen', 'mozCancelFullScreen'];
                    executeFirstAvailableFunction(stopFsNames, document);
                }
            }

            function executeFirstAvailableFunction(functionNames, elmt) {
                for (let i = 0; i < functionNames.length; i++) {
                    if (elmt[functionNames[i]]) {
                        elmt[functionNames[i]]();
                        break;
                    }
                }
            }
        });
        $scope.fullScreen = $stateParams.fullScreen && $stateParams.fullScreen !== 'false';
        $scope.embedded = $stateParams.embedded && $stateParams.embedded !== 'false';

        $scope.switchPage = function(index) {
            $scope.uiState.currentPageIdx = index;
            // clear query params filters on slide change
            $location.search('filters', undefined);
            $location.search('pageFilters', undefined);
        };

        $scope.goToNextPage = function() {
            $scope.switchPage(DashboardPageUtils.getNextPageIndex($scope.dashboard, $scope.uiState.currentPageIdx));
        };

        $scope.goToPreviousPage = function() {
            $scope.switchPage(DashboardPageUtils.getPreviousPageIndex($scope.dashboard, $scope.uiState.currentPageIdx));
        };

        $scope.$on('toggleFullScreen', () => {
            $scope.fullScreen = !$scope.fullScreen;
        });

        const dashboardReloadNeededUnsubscribe = Notification.registerEvent('dashboards-reload-needed',function(evt, data) {
            if (data && data.params) {
                const dashboardConcerned = data.params.dashboards.some(d => d.projectKey === $stateParams.projectKey && $stateParams.dashboardId === d.id);

                if (dashboardConcerned) {
                    $scope.$emit('dashboards-reload-needed');
                }
            }
        });
        $scope.$on('$destroy', dashboardReloadNeededUnsubscribe);
    });
})();
