(function() {
    'use strict';

    angular.module('dataiku.charts').component('legendOptzone', {
        templateUrl: '/static/dataiku/js/simple_report/components/legend-optzone/legend-optzone.component.html',
        bindings: {
            canPlaceInSidebar: '<',
            legendPlacement: '=',
            legendFormatting: '=',
            displayLegendFormatting: '<',
            theme: '<'
        },

        controller: function($scope, $timeout, ColorUtils, translate, DSSVisualizationThemeUtils) {
            const ctrl = this;
            $scope.translate = translate;

            ctrl.$onInit = () => {
                ctrl.themeColors = ColorUtils.getThemeColorsWithBlackWhite(ctrl.theme);
                ctrl.foregroundColors = ColorUtils.generateThemePaletteColors(DSSVisualizationThemeUtils.getThemeOrDefault(ctrl.theme).colors, ctrl.themeColors.length > 0).foregroundColors;
            };

            $scope.$watch('$ctrl.theme', (newTheme, oldTheme) => {
                if (!newTheme) {
                    return;
                }
                ctrl.defaultFormatting = { fontColor: newTheme.legendFormatting.fontColor, fontSize: newTheme.legendFormatting.fontSize };
                ctrl.themeColors = ColorUtils.getThemeColorsWithBlackWhite(newTheme);
                if (!ctrl.foregroundColors || !oldTheme || !_.isEqual(newTheme.colors, oldTheme.colors)) {
                    ctrl.themeColors = ColorUtils.getThemeColorsWithBlackWhite(newTheme);
                    const paletteColors = ColorUtils.generateThemePaletteColors(newTheme.colors, ctrl.themeColors.length > 0);
                    if (paletteColors) {
                        ctrl.foregroundColors = paletteColors.foregroundColors;
                    }
                }
            });

            ctrl.categories = {
                'OUTER': ['OUTER_RIGHT', 'OUTER_LEFT', 'OUTER_TOP', 'OUTER_BOTTOM'],
                'INNER': ['INNER_TOP_RIGHT', 'INNER_TOP_LEFT', 'INNER_BOTTOM_LEFT', 'INNER_BOTTOM_RIGHT']
            };

            $scope.$watch('$ctrl.legendPlacementCategory', function(nv, ov) {
                if (!nv) {
                    return;
                }

                if (nv === 'SIDEBAR') {
                    ctrl.legendPlacement = 'SIDEBAR';
                } else {
                    if (ctrl.categories[nv].indexOf(ctrl.legendPlacement) === -1) {
                        ctrl.legendPlacement = ctrl.categories[nv][0];
                    }
                }
            });

            $scope.$watch('$ctrl.legendPlacement', function(nv, ov) {
                if (!nv) {
                    return;
                }

                if (nv === 'SIDEBAR') {
                    ctrl.legendPlacementCategory = 'SIDEBAR';
                } else {
                    for (const cat in ctrl.categories) {
                        if (ctrl.categories[cat].indexOf(nv) > -1) {
                            ctrl.legendPlacementCategory = cat;
                            break;
                        }
                    }
                }
            });

            ctrl.onLegendFormattingChange = function(value) {
                $timeout(() => ctrl.legendFormatting = value);
            };
        }
    });
})();
