(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    // (!) This controller previously was in static/dataiku/js/simple_report/config_ui.js
    app.controller('BinnedXYChartDefController', function($scope, ChartTypeChangeHandler, CHART_VARIANTS, ChartColumnTypeUtils) {
        $scope.acceptMeasure = function(data) {
            return ChartTypeChangeHandler.stdAggregatedAcceptMeasure(data);
        };
        $scope.acceptDimensionOrHierarchy = function(data) {
            return ChartTypeChangeHandler.binnedXYAcceptDimensionOrHierarchy($scope.chart.def.variant, data);
        };
        $scope.hasSizeMenu = function() {
            return $scope.chart.def.variant === CHART_VARIANTS.binnedXYHexagon;
        };
        $scope.getXDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.xHierarchyDimension : $scope.chart.def.xDimension;
        $scope.getYDimList = (data) => ChartColumnTypeUtils.isHierarchy(data) ? $scope.chart.def.yHierarchyDimension : $scope.chart.def.yDimension;
    });
})();
