/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.lambda.mgmt.LambdaServicesCRUDService;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.lambda.APIServiceCodes;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PackagesService {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LambdaServicesCRUDService crudService;
    public static final String LAMBDA_PACKAGES = "apinode-packages";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.packages");

    public synchronized List<File> list(String projectKey, String serviceId) throws IOException {
        PackagesService.checkServiceId(serviceId);
        File packageDir = ApplicationConfigurator.getFile((String[])new String[]{LAMBDA_PACKAGES, projectKey, serviceId});
        if (!packageDir.isDirectory()) {
            logger.info((Object)("Directory does not exist: " + packageDir.getAbsolutePath()));
            return Lists.newLinkedList();
        }
        String[] names = packageDir.list();
        if (names == null) {
            logger.info((Object)("Cannot list content of directory: " + packageDir.getAbsolutePath()));
            return Lists.newLinkedList();
        }
        ArrayList<File> files = new ArrayList<File>(names.length);
        for (String n : names) {
            File f = new File(packageDir, n);
            if (!f.isDirectory()) continue;
            files.add(f);
        }
        return files;
    }

    @Nonnull
    public List<LambdaService.LambdaServiceSummary.Package> listSummaries(String projectKey, String serviceId) throws IOException {
        List<File> generations = this.list(projectKey, serviceId);
        generations.sort(Comparator.comparing(File::lastModified).reversed());
        ArrayList<LambdaService.LambdaServiceSummary.Package> acc = new ArrayList<LambdaService.LambdaServiceSummary.Package>();
        for (File serviceGenFolder : generations) {
            try {
                LambdaService.LambdaServiceSummary.Package packageDetails = this.getSummary(serviceGenFolder);
                acc.add(packageDetails);
            }
            catch (Exception e) {
                logger.errorV("Skipping listing of package %s because it has thrown a %s: %s", new Object[]{serviceGenFolder.getAbsolutePath(), e.getClass().getSimpleName(), e.getMessage()});
            }
        }
        return acc;
    }

    public synchronized File get(String projectKey, String serviceId, String packageId) throws Exception {
        PackagesService.checkServiceId(serviceId);
        PackagesService.checkPackageId(packageId, true);
        File dir = ApplicationConfigurator.getFile((String[])new String[]{LAMBDA_PACKAGES, projectKey, serviceId, packageId});
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Package directory does not exist " + dir.getAbsolutePath());
        }
        return dir;
    }

    @Nonnull
    public LambdaService.LambdaServiceSummary.Package getSummary(String projectKey, String serviceId, String packageId) throws Exception {
        File packageFile = this.get(projectKey, serviceId, packageId);
        return this.getSummary(packageFile);
    }

    @Nullable
    public LambdaService.LambdaServiceSummary.Package getSummaryOrNull(String projectKey, String serviceId, String packageId) {
        try {
            return this.getSummary(projectKey, serviceId, packageId);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nonnull
    private LambdaService.LambdaServiceSummary.Package getSummary(File serviceGenFolder) throws IOException {
        File packageArchive = new File(serviceGenFolder, "package.zip");
        if (!packageArchive.exists()) {
            throw new FileNotFoundException("Package archive does not exist: " + packageArchive.getAbsolutePath());
        }
        LambdaServiceConfig config = (LambdaServiceConfig)ZipUtils.readFileContentJSON((File)packageArchive, (String)"config.json", LambdaServiceConfig.class);
        if (config == null) {
            throw new FileNotFoundException(String.format("Package '%s' doesn't contain a config.json file", packageArchive.getAbsolutePath()));
        }
        LambdaServiceGenTag tagInfo = (LambdaServiceGenTag)ZipUtils.readFileContentJSON((File)packageArchive, (String)"tag.json", LambdaServiceGenTag.class);
        if (tagInfo == null) {
            logger.warnV("Package '%s' doesn't contain a tag.json file", new Object[]{packageArchive.getAbsolutePath()});
        }
        return new LambdaService.LambdaServiceSummary.Package(serviceGenFolder.getName(), serviceGenFolder.lastModified(), config, tagInfo);
    }

    public synchronized File mkdir(String projectKey, String serviceId, String packageId) throws Exception {
        File dir;
        PackagesService.checkServiceId(serviceId);
        PackagesService.checkPackageId(packageId, false);
        File packageDir = ApplicationConfigurator.getFile((String[])new String[]{LAMBDA_PACKAGES, projectKey, serviceId});
        if (!packageDir.isDirectory()) {
            logger.info((Object)("Creating " + packageDir.getAbsolutePath()));
            DKUFileUtils.mkdirs((File)packageDir);
        }
        if ((dir = new File(packageDir, packageId)).isDirectory()) {
            LambdaService.LambdaServiceSummary.Package existingPackage = this.getSummaryOrNull(projectKey, serviceId, packageId);
            if (existingPackage != null) {
                throw new IllegalArgumentException("Package directory already exists " + dir.getAbsolutePath());
            }
            logger.infoV("Removing directory containing invalid package %s", new Object[]{dir.getAbsolutePath()});
            DKUFileUtils.forceDelete((File)dir);
        }
        DKUFileUtils.mkdirs((File)dir);
        return dir;
    }

    public synchronized void delete(String projectKey, String serviceId, String packageId) throws Exception {
        PackagesService.checkServiceId(serviceId);
        PackagesService.checkPackageId(packageId, true);
        File dir = ApplicationConfigurator.getFile((String[])new String[]{LAMBDA_PACKAGES, projectKey, serviceId, packageId});
        if (!dir.isDirectory()) {
            logger.info((Object)("Directory does not exist: " + dir.getAbsolutePath()));
        }
        DKUFileUtils.forceDelete((File)dir);
    }

    private static void checkServiceId(String id) {
        if (id == null || id.length() == 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)APIServiceCodes.ERR_API_SERVICE_INVALID_ID, "It cannot be null or empty.");
        }
        if (!id.matches("^[\\w-]+$")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)APIServiceCodes.ERR_API_SERVICE_INVALID_ID, "Service ID cannot contains unauthorized characters. Only letters, digits, dash (-) and underscore (_) characters are allowed.");
        }
    }

    private static void checkPackageId(String id, boolean lenient) {
        if (id == null || id.length() == 0) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)APIServiceCodes.ERR_API_SERVICE_PACKAGE_INVALID_ID, "It cannot be null or empty.");
        }
        if (lenient) {
            if (id.contains("/")) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)APIServiceCodes.ERR_API_SERVICE_PACKAGE_INVALID_ID, "It cannot contains unauthorized characters such as slashes (/).");
            }
        } else if (!id.matches("^(?!\\.)[\\w\\.-]+$")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)APIServiceCodes.ERR_API_SERVICE_PACKAGE_INVALID_ID, "Version ID cannot contains unauthorized characters: only letters, digits, dots (.), dash (-) and underscore (_) characters are allowed. It also cannot start with a dot (.) character.");
        }
    }

    public void publish_NT(AuthCtx user, String projectKey, String serviceId, String packageId, @Nullable String publishedServiceId) throws IOException, UnauthorizedException {
        LambdaService lambdaService;
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        try (Transaction t = this.transactionService.beginRead();){
            lambdaService = this.crudService.getOrNull(projectKey, serviceId);
        }
        if (lambdaService == null) {
            throw ErrorContext.iaef((String)"Service not found: %s.%s", (Object)projectKey, (Object[])new Object[]{serviceId});
        }
        String pSvcId = StringUtils.isNotBlank((String)publishedServiceId) ? publishedServiceId : serviceId;
        File pckFile = ApplicationConfigurator.getFile((String[])new String[]{LAMBDA_PACKAGES, projectKey, serviceId, packageId, "package.zip"});
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"API Deployer support is disabled");
            }
            case LOCAL: {
                try (FileInputStream is = new FileInputStream(pckFile);){
                    ((PublishedAPIServicesService)SpringUtils.getBean(PublishedAPIServicesService.class)).publishVersionFromStream_NT_Check(pSvcId, (InputStream)is, user);
                    break;
                }
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    client.publishVersion(pSvcId, packageId, pckFile);
                    break;
                }
            }
            default: {
                throw ErrorContext.iaef((String)"Invalid mode for API Deployer: %s", (Object)ref.mode, (Object[])new Object[0]);
            }
        }
    }
}

