/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.nodeclients.AbstractDeployerClientProxyUser;
import com.dataiku.dip.nodeclients.ProjectDeployerClientProxyUser;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class UpdateDeployerDeploymentStepRunner<S extends AbstractDeploymentsService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra>, P extends UpdateDeployerDeploymentStepParams, U extends AbstractDeployerClientProxyUser>
implements StepRunner {
    public static final StepMeta API_DEPLOYER_META = new META(){

        public Class<? extends StepParams> paramsClass() {
            return UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams.class;
        }

        public String getType() {
            return "update_apideployer_deployment";
        }

        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new UpdateApiDeployerDeploymentStepRunner(scenario, step, (UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams)step.getParamsAs(UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams.class));
        }
    };
    public static final StepMeta PROJECT_DEPLOYER_META = new META(){

        public Class<? extends StepParams> paramsClass() {
            return UpdateDeployerDeploymentStepParams.UpdateProjectDeploymentStepParams.class;
        }

        public String getType() {
            return "update_projectdeployer_deployment";
        }

        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new UpdateProjectDeployerDeploymentStepRunner(scenario, step, (UpdateDeployerDeploymentStepParams.UpdateProjectDeploymentStepParams)step.getParamsAs(UpdateDeployerDeploymentStepParams.UpdateProjectDeploymentStepParams.class));
        }
    };
    protected final P params;
    private final Step step;
    private final Scenario scenario;
    private final String deployerType;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.update_deployment");

    UpdateDeployerDeploymentStepRunner(Scenario scenario, Step step, P params, String type) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
        this.deployerType = type;
    }

    abstract FutureResponse<? extends DeploymentReport> callExecuteOneStep(AuthCtx var1, String var2, S var3) throws Exception;

    abstract FutureResponse<? extends DeploymentReport> updateDeployment(U var1, String var2) throws Exception;

    abstract S getDeploymentsService();

    abstract U getDeployerClient(GeneralSettingsDAO.GeneralSettings var1, AuthCtx var2);

    abstract AbstractInfrasService<? extends AbstractDeployment, ? extends AbstractPublishedItemBasicInfo, ? extends AbstractDeploymentInfra> getInfrasService();

    /*
     * Unable to fully structure code
     */
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        UpdateDeployerDeploymentStepRunner.logger.infoV("Start step %s", new Object[]{this.step.name});
        variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        deploymentId = variablesContext.expand(this.params.deploymentId);
        newVersionId = variablesContext.expand(this.params.newVersionId);
        activatedItem = new ReportItem.ActivatedPublishedPackage((ReportTargetItem)new ReportTargetItem.DeploymentItem(deploymentId)).withPublishedPackageId(newVersionId).withDeployerType(this.deployerType);
        try {
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            ref = gs.deployerClientSettings.getRef();
            switch (3.$SwitchMap$com$dataiku$dip$dao$GeneralSettingsDAO$DeployerMode[ref.mode.ordinal()]) {
                case 1: {
                    throw ErrorContext.iae((String)"Deployer support is disabled");
                }
                case 2: {
                    deploymentsService = this.getDeploymentsService();
                    if (!GovernIntegrationService.enabledWithSanityChecksIfEnabled()) ** GOTO lbl27
                    infrasService = this.getInfrasService();
                    t = this.transactionService.beginRead();
                    try {
                        deployment = deploymentsService.getSettingsMandatoryUnsafe_Check(deploymentId, (AuthCtx)stepRun.getScenarioRun().runAsUser);
                        infraBasicInfo = infrasService.getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)stepRun.getScenarioRun().runAsUser).infraBasicInfo;
                    }
                    finally {
                        if (t != null) {
                            t.close();
                        }
                    }
                    localInfoMessages = deploymentsService.getGovernanceMessages_NT(infraBasicInfo, deployment.getPublishedItemId(), Collections.singletonList(newVersionId));
                    this.addWarningsAndErrorsForGovernance(localInfoMessages, activatedItem);
lbl27:
                    // 2 sources

                    rwt = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)stepRun.getScenarioRun().runAsUser);
                    try {
                        deploymentsService.switchVersion(deploymentId, newVersionId, (AuthCtx)stepRun.getScenarioRun().runAsUser);
                        rwt.commit("Updated deployment " + deploymentId + " to " + newVersionId + " from scenario " + stepRun.getScenarioRun().getScenario().id);
                    }
                    finally {
                        if (rwt != null) {
                            rwt.close();
                        }
                    }
                    UpdateDeployerDeploymentStepRunner.logger.info((Object)"Updated deployment definition, starting sync");
                    activatedItem.withStart(DateTime.now().getMillis());
                    resp = this.callExecuteOneStep((AuthCtx)stepRun.getScenarioRun().runAsUser, deploymentId, deploymentsService);
                    UpdateDeployerDeploymentStepRunner.logger.info((Object)"Waiting for update to complete");
                    resp = this.futureService.waitForFinalResponse(resp);
                    UpdateDeployerDeploymentStepRunner.logger.infoV("Update response: %s", new Object[]{JSON.prettyLog((Object)resp)});
                    this.addWarningsAndErrorsForDeployment((DeploymentReport)resp.result, activatedItem);
                    break;
                }
                case 3: {
                    dac = this.getDeployerClient(gs, (AuthCtx)stepRun.getScenarioRun().runAsUser);
                    try {
                        remoteInfoMessages = dac.getGovernanceStatus(deploymentId, newVersionId);
                        this.addWarningsAndErrorsForGovernance(remoteInfoMessages, activatedItem);
                        dac.switchVersion(deploymentId, newVersionId);
                        UpdateDeployerDeploymentStepRunner.logger.info((Object)"Updated deployment definition, starting sync");
                        activatedItem.withStart(DateTime.now().getMillis());
                        resp = this.updateDeployment(dac, deploymentId);
                        UpdateDeployerDeploymentStepRunner.logger.info((Object)"Waiting for update to complete");
                        resp = this.futureService.waitForFinalResponse(resp);
                        UpdateDeployerDeploymentStepRunner.logger.infoV("Update response: %s", new Object[]{JSON.prettyLog((Object)resp)});
                        this.addWarningsAndErrorsForDeployment((DeploymentReport)resp.result, activatedItem);
                        if (dac == null) break;
                    }
                    catch (Throwable var10_14) {
                        if (dac != null) {
                            try {
                                dac.close();
                            }
                            catch (Throwable var11_19) {
                                var10_14.addSuppressed(var11_19);
                            }
                        }
                        throw var10_14;
                    }
                    dac.close();
                    break;
                }
            }
            if (activatedItem.getWarnings() != null && activatedItem.getWarnings().totalCount > 0) {
                activatedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING);
            } else {
                activatedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            }
            UpdateDeployerDeploymentStepRunner.logger.info((Object)"Done updating the deployment");
            UpdateDeployerDeploymentStepRunner.logger.infoV("Done step %s", new Object[]{this.step.name});
        }
        catch (Throwable ex) {
            activatedItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            throw ex;
        }
        finally {
            if (activatedItem.start != 0L) {
                this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(this.scenario.getProjectKey(), deploymentId), null, null, stepRun.getScenarioRun(), stepRun, (ReportItem)activatedItem);
            }
        }
    }

    private void addWarningsAndErrorsForDeployment(DeploymentReport deploymentReport, ReportItem.ActivatedPublishedPackage activatedItem) throws CodedException {
        InfoMessage.Severity maxSeverity = deploymentReport.getMaxSeverity();
        boolean hasErrors = maxSeverity != null ? maxSeverity.equals((Object)InfoMessage.Severity.ERROR) : deploymentReport.error;
        if (hasErrors) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_UNEXPECTED_ERROR, deploymentReport.report());
        }
        WarningsContext localWarningsContext = new WarningsContext();
        for (InfoMessage infoMessage : deploymentReport.messages) {
            if (!InfoMessage.Severity.WARNING.equals((Object)infoMessage.severity)) continue;
            localWarningsContext.addWarning(WarningsContext.WarningType.DEPLOYMENT_ISSUE, infoMessage.message, logger);
        }
        if (localWarningsContext.getTotalCount() > 0) {
            activatedItem.withWarnings(localWarningsContext.getOutput());
        }
    }

    private void addWarningsAndErrorsForGovernance(InfoMessage.InfoMessages governInfoMessages, ReportItem.ActivatedPublishedPackage activatedItem) throws CodedException {
        if (governInfoMessages.error) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_INVALID_GOVERNANCE_STATUS, governInfoMessages.report());
        }
        WarningsContext localWarningsContext = new WarningsContext();
        for (InfoMessage infoMessage : governInfoMessages.messages) {
            if (!InfoMessage.Severity.WARNING.equals((Object)infoMessage.severity)) continue;
            localWarningsContext.addWarning(WarningsContext.WarningType.GOVERNANCE_ISSUE, infoMessage.message, logger);
        }
        if (localWarningsContext.getTotalCount() > 0) {
            activatedItem.withWarnings(localWarningsContext.getOutput());
        }
    }

    static abstract class UpdateDeployerDeploymentStepParams
    implements StepParams {
        String deploymentId;
        String newVersionId;

        UpdateDeployerDeploymentStepParams() {
        }

        static class UpdateAPIDeploymentStepParams
        extends UpdateDeployerDeploymentStepParams {
            boolean isFullUpdate = false;

            UpdateAPIDeploymentStepParams() {
            }
        }

        static class UpdateProjectDeploymentStepParams
        extends UpdateDeployerDeploymentStepParams {
            UpdateProjectDeploymentStepParams() {
            }
        }
    }

    public static class UpdateProjectDeployerDeploymentStepRunner
    extends UpdateDeployerDeploymentStepRunner<ProjectDeploymentsService, UpdateDeployerDeploymentStepParams.UpdateProjectDeploymentStepParams, ProjectDeployerClientProxyUser> {
        UpdateProjectDeployerDeploymentStepRunner(Scenario scenario, Step step, UpdateDeployerDeploymentStepParams.UpdateProjectDeploymentStepParams params) {
            super(scenario, step, params, "project");
        }

        @Override
        ProjectDeploymentsService getDeploymentsService() {
            return (ProjectDeploymentsService)SpringUtils.getBean(ProjectDeploymentsService.class);
        }

        @Override
        ProjectDeployerClientProxyUser getDeployerClient(GeneralSettingsDAO.GeneralSettings gs, AuthCtx runAsUser) {
            return new ProjectDeployerClientProxyUser(gs.deployerClientSettings.getRef(), runAsUser);
        }

        AutomationNodeInfrasService getInfrasService() {
            return (AutomationNodeInfrasService)SpringUtils.getBean(AutomationNodeInfrasService.class);
        }

        @Override
        public FutureResponse<? extends DeploymentReport> callExecuteOneStep(AuthCtx authCtx, String deploymentId, ProjectDeploymentsService deploymentsService) throws Exception {
            return deploymentsService.executeOneStepSync_NT_Check(authCtx, deploymentId);
        }

        @Override
        FutureResponse<? extends DeploymentReport> updateDeployment(ProjectDeployerClientProxyUser dac, String deploymentId) throws Exception {
            return dac.updateDeployment(deploymentId);
        }
    }

    public static class UpdateApiDeployerDeploymentStepRunner
    extends UpdateDeployerDeploymentStepRunner<APIServiceDeploymentsService, UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams, APIDeployerClientProxyUser> {
        UpdateApiDeployerDeploymentStepRunner(Scenario scenario, Step step, UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams params) {
            super(scenario, step, params, "api");
        }

        @Override
        APIServiceDeploymentsService getDeploymentsService() {
            return (APIServiceDeploymentsService)SpringUtils.getBean(APIServiceDeploymentsService.class);
        }

        @Override
        APIDeployerClientProxyUser getDeployerClient(GeneralSettingsDAO.GeneralSettings gs, AuthCtx runAsUser) {
            return new APIDeployerClientProxyUser(gs.deployerClientSettings.getRef(), runAsUser);
        }

        ApiNodeInfrasService getInfrasService() {
            return (ApiNodeInfrasService)SpringUtils.getBean(ApiNodeInfrasService.class);
        }

        @Override
        public FutureResponse<? extends DeploymentReport> callExecuteOneStep(AuthCtx authCtx, String deploymentId, APIServiceDeploymentsService deploymentService) throws Exception {
            return deploymentService.executeOneStepSync_NT_Check(authCtx, deploymentId, ((UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams)this.params).isFullUpdate);
        }

        @Override
        FutureResponse<? extends DeploymentReport> updateDeployment(APIDeployerClientProxyUser dac, String deploymentId) throws Exception {
            return dac.updateDeployment(deploymentId, ((UpdateDeployerDeploymentStepParams.UpdateAPIDeploymentStepParams)this.params).isFullUpdate);
        }
    }

    private static abstract class META
    implements StepMeta {
        private META() {
        }

        public String buildName(Step step) {
            UpdateDeployerDeploymentStepParams params = (UpdateDeployerDeploymentStepParams)step.getParamsAs(UpdateDeployerDeploymentStepParams.class);
            Object name = "Update deployment";
            if (StringUtils.isNotBlank((String)params.deploymentId)) {
                name = (String)name + " " + params.deploymentId;
            }
            return name;
        }

        public String buildId(Step step) {
            UpdateDeployerDeploymentStepParams params = (UpdateDeployerDeploymentStepParams)step.getParamsAs(UpdateDeployerDeploymentStepParams.class);
            return "deploy " + params.deploymentId;
        }

        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    }
}

