/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.pages;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PagesSettingsCatalogPermissionService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private BusinessAppsService businessAppsService;
    protected static final DKULogger logger = DKULogger.getLogger((String)PagesSettingsCatalogPermissionService.class.getSimpleName());

    private GeneralSettingsDAO.GeneralSettings getGeneralSettings() {
        GeneralSettingsDAO.GeneralSettings generalSettings;
        block8: {
            Transaction t = this.transactionService.retrieveOrBeginRead();
            try {
                GeneralSettingsDAO.GeneralSettings gs;
                generalSettings = gs = this.generalSettingsService.read();
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.warnV("Can not read general settings.", new Object[0]);
                    return null;
                }
            }
            t.close();
        }
        return generalSettings;
    }

    private void getActivatedSettingsForAdmin(GeneralSettingsDAO.GeneralSettings gs, Map<String, Boolean> permissionParams) {
        if (gs == null) {
            return;
        }
        permissionParams.put("appConfig.isLdapActivated", gs.ldapSettings.enabled);
        permissionParams.put("appConfig.isLdapGroupSupportActivated", gs.ldapSettings.enabled && gs.ldapSettings.enableGroups);
        permissionParams.put("appConfig.hasCFPlugins", !gs.customFieldsPluginComponentOrder.isEmpty());
        permissionParams.put("appConfig.hasCPHPlugins", !gs.customPolicyHooksPluginComponentOrder.isEmpty());
        permissionParams.put("appConfig.isGitModePlugin", ApplicationConfigurator.getPluginGitMode() == DSSGitModel.PluginGitMode.PLUGIN);
        permissionParams.put("appConfig.isHiveActivated", gs.hiveSettings.enabled && HadoopLoader.hadoopEnabled());
        permissionParams.put("appConfig.isImpalaActivated", gs.impalaSettings.enabled && HadoopLoader.hadoopEnabled());
        permissionParams.put("appConfig.isSparkActivated", gs.sparkSettings.sparkEnabled);
        permissionParams.put("appConfig.isInteractiveSparkSQLActivated", gs.sparkSettings.sparkEnabled && gs.sparkSettings.interactiveExecutionEngine != null);
    }

    public Map<String, Boolean> getPermissionParams(DSSAuthCtx dssAuthCtx, String projectKey) throws DKUSecurityException {
        GeneralSettingsDAO.NodeRef governRef;
        HashMap<String, Boolean> permissionParams = new HashMap<String, Boolean>();
        UsersDAO.GroupPermissions permissions = dssAuthCtx.getPermissions();
        GeneralSettingsDAO.GeneralSettings gs = this.getGeneralSettings();
        boolean governEnabled = false;
        boolean canAccessGovernNode = false;
        GeneralSettingsDAO.NodeRef nodeRef = governRef = gs != null ? gs.governIntegrationSettings.getRef() : null;
        if (governRef != null) {
            governEnabled = governRef.enabled;
            canAccessGovernNode = governRef.enabled && StringUtils.isNotBlank((String)governRef.nodeExternalUrl);
        }
        boolean storiesEnabled = gs != null && gs.dataikuStoriesSettings.enabled;
        permissionParams.put("user.isAdmin", permissions.isAdmin());
        permissionParams.put("user.mayCreateProjects", permissions.mayCreateProjects());
        permissionParams.put("user.mayCreateFromMacros", permissions.mayCreateProjectsFromMacros());
        permissionParams.put("user.mayCreateFromTemplates", permissions.mayCreateProjectsFromTemplates());
        permissionParams.put("user.mayCreateFromDataikuApps", permissions.mayCreateProjectsFromDataikuApps());
        permissionParams.put("user.mayCreateWorkspaces", permissions.mayCreateWorkspaces());
        permissionParams.put("user.mayShareToWorkspaces", permissions.mayShareToWorkspaces());
        permissionParams.put("user.mayCreateCodeEnvs", permissions.mayCreateCodeEnvs());
        permissionParams.put("user.mayDevelopPlugins", permissions.mayDevelopPlugins());
        permissionParams.put("user.mayCreateClusters", permissions.mayCreateClusters());
        permissionParams.put("user.mayManageCodeEnvs", permissions.mayManageCodeEnvs());
        permissionParams.put("user.mayManageUDM", permissions.mayManageUDM());
        permissionParams.put("user.mayCreateAuthenticatedConnections", permissions.mayCreateAuthenticatedConnections());
        permissionParams.put("user.mayEditLibFolders", permissions.mayEditLibFolders());
        permissionParams.put("user.mayWriteUnsafeCode", permissions.mayWriteUnsafeCode());
        permissionParams.put("user.mayCreatePublishedAPIServices", permissions.mayCreatePublishedAPIServices());
        permissionParams.put("user.mayCreatePublishedProjects", permissions.mayCreatePublishedProjects());
        permissionParams.put("user.mayWriteInRootProjectFolder", permissions.mayWriteInRootProjectFolder());
        permissionParams.put("user.mayWriteSafeCode", permissions.mayWriteSafeCode());
        permissionParams.put("user.mayViewIndexedHiveConnections", permissions.mayViewIndexedHiveConnections());
        permissionParams.put("user.mayMoveProjects", permissions.mayMoveProjects());
        permissionParams.put("user.mayManageClusters", permissions.mayManageClusters());
        permissionParams.put("user.mayCreateCodeStudioTemplates", permissions.mayCreateCodeStudioTemplates());
        permissionParams.put("user.mayManageCodeStudioTemplates", permissions.mayManageCodeStudioTemplates());
        permissionParams.put("user.mayCreateActiveWebContent", permissions.mayCreateActiveWebContent());
        if (StringUtils.isNotBlank((String)projectKey)) {
            try (Transaction ignored = this.transactionService.beginRead();){
                SerializedProject project;
                try {
                    project = this.projectsDAO.getOrNullUnsafe(projectKey);
                }
                catch (IOException e) {
                    logger.warnV("Project with key '%s' cannot be found", new Object[]{projectKey});
                    project = null;
                }
                if (project != null) {
                    permissionParams.put("project.isAdmin", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.ADMIN));
                    permissionParams.put("project.editPermissions", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS));
                    permissionParams.put("project.readProjectContent", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.READ_CONF));
                    permissionParams.put("project.writeProjectContent", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.WRITE_CONF));
                    permissionParams.put("project.exportDatasetsData", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA));
                    permissionParams.put("project.shareToWorkspaces", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.SHARE_TO_WORKSPACES));
                    permissionParams.put("project.readDashboards", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS));
                    permissionParams.put("project.writeDashboards", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS));
                    if (project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                        permissionParams.put("project.moderateDashboards", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS));
                    }
                    permissionParams.put("project.runScenarios", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS));
                    permissionParams.put("project.manageDashboardAuthorizations", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS));
                    permissionParams.put("project.manageExposedElements", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS));
                    if (project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                        permissionParams.put("project.manageAdditionalDashboardUsers", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.MANAGE_ADDITIONAL_DASHBOARD_USERS));
                    }
                    permissionParams.put("project.executeApp", this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP));
                    permissionParams.put("project.canAccessProjectSecurity", PagesSettingsCatalogPermissionService.canAccessProjectSecurity(project, permissionParams));
                    permissionParams.put("project.canAccessGovernSettings", governEnabled && this.permissionsService.hasProjectPrivilege((AuthCtx)dssAuthCtx, project, Privileges.ProjectLevelPrivilegeType.ADMIN));
                }
            }
        }
        permissionParams.put("appConfig.canAccessGovernNode", canAccessGovernNode);
        permissionParams.put("appConfig.canAccessStoriesSettings", storiesEnabled && permissions.isAdmin());
        permissionParams.put("appConfig.canAccessBusinessApps", this.businessAppsService.areBusinessAppsAllowed() && permissions.isAdmin());
        if (permissions.isAdmin()) {
            this.getActivatedSettingsForAdmin(gs, permissionParams);
        }
        return permissionParams;
    }

    @VisibleForTesting
    static boolean canAccessProjectSecurity(SerializedProject sp, Map<String, Boolean> permissionParams) {
        return permissionParams != null && (permissionParams.getOrDefault("project.manageDashboardAuthorizations", false) != false || permissionParams.getOrDefault("project.manageExposedElements", false) != false || permissionParams.getOrDefault("project.manageAdditionalDashboardUsers", false) != false || permissionParams.getOrDefault("project.editPermissions", false) != false) && sp.projectType != SerializedProject.ProjectType.BUSINESS_APP;
    }
}

