/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.actions.IActionService;
import com.dataiku.gh.core.services.python_execution.artifact_action.ArtifactActionScriptSuccess;
import com.dataiku.gh.core.services.python_execution.instance_action.ActionScriptSuccess;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ActionsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IActionService actionService;

    @AuditedCall(value={"msgType", "artifact-action-run", "artifactId", "${artifactId}", "actionId", "${actionId}"})
    @RequestMapping(value={"/api/actions/artifact/run"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ARTIFACT_ACTION_RUN)
    @ResponseBody
    public ArtifactActionScriptSuccess runArtifactAction(HttpServletRequest req, @RequestParam String artifactId, @RequestParam String actionId, @RequestParam(required=false) JsonObject params) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        JsonObject nonNullParams = params == null ? new JsonObject() : params;
        return this.actionService.runArtifactAction(authCtx, artifactId, actionId, nonNullParams);
    }

    @AuditedCall(value={"msgType", "action-run", "actionId", "${actionId}"})
    @RequestMapping(value={"/api/actions/run"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ACTION_RUN)
    @ResponseBody
    public ActionScriptSuccess runInstanceAction(HttpServletRequest req, @RequestParam String actionId, @RequestParam(required=false) JsonObject params) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        JsonObject nonNullParams = params == null ? new JsonObject() : params;
        return this.actionService.runInstanceAction(authCtx, actionId, nonNullParams);
    }

    @AuditedCall(value={"msgType", "actions-list"})
    @RequestMapping(value={"/api/actions/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<InstanceAction> listInstanceActions(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.actionService.listInstanceActions(authCtx);
    }
}

