/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.actions.InstanceAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.actions.IAdminActionService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminActionsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminActionService adminActionService;

    @AuditedCall(value={"msgType", "action-create"})
    @RequestMapping(value={"/api/admin/actions/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.ACTION_CREATE)
    @ResponseBody
    public InstanceAction createInstanceAction(HttpServletRequest req, @RequestParam InstanceAction instanceAction, @RequestParam String newIdentifier) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminActionService.createInstanceAction(authCtx, instanceAction, newIdentifier);
    }

    @AuditedCall(value={"msgType", "action-save"})
    @RequestMapping(value={"/api/admin/actions/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.ACTION_SAVE)
    @ResponseBody
    public InstanceAction saveInstanceAction(HttpServletRequest req, @RequestParam InstanceAction instanceAction) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminActionService.saveInstanceAction(authCtx, instanceAction);
    }

    @AuditedCall(value={"msgType", "action-delete"})
    @RequestMapping(value={"/api/admin/actions/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.ACTION_DELETE)
    @ResponseBody
    public void deleteInstanceActions(HttpServletRequest req, @RequestParam String instanceActionId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminActionService.deleteInstanceAction(authCtx, instanceActionId);
    }
}

