/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.kernel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.KernelErrorCodes;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.gh.core.kernel.GHIsolableProcess;
import com.dataiku.gh.core.services.python_execution.PythonExecutionRequest;
import com.dataiku.gh.core.services.python_execution.PythonExecutionResponse;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GHPythonKernel
extends DSSKernelBase {
    private final ResponderKernelLink link = new ResponderKernelLink();
    private final String kernelTypeId;
    @Nullable
    private final Runnable afterProcessComplete;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.python-kernel");

    public GHPythonKernel(String id, String kernelTypeId, @Nullable Runnable afterProcessComplete) throws IOException {
        super(id);
        this.kernelTypeId = kernelTypeId;
        this.afterProcessComplete = afterProcessComplete;
    }

    public GHPythonKernel(String id, String kernelTypeId) throws IOException {
        this(id, kernelTypeId, null);
    }

    public void start() throws CodedException, IOException, InterruptedException {
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing kernel", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            this.internalStart();
            FutureProgress.updateState((double)1.0);
        }
        catch (Exception e) {
            this.close();
            throw new CodedException((InfoMessage.MessageCode)KernelErrorCodes.ERR_COMPUTE_KERNEL_FAILURE, "Local kernel failed to start", (Throwable)e);
        }
    }

    public void close() throws IOException {
        logger.info((Object)"Killing local kernel");
        try {
            this.link.close();
        }
        catch (IOException e) {
            logger.error((Object)"Could not close Javalink", (Throwable)e);
        }
        try {
            if (!this.killed) {
                this.killWithoutMercy(true);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while killing local kernel", e);
        }
    }

    public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
        return this.smartLogTailBuilder;
    }

    public boolean isAlive() {
        return !this.killed && this.link.isAlive() && !this.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStart() throws Exception {
        ArrayList args = Lists.newArrayList();
        String pythonBin = System.getenv("DKUPYTHONBIN");
        if (pythonBin == null) {
            throw new Error("environment variable DKUPYTHONBIN not defined");
        }
        args.add(new File(pythonBin).getAbsolutePath());
        args.add("-m");
        args.add("govern.javalink.server");
        args.add(String.valueOf(this.link.getPort()));
        args.add(this.link.getSecret());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().put("PYTHONIOENCODING", "UTF-8");
        pb.environment().put("DKU_GOVERNSERVER_PORT", System.getenv("DKU_GOVERNSERVER_PORT"));
        this.process = new GHIsolableProcess(pb, DKUApp.getBaseFolderF());
        this.process.start();
        DKULogger pylogger = DKULogger.getLogger((String)("gh.python-kernel.python-output." + this.kernelTypeId));
        this.startStandardTailers(pylogger, pylogger);
        this.monitorThread = new DSSKernelBase.KernelMonitorThread(){

            protected void onAfterProcessComplete() {
                if (GHPythonKernel.this.afterProcessComplete != null) {
                    GHPythonKernel.this.afterProcessComplete.run();
                }
            }
        };
        this.monitorThread.setCloseOnFailure((Closeable)this.link.getServerSocket());
        try {
            this.monitorThread.start();
            this.link.waitForProcess();
            this.link.getBlockLink().getAsyncLink();
        }
        finally {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    public <REQ extends PythonExecutionRequest, RESP extends PythonExecutionResponse> CompletableFuture<RESP> executeAsyncIO(REQ command, Class<RESP> clazz) {
        return this.link.getBlockLink().getAsyncLink().asyncSendRequest(command, clazz, Function.identity());
    }
}

