/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution_factory;

import com.dataiku.gh.core.models.configuration.DkuInternalSettingsGovernConfiguration;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.PythonExecutionService;
import com.dataiku.gh.core.services.python_execution_factory.PythonExecutionNoOpService;
import com.dataiku.gh.core.storage.configuration.IGovernConfigurationDAO;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PythonExecutionServiceConfigFactory
implements SmartInitializingSingleton {
    @Autowired
    private ApplicationContext ctx;
    @Autowired
    private IGovernConfigurationDAO governConfigurationDAO;

    @Bean
    public IPythonExecutionService pythonExecutionService() throws IOException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return this.getCorrectPythonExecutionService().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @NotNull
    public Class<? extends IPythonExecutionService> getCorrectPythonExecutionService() throws IOException {
        DkuInternalSettingsGovernConfiguration defaultParams = (DkuInternalSettingsGovernConfiguration)this.governConfigurationDAO.getOrNull("dku-internal-settings");
        if (null == defaultParams || !defaultParams.databaseImportedFromDiagnosis) {
            return PythonExecutionService.class;
        }
        return PythonExecutionNoOpService.class;
    }

    public void afterSingletonsInstantiated() throws BeansException {
        try {
            this.assertSingletonBeanClass(IPythonExecutionService.class, this.getCorrectPythonExecutionService());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void assertSingletonBeanClass(Class<T> interfaceType, Class<? extends T> requiredImplementationType) {
        Class<?> actualType = ((IPythonExecutionService)this.ctx.getBean(IPythonExecutionService.class)).getClass();
        if (!requiredImplementationType.isAssignableFrom(actualType)) {
            throw new BeanDefinitionStoreException("Bean for interface " + interfaceType.getName() + " must be " + requiredImplementationType.getName() + ", but got: " + actualType.getName());
        }
    }
}

