/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.roles;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IAdminRolesService;
import com.dataiku.gh.core.services.roles_and_permissions.roles.IRolesDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IRoleValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminRolesService
implements IAdminRolesService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IRoleValidationService roleValidationService;
    @Autowired
    private IRolesDataService rolesDataService;
    @Autowired
    private IRoleDAO roleDAO;

    @Override
    @GHReadonlyTransaction
    public List<Role> listRoles(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.rolesDataService.listRoles();
    }

    @Override
    @GHReadonlyTransaction
    public Role getRole(AuthCtx authCtx, String roleId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.rolesDataService.getRole(roleId);
    }

    @Override
    @GHWriteTransaction
    public Role createRole(AuthCtx authCtx, Role role, String newIdentifier) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        if (role.id != null) {
            throw new ValidationException("Role ID `" + role.id + "` cannot be set in creation");
        }
        role.id = IdentifiersUtils.buildRoleId(newIdentifier);
        if (this.roleDAO.exists(role.id)) {
            throw new ValidationException("Role ID already exists: " + role.id);
        }
        this.roleValidationService.validateRole(role);
        return this.rolesDataService.createRole(role);
    }

    @Override
    @GHWriteTransaction
    public Role saveRole(AuthCtx authCtx, Role role) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        if (!this.roleDAO.exists(role.id)) {
            throw new ValidationException("Role does not exist: " + role.id);
        }
        this.roleValidationService.validateRole(role);
        return this.rolesDataService.saveRole(role);
    }

    @Override
    @GHWriteTransaction
    public void deleteRole(AuthCtx authCtx, String roleId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.rolesDataService.deleteRole(roleId);
    }
}

