/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.transactions.git;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.FileContentCompressor;
import com.dataiku.dip.transactions.git.CommitQueuesManager;
import com.dataiku.dip.transactions.git.ICommitBehavior;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.gh.transactions.git.GHCommitBehavior;
import com.dataiku.gh.transactions.git.jgit.GHSingleRepositoryGitManager;
import java.io.File;
import java.io.IOException;

public class GHTransactionProviderSettings
extends TransactionProvider.TransactionProviderSettings {
    public GHTransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport, File largeFileTempDir, FileContentCompressor compressor) {
        super(useMainExclusiveLock, forceCacheV1, gitSupport, compressor, largeFileTempDir);
        this.nbWriteThreads = DKUApp.getParams().getIntParam("dku.core.fs.nbWriteThreads", Integer.valueOf(8));
        this.enableCRC32Check = DKUApp.getParams().getBoolParam("dku.core.fs.enableCRC32Check", false);
    }

    public GHTransactionProviderSettings(boolean useMainExclusiveLock, boolean forceCacheV1, boolean gitSupport) throws IOException {
        this(useMainExclusiveLock, forceCacheV1, gitSupport, DSSTempUtils.getTempFolderWithSpecificName((String)"txn", (String)"large-files"), FileContentCompressor.NOOP_COMPRESSOR);
    }

    public CommitQueuesManager buildCommitQueuesManager(File root) throws IOException {
        return new CommitQueuesManager((CommitQueuesManager.ICommitQueuesBehavior)new CommitQueuesManager.GlobalCommitQueuesBehavior((IGitManager)new GHSingleRepositoryGitManager(root)));
    }

    public ICommitBehavior buildCommitBehavior() {
        return new GHCommitBehavior();
    }
}

