/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal;

import java.util.Date;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.opengis.temporal.Instant;

public class TemporalConverterFactory
implements ConverterFactory {
    static Converter dateToInstant = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            return target.cast(new DefaultInstant(new DefaultPosition((Date)source)));
        }
    };
    static Converter stringToInstant = new Converter(){

        public <T> T convert(Object source, Class<T> target) throws Exception {
            Date d = (Date)Converters.convert((Object)source, Date.class);
            return (T)(d != null ? dateToInstant.convert((Object)d, target) : null);
        }
    };

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (Instant.class.isAssignableFrom(target)) {
            if (Date.class.isAssignableFrom(source)) {
                return dateToInstant;
            }
            if (String.class.equals(source)) {
                return stringToInstant;
            }
        }
        return null;
    }
}

