/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.geotools.http.HTTPResponse;

public class DefaultHttpResponse
implements HTTPResponse {
    private URLConnection connection;
    private InputStream responseStream;

    public DefaultHttpResponse(URLConnection connection) throws IOException {
        this.connection = connection;
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String contentEncoding = connection.getContentEncoding();
            if (contentEncoding != null && connection.getContentEncoding().indexOf("gzip") != -1) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (Exception e) {
            if (inputStream != null) {
                inputStream.close();
            }
            throw e;
        }
        this.responseStream = inputStream;
    }

    @Override
    public void dispose() {
        if (this.responseStream != null) {
            try {
                this.responseStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.responseStream = null;
        }
        if (this.connection != null) {
            if (this.connection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.connection).disconnect();
            }
            this.connection = null;
        }
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.connection.getHeaderField(headerName);
    }

    @Override
    public InputStream getResponseStream() throws IOException {
        return this.responseStream;
    }

    @Override
    public String getResponseCharset() {
        String contentType = this.getContentType();
        if (null == contentType) {
            return null;
        }
        String[] split = contentType.split(";");
        for (int i = 1; i < split.length; ++i) {
            String[] mimeParam = split[i].split("=");
            if (mimeParam.length != 2 || !"charset".equalsIgnoreCase(mimeParam[0])) continue;
            String charset = mimeParam[1];
            return charset.trim();
        }
        return null;
    }
}

