/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.agentreview.AgentReviewExecutionResult;
import com.dataiku.dip.agentreview.AgentReviewHumanReview;
import com.dataiku.dip.agentreview.AgentReviewStatus;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.agentreview.AgentReviewTraitOutcome;
import com.dataiku.dip.agentreview.AgentReviewTraitOverride;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.util.CollectionUtils;

@UIModel
@PartOfPublicAPI
public class AgentReviewResult {
    public String id;
    public String projectKey;
    public String agentReviewId;
    public String runId;
    public String testId;
    public long creationTimestamp;
    @Nullable
    public String query;
    @Nullable
    public String rawQuery;
    @Nullable
    public String referenceAnswer;
    @Nullable
    public String expectations;
    @Nullable
    public String toolCalls;
    public String agentSmartId;
    public String agentVersion;
    public String createdBy;
    @Nullable
    String createdByDisplayName;
    public List<AgentReviewExecutionResult> executionResults = new ArrayList<AgentReviewExecutionResult>();
    public Map<String, List<AgentReviewTraitOverride>> traitOverridesPerTraitId = new LinkedHashMap<String, List<AgentReviewTraitOverride>>();
    public List<AgentReviewHumanReview> humanReviews = new ArrayList<AgentReviewHumanReview>();
    @Nonnull
    public AgentReviewStatus status = AgentReviewStatus.EMPTY;
    public Map<String, AgentReviewStatus> traitStatusPerTraitId = new LinkedHashMap<String, AgentReviewStatus>();
    public Map<String, AgentReviewStatus> aiStatusPerTraitId = new LinkedHashMap<String, AgentReviewStatus>();
    @UINullable
    public Map<String, String> traitStatusJustificationPerTraitId = new LinkedHashMap<String, String>();

    public void computeStatuses(List<AgentReviewTrait> traits) {
        long nbExecutions = this.executionResults.size();
        for (AgentReviewTrait trait : traits) {
            String aiStatusJustification;
            AgentReviewStatus aiStatus;
            if (nbExecutions == 0L) {
                this.aiStatusPerTraitId.put(trait.id, AgentReviewStatus.SKIPPED);
                aiStatus = AgentReviewStatus.SKIPPED;
                aiStatusJustification = "Could not compute status due to an execution error.";
            } else {
                List<AgentReviewTraitOutcome> traitOutcomes = this.executionResults.stream().map(executionResults -> executionResults.traitOutcomePerTraitId.get(trait.id)).filter(Objects::nonNull).toList();
                if (traitOutcomes.isEmpty()) {
                    if (trait.needsExpectations && StringUtils.isBlank((CharSequence)this.expectations)) {
                        aiStatus = AgentReviewStatus.SKIPPED;
                        aiStatusJustification = "Could not compute trait execution status due to 'Expectations' missing from the test configuration.";
                    } else if (trait.needsReference && StringUtils.isBlank((CharSequence)this.referenceAnswer)) {
                        aiStatus = AgentReviewStatus.SKIPPED;
                        aiStatusJustification = "Could not compute trait execution status due to 'Reference answer' missing from the test configuration.";
                    } else {
                        aiStatus = AgentReviewStatus.SKIPPED;
                        aiStatusJustification = "Could not compute status due to an execution error.";
                    }
                } else if (traitOutcomes.stream().filter(Objects::nonNull).count() != nbExecutions) {
                    aiStatus = AgentReviewStatus.SKIPPED;
                    aiStatusJustification = "Could not compute status due to an execution error.";
                } else {
                    boolean anyPass = traitOutcomes.stream().anyMatch(traitOutcome -> traitOutcome.outcome());
                    boolean anyFail = traitOutcomes.stream().anyMatch(traitOutcome -> traitOutcome.outcome() == false);
                    if (anyPass && anyFail) {
                        aiStatus = AgentReviewStatus.FAIL;
                        aiStatusJustification = "Partial success: some executions failed to satisfy this trait.";
                    } else if (anyPass) {
                        aiStatus = AgentReviewStatus.PASS;
                        aiStatusJustification = "All test executions successfully satisfied the requirements for this trait.";
                    } else {
                        aiStatus = AgentReviewStatus.FAIL;
                        aiStatusJustification = "The agent consistently failed to demonstrate this trait across all test executions.";
                    }
                }
                this.aiStatusPerTraitId.put(trait.id, aiStatus);
            }
            List traitHumanOverrides = this.traitOverridesPerTraitId.getOrDefault(trait.id, Collections.emptyList());
            AgentReviewStatus traitHumanStatus = CollectionUtils.isEmpty(traitHumanOverrides) ? AgentReviewStatus.EMPTY : AgentReviewStatus.aggregateLikes(traitHumanOverrides.stream().map(traitOverride -> traitOverride.like).toList());
            String traitHumanStatusJustification = switch (traitHumanStatus) {
                case AgentReviewStatus.PASS -> "All team reviews passed for this trait. ";
                case AgentReviewStatus.FAIL -> "All team reviews failed for this trait. ";
                case AgentReviewStatus.CONFLICT -> "Some team reviews failed for this trait, but not all. ";
                default -> "";
            };
            AgentReviewStatus traitStatus = !AgentReviewStatus.EMPTY.equals((Object)traitHumanStatus) ? traitHumanStatus : aiStatus;
            this.traitStatusPerTraitId.put(trait.id, traitStatus);
            this.traitStatusJustificationPerTraitId.put(trait.id, traitHumanStatusJustification + aiStatusJustification);
            if (traitStatus.getSeverity() <= this.status.getSeverity()) continue;
            this.status = traitStatus;
        }
        List<Boolean> humanOverrides = this.humanReviews.stream().filter(review -> review.like != null).map(review -> review.like).toList();
        if (!humanOverrides.isEmpty()) {
            this.status = AgentReviewStatus.aggregateLikes(humanOverrides);
        }
    }
}

