/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIImageGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    private static final DKULogger logger = DKULogger.getLogger(AIImageGenerationService.class);

    public FutureResponse<AIImageGenerationFrontendResponse> startImageGeneration(DSSAuthCtx authCtx, String prompt, @Nullable ImageFormat size, @Nullable String responseType) throws Exception {
        AIImageGenerationBackendQuery query = new AIImageGenerationBackendQuery();
        query.prompt = prompt;
        query.size = size;
        query.response_type = responseType;
        AIImageGenerationScriptFutureThread futureThread = new AIImageGenerationScriptFutureThread(authCtx, query);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIImageGenerationFrontendResponse>>(){});
    }

    public static class AIImageGenerationBackendQuery {
        String licenseId;
        String prompt;
        @Nullable
        ImageFormat size;
        @Nullable
        String response_type;
        boolean telemetryEnabled;
    }

    public static enum ImageFormat {
        SIZE_256x256("256x256"),
        SIZE_512x512("512x512"),
        SIZE_1024x1024("1024x1024"),
        SIZE_1792x1024("1792x1024"),
        SIZE_1024x1792("1024x1792");

        final String size;

        private ImageFormat(String size) {
            this.size = size;
        }

        public static ImageFormat fromString(String size) {
            for (ImageFormat format : ImageFormat.values()) {
                if (!format.size.equalsIgnoreCase(size)) continue;
                return format;
            }
            return null;
        }

        public String toString() {
            return this.size;
        }
    }

    private class AIImageGenerationScriptFutureThread
    extends SimpleFutureThread<AIImageGenerationFrontendResponse> {
        private final AIImageGenerationBackendQuery query;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public AIImageGenerationScriptFutureThread(DSSAuthCtx owner, AIImageGenerationBackendQuery query) {
            super((AuthCtx)owner);
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.query = query;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_image_generation", (String)"AI Image Generation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AIImageGenerationFrontendResponse compute() throws Exception {
            NDC.push((String)("ai-imagegeneration: " + this.query.prompt));
            try {
                AIImageGenerationFrontendResponse aIImageGenerationFrontendResponse;
                block17: {
                    if (!this.generalSettings.aiDrivenAnalyticsSettings.isAssistantEnabled(GeneralSettingsDAO.AiAssistant.STORIES_ASSISTANT) || !this.generalSettings.dataikuStoriesSettings.enabled) {
                        throw new IllegalStateException("Stories AI image generation is not enabled");
                    }
                    LicenseStatusService.LicensingStatus ls = AIImageGenerationService.this.licenseStatusService.getLicensingStatus();
                    if (ls.community) {
                        throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
                    }
                    this.query.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
                    this.query.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
                    InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.owner, this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                    try {
                        AIImageGenerationBackendResponse resp = (AIImageGenerationBackendResponse)apiClient.postObject("/text2image", AIImageGenerationBackendResponse.class, (Object)this.query);
                        AIImageGenerationFrontendResponse finalResp = new AIImageGenerationFrontendResponse();
                        finalResp.requestId = resp.request_id;
                        if (!resp.ok) {
                            logger.warn((Object)"AI was not able to generate that image");
                            finalResp.reason = "AI was not able to generate that image";
                            if (resp.error != null) {
                                finalResp.reason = finalResp.reason + ": " + resp.error;
                            }
                            finalResp.ok = false;
                        } else {
                            logger.info((Object)"AI image successfully generated");
                            finalResp.ok = true;
                            finalResp.url = resp.url;
                            finalResp.b64Json = resp.b64_json;
                            finalResp.prompt = resp.prompt;
                        }
                        aIImageGenerationFrontendResponse = finalResp;
                        if (apiClient == null) break block17;
                    }
                    catch (Throwable resp) {
                        try {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable throwable) {
                                    resp.addSuppressed(throwable);
                                }
                            }
                            throw resp;
                        }
                        catch (IOException e) {
                            logger.error((Object)"IO exception while getting AI image", (Throwable)e);
                            AIImageGenerationFrontendResponse finalResp = new AIImageGenerationFrontendResponse();
                            finalResp.ok = false;
                            finalResp.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                            AIImageGenerationFrontendResponse aIImageGenerationFrontendResponse2 = finalResp;
                            NDC.pop();
                            return aIImageGenerationFrontendResponse2;
                        }
                    }
                    apiClient.close();
                }
                return aIImageGenerationFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class AIImageGenerationFrontendResponse {
        boolean ok;
        String reason;
        @Nullable
        String url;
        @Nullable
        String b64Json;
        String prompt;
        String requestId;
    }

    public static class AIImageGenerationBackendResponse {
        boolean ok;
        String error;
        @Nullable
        String url;
        @Nullable
        String b64_json;
        String prompt;
        String request_id;
    }
}

