/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AISpeechToTextGenerationService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseStatusService licenseStatusService;
    public static final String DEFAULT_URL = "https://ai.api-services.dataiku.io/";
    private static final DKULogger logger = DKULogger.getLogger(AISpeechToTextGenerationService.class);

    public FutureResponse<AISpeechToTextFrontendResponse> startFutureSpeechToText(DSSAuthCtx authCtx, MultipartFile file) throws Exception {
        AISpeechToTextGenerationBackendQuery query = new AISpeechToTextGenerationBackendQuery();
        query.file = file;
        AISpeechToTextGenerationScriptFutureThread futureThread = new AISpeechToTextGenerationScriptFutureThread(authCtx, query);
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AISpeechToTextFrontendResponse>>(){});
    }

    public AISpeechToTextFrontendResponse startSpeechToText(DSSAuthCtx authCtx, MultipartFile file) throws Exception {
        AISpeechToTextFrontendResponse aISpeechToTextFrontendResponse;
        block13: {
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (!FeatureFlags.isEnabled((String)"storiesVocal")) {
                throw new IllegalStateException("Stories AI speech to text generation is not enabled. Please contact an administrator to enable it.");
            }
            LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
            if (ls.community) {
                throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
            }
            String licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
            boolean telemetryEnabled = generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
            String managerURL = DKUApp.getParams().getParam("dku.dada.defaultEndpoint", DEFAULT_URL);
            logger.info((Object)("Querying " + managerURL));
            InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(authCtx, generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
            try {
                File tempFile = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + file.getOriginalFilename());
                file.transferTo(tempFile);
                AISpeechToTextGenerationBackendResponse resp = (AISpeechToTextGenerationBackendResponse)apiClient.postFormAndFileToJSON("/speech2text", AISpeechToTextGenerationBackendResponse.class, tempFile, UUID.randomUUID().toString().replace("-", "") + ".m4a", new Object[]{"licenseId", licenseId, "telemetryEnabled", telemetryEnabled});
                logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                AISpeechToTextFrontendResponse finalResp = new AISpeechToTextFrontendResponse();
                finalResp.requestId = resp.request_id;
                if (!resp.ok) {
                    logger.warn((Object)"AI was not able to transform speech to text");
                    finalResp.reason = "AI was not able to transform that speech to text";
                    if (resp.error != null) {
                        finalResp.reason = finalResp.reason + ": " + resp.error;
                    }
                    finalResp.ok = false;
                } else {
                    finalResp.ok = true;
                    finalResp.prompt = resp.prompt;
                }
                aISpeechToTextFrontendResponse = finalResp;
                if (apiClient == null) break block13;
            }
            catch (Throwable tempFile) {
                try {
                    if (apiClient != null) {
                        try {
                            apiClient.close();
                        }
                        catch (Throwable throwable) {
                            tempFile.addSuppressed(throwable);
                        }
                    }
                    throw tempFile;
                }
                catch (IOException e) {
                    logger.error((Object)"IO exception while getting AI transformation", (Throwable)e);
                    AISpeechToTextFrontendResponse finalResp = new AISpeechToTextFrontendResponse();
                    finalResp.ok = false;
                    finalResp.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                    return finalResp;
                }
            }
            apiClient.close();
        }
        return aISpeechToTextFrontendResponse;
    }

    public static class AISpeechToTextGenerationBackendQuery {
        String licenseId;
        boolean telemetryEnabled;
        MultipartFile file;
    }

    private class AISpeechToTextGenerationScriptFutureThread
    extends SimpleFutureThread<AISpeechToTextFrontendResponse> {
        private final AISpeechToTextGenerationBackendQuery query;
        private final GeneralSettingsDAO.GeneralSettings generalSettings;

        public AISpeechToTextGenerationScriptFutureThread(DSSAuthCtx owner, AISpeechToTextGenerationBackendQuery query) {
            super((AuthCtx)owner);
            this.generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            this.query = query;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_speech_to_text_generation", (String)"AI Speech To Text Generation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AISpeechToTextFrontendResponse compute() throws Exception {
            NDC.push((String)("ai-speechtotext: " + String.valueOf(this.query.file)));
            try {
                AISpeechToTextFrontendResponse aISpeechToTextFrontendResponse;
                if (!FeatureFlags.isEnabled((String)"storiesVocal")) {
                    throw new IllegalStateException("Stories AI speech to text generation is not enabled. Please contact an administrator to enable it.");
                }
                LicenseStatusService.LicensingStatus ls = AISpeechToTextGenerationService.this.licenseStatusService.getLicensingStatus();
                if (ls.community) {
                    throw new IllegalArgumentException("AI services are not available with Dataiku Free Edition");
                }
                this.query.licenseId = ls != null && ls.licenseContent != null ? ls.licenseContent.licenseId : null;
                String managerURL = DKUApp.getParams().getParam("dku.dada.defaultEndpoint", AISpeechToTextGenerationService.DEFAULT_URL);
                logger.info((Object)("Querying " + managerURL));
                NoAuthAPIClient apiClient = new NoAuthAPIClient(managerURL, false, ApplicationConfigurator.getProxySettings(), 30000, 60000);
                try {
                    File tempFile = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + this.query.file.getOriginalFilename());
                    this.query.file.transferTo(tempFile);
                    AISpeechToTextGenerationBackendResponse resp = (AISpeechToTextGenerationBackendResponse)apiClient.postFormAndFileToJSON("/speech2text", AISpeechToTextGenerationBackendResponse.class, tempFile, UUID.randomUUID().toString().replace("-", "") + ".m4a", new Object[]{"licenseId", this.query.licenseId});
                    logger.info((Object)("AI Response: " + JSON.log((Object)resp)));
                    AISpeechToTextFrontendResponse finalResp = new AISpeechToTextFrontendResponse();
                    finalResp.requestId = resp.request_id;
                    if (!resp.ok) {
                        logger.warn((Object)"AI was not able to transform speech to text");
                        finalResp.reason = "AI was not able to transform that speech to text";
                        if (resp.error != null) {
                            finalResp.reason = finalResp.reason + ": " + resp.error;
                        }
                        finalResp.ok = false;
                    } else {
                        finalResp.ok = true;
                        finalResp.prompt = resp.prompt;
                    }
                    aISpeechToTextFrontendResponse = finalResp;
                }
                catch (Throwable tempFile) {
                    try {
                        try {
                            apiClient.close();
                        }
                        catch (Throwable throwable) {
                            tempFile.addSuppressed(throwable);
                        }
                        throw tempFile;
                    }
                    catch (IOException e) {
                        logger.error((Object)"IO exception while getting AI transformation", (Throwable)e);
                        AISpeechToTextFrontendResponse finalResp = new AISpeechToTextFrontendResponse();
                        finalResp.ok = false;
                        finalResp.reason = "Could not get response from AI service: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
                        AISpeechToTextFrontendResponse aISpeechToTextFrontendResponse2 = finalResp;
                        NDC.pop();
                        return aISpeechToTextFrontendResponse2;
                    }
                }
                apiClient.close();
                return aISpeechToTextFrontendResponse;
            }
            finally {
                NDC.pop();
            }
        }
    }

    public static class AISpeechToTextGenerationBackendResponse {
        public boolean ok;
        public String error;
        public String prompt;
        public String request_id;
    }

    public static class AISpeechToTextFrontendResponse {
        public boolean ok;
        public String reason;
        public String prompt;
        public String requestId;
    }
}

