/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.handler;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationKernel;
import com.dataiku.dip.analysis.docgen.model.PythonCommand;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.SecretKeyGenerator;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractPythonHandler<OutputT> {
    private final AuthCtx authCtx;
    protected String projectKey;
    private ModelDocumentGenerationKernel kernel;
    private final PythonCommand pythonCommand;
    private final APITicketService apiTicketService;
    private final String pythonModule;
    private final String phaseName;
    private final Class<? extends OutputT> outputClazz;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.ml.modeldocumentgeneration");

    public AbstractPythonHandler(AuthCtx authCtx, String projectKey, PythonCommand pythonCommand, APITicketService apiTicketService, String pythonModule, String phaseName, Class<? extends OutputT> outputClazz) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.pythonCommand = pythonCommand;
        this.apiTicketService = apiTicketService;
        this.pythonModule = pythonModule;
        this.phaseName = phaseName;
        this.outputClazz = outputClazz;
    }

    public void abort() {
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputT compute() throws Exception {
        Object output;
        block25: {
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), dssPortRange);
            APITicketService.Ticket ticket = this.apiTicketService.createTicket(this.authCtx, "", (Object)this);
            this.kernel = new ModelDocumentGenerationKernel(this.pythonModule, link, ticket, this.authCtx, this.projectKey);
            Exception error = null;
            output = null;
            try {
                this.kernel.start();
                try {
                    output = link.executeAsync((Object)this.pythonCommand, null, this.outputClazz, "Failed to " + this.phaseName + ".").call();
                }
                catch (SocketBlockLinkException e) {
                    logger.error((Object)e.getMessage());
                    throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)("Failed to " + this.phaseName + "."), (Throwable)e);
                error = e;
                return (OutputT)error;
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to " + this.phaseName + "."), (Throwable)e);
                error = e;
                return (OutputT)error;
            }
            finally {
                try {
                    this.kernel.killWithoutMercy();
                }
                catch (Exception e) {
                    logger.error((Object)("Failure while destroying " + this.phaseName + " computation kernel"), (Throwable)e);
                }
                try {
                    link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while closing link to kernel", (Throwable)e);
                }
                this.kernel = null;
                if (error == null) break block25;
                throw error;
            }
        }
        return (OutputT)output;
    }

    public String getPhaseName() {
        return this.phaseName;
    }
}

