/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.partitioning.StratifiedModelUtils;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PackagedFullModelId
extends FullModelId {
    private File modelFolder;

    public PackagedFullModelId(String projectKey, String smId, String versionId, File modelFolder) {
        super(projectKey, smId, versionId);
        this.modelFolder = modelFolder;
    }

    @Override
    @Nullable
    public String getOriginalPythonCodeEnvName() {
        return null;
    }

    @Override
    public File getModelFolder() {
        return this.modelFolder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackagedFullModelId that = (PackagedFullModelId)o;
        return Objects.equals(this.modelFolder, that.modelFolder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.modelFolder);
    }

    @Override
    public String toString() {
        assert (this.type == FullModelId.Type.SAVED) : String.format("Model %s is not a saved model. This should not happen.", this.smId);
        Object smVersion = this.smVersionId;
        if (StringUtils.isNotBlank((String)this.partitionName)) {
            smVersion = (String)smVersion + StratifiedModelUtils.generatePartitionSuffix(this.partitionName, this.partitionVersion);
        }
        return String.format("packaged-S-%s-%s-%s", this.projectKey, this.smId, smVersion);
    }
}

