/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ClustersFacts {
    public List<ClusterFacts> clusters = new ArrayList<ClusterFacts>();
    public ClusterFacts global;

    public static class ClusterFacts {
        public List<ClusterFact> facts = new ArrayList<ClusterFact>();
        public String cluster;
        public long size;
    }

    public static class CategoricalClusterFact
    extends ClusterFact {
        public String category_value;
        public double global_ratio;
        public double current_ratio;
        public double current_impact;
        public final String type = "categorical";

        @Override
        public double interest() {
            return Math.abs(this.diff);
        }
    }

    public static class NumericalClusterFact
    extends ClusterFact {
        public double global_mean;
        public double mean;
        public double std;
        public final String type = "numerical";

        @Override
        public double interest() {
            return Math.abs(this.diff);
        }
    }

    public static abstract class ClusterFact {
        public String cluster_label;
        public String feature_label;
        public double diff;

        public abstract double interest();

        static {
            JSON.registerAdapter(ClusterFact.class, (Object)new JSON.Adapter<ClusterFact>(){

                public ClusterFact deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    String type = jsonObj.get("type").getAsString();
                    if (type != null && type.equals("numerical")) {
                        return (ClusterFact)jsonDeserializationContext.deserialize(jsonElement, NumericalClusterFact.class);
                    }
                    if (type != null && type.equals("categorical")) {
                        return (ClusterFact)jsonDeserializationContext.deserialize(jsonElement, CategoricalClusterFact.class);
                    }
                    throw ErrorContext.iaef((String)"Unknow cluster fact type: %s", (Object)type, (Object[])new Object[0]);
                }

                public JsonElement serialize(ClusterFact cf, Type type, JsonSerializationContext ctx) {
                    return ctx.serialize((Object)cf);
                }
            });
        }
    }
}

