/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.assertions;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class MLAssertionsParams {
    private static final String ML_ASSERTION_MASK_PREFIX = "__dku__ml_assertion_mask_";
    public List<MLAssertion> assertions;

    public MLAssertionsParams() {
        this.assertions = new ArrayList<MLAssertion>();
    }

    public MLAssertionsParams(List<MLAssertion> assertions) {
        this.assertions = assertions;
    }

    public boolean hasAssertions() {
        return this.assertions != null && !this.assertions.isEmpty();
    }

    public static AssertionsAsSteps generateScriptData(List<MLAssertion> assertions) throws Exception {
        ArrayList<ScriptStep> steps = new ArrayList<ScriptStep>();
        Schema outputSchema = new Schema();
        for (MLAssertion assertion : assertions) {
            FilterAndFlagOnCustomFormulaResult.Parameter stepParam = new FilterAndFlagOnCustomFormulaResult.Parameter();
            stepParam.flagColumn = ML_ASSERTION_MASK_PREFIX + assertion.name;
            stepParam.expression = FilterDescUtils.getGrelExpression(assertion.filter);
            stepParam.action = FilterAndFlagProcessor.Action.FLAG;
            steps.add(ProcessorScriptStep.ofType(FilterAndFlagOnCustomFormulaResult.META_FLAG).withParams(stepParam));
            outputSchema.addColumn(stepParam.flagColumn, Type.STRING);
        }
        return new AssertionsAsSteps(steps, outputSchema);
    }

    public static class MLAssertion {
        public String name = "Assertion";
        public FilterDesc filter;
        public AssertionCondition assertionCondition;

        public String toString() {
            return "MLAssertion(" + this.name + ")";
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MLAssertion)) {
                return false;
            }
            MLAssertion otherAssertion = (MLAssertion)other;
            return Objects.equals(this.name, otherAssertion.name) && Objects.equals(this.getFilterId(), otherAssertion.getFilterId()) && Objects.equals(this.assertionCondition, otherAssertion.assertionCondition);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.getFilterId(), this.assertionCondition);
        }

        public String getFilterId() {
            if (this.filter == null) {
                return null;
            }
            return DigestUtils.md5Hex((String)FilterDescUtils.getFilterRepr(this.filter));
        }

        public static class AssertionCondition {
            public double expectedValidRatio = 0.9;
            public String expectedClass;
            public Double expectedMinValue;
            public Double expectedMaxValue;

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AssertionCondition)) {
                    return false;
                }
                AssertionCondition otherCondition = (AssertionCondition)other;
                return Objects.equals(this.expectedValidRatio, otherCondition.expectedValidRatio) && Objects.equals(this.expectedClass, otherCondition.expectedClass) && Objects.equals(this.expectedMaxValue, otherCondition.expectedMaxValue) && Objects.equals(this.expectedMinValue, otherCondition.expectedMinValue);
            }

            public int hashCode() {
                return Objects.hash(this.expectedValidRatio, this.expectedClass, this.expectedMaxValue, this.expectedMinValue);
            }
        }
    }

    public static class AssertionsAsSteps {
        public final List<ScriptStep> steps;
        public final Schema outputSchema;

        AssertionsAsSteps(List<ScriptStep> steps, Schema outputSchema) {
            this.steps = steps;
            this.outputSchema = outputSchema;
        }
    }
}

