/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.exposition.DockerDirectExposition;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.PortForwardExposition;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ContainerSettings {
    public List<ContainerExecRuntimeConfig> executionConfigs = new ArrayList<ContainerExecRuntimeConfig>();
    public String defaultExecutionConfig;
    public String defaultExecutionConfigForVisualRecipesWorkloads;
    public String defaultExecutionConfigForExporters;
    public JsonObject defaultWebappsK8SExposition = ContainerSettings.makeDefaultK8SWebappsExposition();
    public JsonObject defaultWebappsDockerExposition = ContainerSettings.makeDefaultDockerWebappsExposition();
    public ContainerExecRuntimeConfig executionConfigsGenericOverrides = new ContainerExecRuntimeConfig();
    public String cdeBaseImage;
    public boolean cdeEnabled = true;
    public boolean cdePluginSupport = true;
    public boolean autoRebuildCDEImageOnPluginChange = true;

    public ContainerSettings() {
    }

    public ContainerSettings(ContainerSettings containerSettings) {
        containerSettings.executionConfigs.forEach(cfg -> this.executionConfigs.add(cfg.deepCopy()));
        this.defaultExecutionConfig = containerSettings.defaultExecutionConfig;
        this.defaultExecutionConfigForExporters = containerSettings.defaultExecutionConfigForExporters;
        this.defaultExecutionConfigForVisualRecipesWorkloads = containerSettings.defaultExecutionConfigForVisualRecipesWorkloads;
        this.defaultWebappsK8SExposition = containerSettings.defaultWebappsK8SExposition.deepCopy();
        this.defaultWebappsDockerExposition = containerSettings.defaultWebappsDockerExposition.deepCopy();
        this.executionConfigsGenericOverrides = containerSettings.executionConfigsGenericOverrides.deepCopy();
        this.cdeEnabled = containerSettings.cdeEnabled;
        this.autoRebuildCDEImageOnPluginChange = containerSettings.autoRebuildCDEImageOnPluginChange;
        this.cdePluginSupport = containerSettings.cdePluginSupport;
        this.cdeBaseImage = containerSettings.cdeBaseImage;
    }

    public ContainerSettings deepCopy() {
        return new ContainerSettings(this);
    }

    public ContainerExecRuntimeConfig getByName(String name) throws NotFoundException {
        ContainerExecRuntimeConfig configuration = this.getByNameOrNull(name);
        if (configuration == null) {
            throw new NotFoundException("Container configuration not found: " + name);
        }
        return configuration;
    }

    public ContainerExecRuntimeConfig getByNameOrNull(String name) {
        return this.executionConfigs.stream().filter(config -> config.name.equals(name)).findFirst().orElse(null);
    }

    public List<ContainerExecRuntimeConfig> listConfigsForWorkloadType(@Nullable WorkloadType workloadType) {
        if (workloadType == null) {
            return this.executionConfigs;
        }
        return this.executionConfigs.stream().filter(c2 -> c2.supportsWorkloadType(workloadType)).collect(Collectors.toList());
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
    }

    private static JsonObject makeDefaultK8SWebappsExposition() {
        Exposition ret = new Exposition().withType(PortForwardExposition.META.getType());
        try {
            ret.params = PortForwardExposition.META.getParamsClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSON.toJsonObject((Object)ret, (String[])new String[0]);
    }

    private static JsonObject makeDefaultDockerWebappsExposition() {
        Exposition ret = new Exposition().withType(DockerDirectExposition.META.getType());
        try {
            ret.params = DockerDirectExposition.META.getParamsClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JSON.toJsonObject((Object)ret, (String[])new String[0]);
    }
}

