/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.impala.HighAvailabilityHost;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.google.common.collect.Lists;
import java.util.List;

public class ImpalaSettings {
    public boolean enabled;
    public boolean useSimbaDriver;
    public AuthBehavior authBehavior = AuthBehavior.KERBEROS_FALLBACK_NOAUTH;
    public String principal;
    public String user;
    public String password;
    public DSSConnection.CredentialsMode credentialsMode = DSSConnection.CredentialsMode.GLOBAL;
    public boolean useSsl = false;
    public boolean isSelfSigned = false;
    public String trustStorePath;
    public String trustStorePassword;
    public List<HighAvailabilityHost> datanodes = Lists.newArrayList();
    public int port = 21050;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes = true;
    public String additionalUserToGrantAccessToWhenImpersonating = "impala";
    public boolean useURL;
    public String driver;
    public String url;
    public String displayedUrl;
    public ClusterPropertyList connectionProperties = new ClusterPropertyList();
    public GlobalImpalaEngineCreationSettings engineCreationSettings = new GlobalImpalaEngineCreationSettings();

    public ImpalaSettings() {
    }

    public ImpalaSettings(ImpalaSettings impalaSettings) {
        this.enabled = impalaSettings.enabled;
        this.useSimbaDriver = impalaSettings.useSimbaDriver;
        this.authBehavior = impalaSettings.authBehavior;
        this.principal = impalaSettings.principal;
        this.user = impalaSettings.user;
        this.password = impalaSettings.password;
        this.credentialsMode = impalaSettings.credentialsMode;
        this.useSsl = impalaSettings.useSsl;
        this.isSelfSigned = impalaSettings.isSelfSigned;
        this.trustStorePath = impalaSettings.trustStorePath;
        this.trustStorePassword = impalaSettings.trustStorePassword;
        impalaSettings.datanodes.forEach(n -> this.datanodes.add(n.deepCopy()));
        this.port = impalaSettings.port;
        this.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes = impalaSettings.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes;
        this.additionalUserToGrantAccessToWhenImpersonating = impalaSettings.additionalUserToGrantAccessToWhenImpersonating;
        this.useURL = impalaSettings.useURL;
        this.driver = impalaSettings.driver;
        this.url = impalaSettings.url;
        this.displayedUrl = impalaSettings.displayedUrl;
        this.connectionProperties = impalaSettings.connectionProperties.deepCopy();
        this.engineCreationSettings = new GlobalImpalaEngineCreationSettings(impalaSettings.engineCreationSettings);
    }

    public ImpalaSettings deepCopy() {
        return new ImpalaSettings(this);
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        this.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.password);
        this.trustStorePassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.trustStorePassword);
        for (ClusterProperty property : this.connectionProperties) {
            if (!property.secret) continue;
            property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
        }
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.password = cryptoService.decryptIfEncrypted(this.password);
        this.trustStorePassword = cryptoService.decryptIfEncrypted(this.trustStorePassword);
        for (ClusterProperty property : this.connectionProperties) {
            if (!property.secret) continue;
            property.value = cryptoService.decryptIfEncrypted(property.value);
        }
    }

    public static enum AuthBehavior {
        KERBEROS_FALLBACK_NOAUTH,
        LDAP,
        KERBEROS,
        NOAUTH;

    }

    public static class GlobalImpalaEngineCreationSettings {
        public boolean streamMode = true;

        GlobalImpalaEngineCreationSettings() {
        }

        GlobalImpalaEngineCreationSettings(GlobalImpalaEngineCreationSettings setting) {
            this.streamMode = setting.streamMode;
        }
    }
}

