/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.PythonCodeEnvUtils;
import com.dataiku.dip.code.RCodeEnvUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class CodeEnvImportUtils {
    public static CodeEnvModel.PythonEnvDesc importPythonEnvInFolder(AuthCtx authCtx, File targetDir, File exportedEnvDir, File logDir, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, CodeEnvModel.EnvImportSpecificationMode specMode, DKUtils.SmartLogTailBuilder logTailBuilder, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(targetDir);
        File versionDescFolder = new File(targetDir, "desc");
        File versionEnvFolder = new File(targetDir, "env");
        CodeEnvModel.PythonEnvDesc pythonEnvDesc = null;
        DKUFileUtils.mkdirs((File)versionDescFolder);
        FileUtils.copyFileToDirectory((File)new File(exportedEnvDir, "desc.json"), (File)versionDescFolder);
        pythonEnvDesc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(versionDescFolder, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
        if (deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED) {
            CodeEnvImportUtils.copyPythonFilesAccordingtoSpecMode(exportedEnvDir, specMode, versionDescFolder);
            File log = ApplicationConfigurator.getFile((File)logDir, (String[])new String[]{"importPythonEnv.log"});
            DKUFileUtils.mkdirsParent((File)log);
            PythonCodeEnvUtils.createEmptyPyEnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, overrideDescDirSettings);
            pythonEnvDesc = PythonCodeEnvUtils.installPyEnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, overrideDescDirSettings);
            CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.PYTHON, targetDir, logTailBuilder, log);
        }
        CodeEnvImportUtils.markManagedReady(targetDir);
        return pythonEnvDesc;
    }

    public static void registerPythonEnvInFolder(AuthCtx authCtx, File targetDir, File exportedEnvDir, File builtEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws Exception {
        File resourcesFolder;
        File modelsMetadataFile;
        CodeEnvImportUtils.markManagedNotReady(targetDir);
        File versionDescFolder = new File(targetDir, "desc");
        File versionEnvFolder = new File(targetDir, "env");
        DKUFileUtils.forceCreateSymbolicLink((Path)versionEnvFolder.toPath(), (Path)builtEnvDir.toPath());
        DKUFileUtils.mkdirs((File)versionDescFolder);
        FileUtils.copyFileToDirectory((File)new File(exportedEnvDir, "desc.json"), (File)versionDescFolder);
        CodeEnvImportUtils.copyPythonFilesAccordingtoSpecMode(exportedEnvDir, specMode, versionDescFolder);
        File resourcesEnvFile = DKUFileUtils.getWithin((File)builtEnvDir, (String[])new String[]{"resources_env.json"});
        if (resourcesEnvFile.exists()) {
            FileUtils.copyFileToDirectory((File)resourcesEnvFile, (File)DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual"}));
        }
        if ((modelsMetadataFile = DKUFileUtils.getWithin((File)builtEnvDir, (String[])new String[]{"models_meta.json"})).exists()) {
            FileUtils.copyFileToDirectory((File)modelsMetadataFile, (File)DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual"}));
        }
        if ((resourcesFolder = new File(builtEnvDir, "resources")).exists()) {
            File versionResourcesFolder = new File(targetDir, "resources");
            DKUFileUtils.forceCreateSymbolicLink((Path)versionResourcesFolder.toPath(), (Path)resourcesFolder.toPath());
        }
        CodeEnvImportUtils.markManagedReady(targetDir);
    }

    public static CodeEnvModel.REnvDesc importREnvInFolder(AuthCtx authCtx, File targetDir, File exportedEnvDir, File logDir, CodeEnvModel.CodeEnvDeploymentMode deploymentMode, CodeEnvModel.EnvImportSpecificationMode specMode, DKUtils.SmartLogTailBuilder logTailBuilder, @Nullable GeneralSettingsDAO.AbstractCodeEnvExtraSettings overrideDescDirSettings) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(targetDir);
        File versionDescFolder = new File(targetDir, "desc");
        File versionEnvFolder = new File(targetDir, "env");
        DKUFileUtils.mkdirs((File)versionDescFolder);
        FileUtils.copyFileToDirectory((File)new File(exportedEnvDir, "desc.json"), (File)versionDescFolder);
        CodeEnvModel.REnvDesc rEnvDesc = null;
        if (deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED && deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.BUSINESS_APP_NON_MANAGED) {
            CodeEnvImportUtils.copyCommonFilesAccordingToSpecMode(versionDescFolder, specMode, exportedEnvDir, CodeEnvModel.EnvLang.R);
            File log = ApplicationConfigurator.getFile((File)logDir, (String[])new String[]{"importREnv.log"});
            DKUFileUtils.mkdirsParent((File)log);
            RCodeEnvUtils.createEmptyREnvFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, overrideDescDirSettings);
            rEnvDesc = RCodeEnvUtils.installREnvPackagesFromDescDir(authCtx, versionDescFolder, versionEnvFolder, logTailBuilder, log, overrideDescDirSettings);
            CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(authCtx, CodeEnvModel.EnvLang.R, targetDir, logTailBuilder, log);
        }
        CodeEnvImportUtils.markManagedReady(targetDir);
        return rEnvDesc;
    }

    public static void registerREnvInFolder(AuthCtx authCtx, File targetDir, File exportedEnvDir, File builtEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode) throws Exception {
        CodeEnvImportUtils.markManagedNotReady(targetDir);
        File versionDescFolder = new File(targetDir, "desc");
        File versionEnvFolder = new File(targetDir, "env");
        DKUFileUtils.forceCreateSymbolicLink((Path)versionEnvFolder.toPath(), (Path)builtEnvDir.toPath());
        DKUFileUtils.mkdirs((File)versionDescFolder);
        FileUtils.copyFileToDirectory((File)new File(exportedEnvDir, "desc.json"), (File)versionDescFolder);
        CodeEnvImportUtils.copyCommonFilesAccordingToSpecMode(versionDescFolder, specMode, exportedEnvDir, CodeEnvModel.EnvLang.R);
        CodeEnvImportUtils.markManagedReady(targetDir);
    }

    static void updateEnvFolderSnapshotFromActualData(AuthCtx authCtx, CodeEnvModel.EnvLang envLang, File envFolder, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        File descDir = new File(envFolder, "desc");
        switch (envLang) {
            case PYTHON: {
                CodeEnvModel.PythonEnvActualData fullData = PythonCodeEnvUtils.computePyEnvActualData(authCtx, CodeEnvImportUtils.f(envFolder, "env"), logTailBuilder, log);
                CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(envLang, descDir, fullData);
                CodeEnvModel.PythonEnvInfo envInfo = new CodeEnvModel.PythonEnvInfo();
                envInfo.pythonVersion = fullData.pythonVersion;
                FileUtils.writeStringToFile((File)CodeEnvImportUtils.f(descDir, "actual/info.json"), (String)JSON.json((Object)envInfo), (Charset)StandardCharsets.UTF_8);
                break;
            }
            case R: {
                CodeEnvModel.REnvActualData fullData = RCodeEnvUtils.computeREnvActualData(authCtx, CodeEnvImportUtils.f(envFolder, "env"), logTailBuilder, log);
                CodeEnvImportUtils.updateEnvFolderSnapshotFromActualData(envLang, descDir, fullData);
                break;
            }
        }
    }

    private static void copyCommonFilesAccordingToSpecMode(File versionDescFolder, CodeEnvModel.EnvImportSpecificationMode specMode, File exportedEnvDir, CodeEnvModel.EnvLang envLang) throws IOException {
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "spec"));
        DKUFileUtils.mkdirs((File)new File(versionDescFolder, "actual"));
        ArrayList<File> filesToCopy = new ArrayList<File>();
        switch (specMode) {
            case ACTUAL: {
                filesToCopy.add(new File(exportedEnvDir, "actual/" + envLang.getPackageFileName()));
                filesToCopy.add(new File(exportedEnvDir, "actual/environment.spec"));
                break;
            }
            case SPECIFIED: {
                filesToCopy.add(new File(exportedEnvDir, "spec/" + envLang.getPackageFileName()));
                filesToCopy.add(new File(exportedEnvDir, "spec/environment.spec"));
            }
        }
        for (File file : filesToCopy) {
            if (!file.exists()) continue;
            FileUtils.copyFileToDirectory((File)file, (File)new File(versionDescFolder, "spec"));
        }
    }

    private static void copyPythonFilesAccordingtoSpecMode(File exportedEnvDir, CodeEnvModel.EnvImportSpecificationMode specMode, File versionDescFolder) throws IOException {
        CodeEnvImportUtils.copyCommonFilesAccordingToSpecMode(versionDescFolder, specMode, exportedEnvDir, CodeEnvModel.EnvLang.PYTHON);
        File resourcesInitScript = DKUFileUtils.getWithin((File)exportedEnvDir, (String[])new String[]{"spec", "resources_init.py"});
        if (resourcesInitScript.exists()) {
            FileUtils.copyFileToDirectory((File)resourcesInitScript, (File)DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"spec"}));
        }
    }

    private static void updateEnvFolderSnapshotFromActualData(CodeEnvModel.EnvLang envLang, File descDir, CodeEnvModel.AbstractEnvActualData fullData) throws IOException {
        if (fullData.conda) {
            File actualSpecFile = CodeEnvImportUtils.f(descDir, "actual/environment.spec");
            DKUFileUtils.mkdirsParent((File)actualSpecFile);
            FileUtils.writeStringToFile((File)actualSpecFile, (String)fullData.condaEnvSpec, (Charset)StandardCharsets.UTF_8);
        }
        File actualReqsFile = CodeEnvImportUtils.f(descDir, "actual/" + envLang.getPackageFileName());
        DKUFileUtils.mkdirsParent((File)actualReqsFile);
        FileUtils.writeStringToFile((File)actualReqsFile, (String)fullData.nocondaEnvSpec, (Charset)StandardCharsets.UTF_8);
    }

    public static void markManagedReady(File versionFolder) throws IOException {
        DKUFileUtils.createIfNotExists((File)new File(versionFolder, "ready.txt"));
    }

    public static void markManagedNotReady(File versionFolder) throws IOException {
        File readyFile = new File(versionFolder, "ready.txt");
        if (readyFile.exists()) {
            DKUFileUtils.forceDelete((File)readyFile);
        }
    }

    public static AutoDelete getTempImportFolder(String prefix) throws IOException {
        return DSSTempUtils.getTempFolder((String)"codeenv-import", (String)prefix);
    }

    private static File f(File f, String ... chunks) {
        return new File(f, StringUtils.join((Object[])chunks, (String)"/"));
    }
}

