/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeEnvPermissionsService {
    @Autowired
    private IPermissionsService permissionsService;
    private static Logger logger = Logger.getLogger((String)"dip.codeenv.permissions");

    public void failIfCodeEnvNotUsable(String projectKey, Object meta, Object params, Object preExisting, AuthCtx authCtx) throws DKUSecurityException {
        if (meta instanceof MetaWithSelectableCodeEnv) {
            MetaWithSelectableCodeEnv metaWithSelectableCodeEnv = (MetaWithSelectableCodeEnv)meta;
            this.failIfCodeEnvNotUsable(projectKey, metaWithSelectableCodeEnv.getEnvLang(), (ParamsWithSelectableCodeEnv)params, (ParamsWithSelectableCodeEnv)preExisting, authCtx);
        }
    }

    public void failIfCodeEnvNotUsable(String projectKey, CodeEnvModel.EnvLang envLang, ParamsWithSelectableCodeEnv params, ParamsWithSelectableCodeEnv preExisting, AuthCtx authCtx) throws DKUSecurityException {
        CodeEnvSelection envSelection = params.getCodeEnvSelection();
        logger.info((Object)("Check usability of " + JSON.log((Object)envSelection) + " in " + projectKey));
        CodeEnvSelector codeEnvSelector = new CodeEnvSelector();
        try {
            logger.info((Object)("Would use " + (switch (envLang) {
                case CodeEnvModel.EnvLang.PYTHON -> codeEnvSelector.selectForPythonRecipe(projectKey, envSelection);
                case CodeEnvModel.EnvLang.JULIA -> codeEnvSelector.selectForJuliaRecipe(projectKey, envSelection);
                case CodeEnvModel.EnvLang.R -> codeEnvSelector.selectForRRecipe(projectKey, envSelection);
                default -> throw new Error("unreachable");
            }) + " when running"));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new DKUSecurityException("Selection of code env is prevented by project's settings", (Throwable)e);
        }
        if (envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV && StringUtils.isNotBlank((String)envSelection.envName)) {
            logger.info((Object)"Env explicitely selected, verify usability");
            if (!this.permissionsService.hasCodeEnvPrivilege(authCtx, envLang, envSelection.envName, Privileges.CodeEnvLevelPrivilegeType.USE)) {
                logger.info((Object)"Not usable by this user, check if it is a pre-existing setup");
                if (preExisting != null) {
                    CodeEnvSelection oldEnvSelection = preExisting.getCodeEnvSelection();
                    if (!envSelection.envName.equals(oldEnvSelection.envName)) {
                        throw new DKUSecurityException("You cannot use code env " + envSelection.envName + " because its setup does not grant you 'usage' permission.").withCode((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NO_USAGE_PERMISSION);
                    }
                } else {
                    throw new DKUSecurityException("You cannot use code env " + envSelection.envName + " because its setup does not grant you 'usage' permission.").withCode((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NO_USAGE_PERMISSION);
                }
            }
        }
    }

    public void failIfCodeEnvNotUsable(CodeEnvModel.EnvLang envLang, String envName, AuthCtx authCtx) throws DKUSecurityException {
        if (!this.permissionsService.hasCodeEnvPrivilege(authCtx, envLang, envName, Privileges.CodeEnvLevelPrivilegeType.USE)) {
            throw new DKUSecurityException("You cannot use code env " + envName + " because its setup does not grant you 'usage' permission.").withCode((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_NO_USAGE_PERMISSION);
        }
    }
}

