/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.CondaEnvUtils;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.code.ICodeEnvResolutionService;
import com.dataiku.dip.code.PythonCodeEnvPackagesUtils;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeEnvResolutionService
implements ICodeEnvResolutionService {
    @Autowired
    private DesignNodeCodeEnvsAccessService designNodeCodeEnvsAccessService;
    @Autowired
    private AutomationNodeCodeEnvsAccessService automationNodeCodeEnvsAccessService;
    public static final String CODE_ENV_NAME_ENV_VAR_NAME = "DKU_CODE_ENV_NAME";
    public static final String CODE_ENV_RESOURCES_PATH_ENV_VAR_NAME = "DKU_CODE_ENV_RESOURCES_PATH";
    private static final String rBinary = DKUtils.isOsWindows() ? "bin/R.cmd" : "bin/R";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.code.envs.resolution");

    public static File getEnvDescDir(String envName, CodeEnvModel.EnvLang envLang, String versionOrBundleId) {
        return CodeEnvResolutionService.getEnvDescDir(envName, envLang, versionOrBundleId, ApplicationConfigurator.getNodeType());
    }

    public static File[] getEnvDescDirs(String envName, CodeEnvModel.EnvLang envLang) throws IOException {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
            CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
            if (rootDef.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED) {
                File[] files = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "versions"}).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() && f.getName().startsWith("v.");
                    }
                });
                if (files == null) {
                    return new File[0];
                }
                for (int i = 0; i < files.length; ++i) {
                    files[i] = new File(files[i], "desc");
                }
                return files;
            }
        }
        return new File[]{CodeEnvResolutionService.getEnvDescDir(envName, envLang, null)};
    }

    public static File getEnvDescDir(String envName, CodeEnvModel.EnvLang envLang, String versionOrBundleId, ApplicationConfigurator.DSSNodeType nodeType) {
        if (nodeType != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            return DKUApp.getFile((String[])new String[]{"code-envs", "desc", envLang.getFolderName(), envName});
        }
        return CodeEnvResolutionService.getAutomationEnvDir(envName, envLang, versionOrBundleId, "desc");
    }

    public static File getEnvResourcesDir(String envName, CodeEnvModel.EnvLang envLang, String versionOrBundleId, ApplicationConfigurator.DSSNodeType nodeType) {
        if (nodeType != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            return DKUApp.getFile((String[])new String[]{"code-envs", "resources", envLang.getFolderName(), envName});
        }
        return CodeEnvResolutionService.getAutomationEnvDir(envName, envLang, versionOrBundleId, "resources");
    }

    public static File getActualEnvDir(String envName, CodeEnvModel.EnvLang envLang, String versionOrBundleId, ApplicationConfigurator.DSSNodeType nodeType) {
        if (nodeType != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            return DKUApp.getFile((String[])new String[]{"code-envs", envLang.getFolderName(), envName});
        }
        return CodeEnvResolutionService.getAutomationEnvDir(envName, envLang, versionOrBundleId, "env");
    }

    private static File getAutomationEnvDir(String envName, CodeEnvModel.EnvLang envLang, String versionOrBundleId, String folderName) {
        if (versionOrBundleId == null) {
            return DKUApp.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, folderName});
        }
        if (versionOrBundleId.startsWith("v.")) {
            return DKUApp.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "versions", versionOrBundleId, folderName});
        }
        if (versionOrBundleId.startsWith("bundle-")) {
            return DKUApp.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName, "links", versionOrBundleId, folderName});
        }
        throw new IllegalArgumentException("Unknown code env version or bundle id: " + versionOrBundleId);
    }

    public String getEnvVersionToUseForContainerImageLookup(String envName, CodeEnvModel.EnvLang envLang, String projectKey) throws IOException {
        return CodeEnvResolutionService.getEnvVersionToUseForContainerImageLookup(envName, envLang, projectKey, ApplicationConfigurator.getNodeType());
    }

    public static String getEnvVersionToUseForContainerImageLookup(String envName, CodeEnvModel.EnvLang envLang, String projectKey, ApplicationConfigurator.DSSNodeType nodeType) throws IOException {
        if (envName == null || "__BUILTIN_ENV__".equals(envName) || nodeType != ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            return null;
        }
        File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", envLang.getFolderName(), envName});
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        switch (rootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Non-managed code environment " + String.valueOf((Object)rootDef.deploymentMode));
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
            }
            case AUTOMATION_SINGLE: 
            case DSS_INTERNAL: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: {
                return null;
            }
            case AUTOMATION_VERSIONED: {
                String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                return AutomationNodeManagedEnvUtils.getBundleSuffix(projectKey, bundleId);
            }
        }
        return null;
    }

    public void checkEnvExists(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        if (StringUtils.isEmpty((String)envName) || StringUtils.equals((String)"__BUILTIN_ENV__", (String)envName)) {
            return;
        }
        switch (ApplicationConfigurator.getNodeType()) {
            case AUTOMATION: {
                this.automationNodeCodeEnvsAccessService.checkEnvExists(envLang, envName);
                break;
            }
            case DESIGN: {
                this.designNodeCodeEnvsAccessService.checkEnvExists(envLang, envName);
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    @Override
    public List<String> getPythonCmd(String envName, String projectKey, List<String> args) throws IOException {
        return this.getPythonCmdAndGetBundleIdIfNull(envName, projectKey, null, args);
    }

    @Override
    public Map<String, String> getEnvironmentVariablesForPythonCmd(String envName, String projectKey) throws IOException {
        HashMap<String, String> environmentVariablesForPythonCmd = new HashMap<String, String>();
        if (envName != null && !"__BUILTIN_ENV__".equals(envName)) {
            ApplicationConfigurator.DSSNodeType nodeType;
            if (StringUtils.isNotBlank((String)envName)) {
                environmentVariablesForPythonCmd.put(CODE_ENV_NAME_ENV_VAR_NAME, envName);
            }
            if ((nodeType = ApplicationConfigurator.getNodeType()) == ApplicationConfigurator.DSSNodeType.DESIGN) {
                File specRequirementsFile;
                StandardPythonInterpreter pythonInterpreter;
                File resourcesRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "resources", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                environmentVariablesForPythonCmd.put(CODE_ENV_RESOURCES_PATH_ENV_VAR_NAME, resourcesRootDir.getAbsolutePath());
                File resourcesEnvVariablesFile = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "actual", "resources_env.json"});
                if (resourcesEnvVariablesFile.exists()) {
                    CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvVariablesFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                    environmentVariablesForPythonCmd.putAll(resourcesEnvVariables.resolve(resourcesRootDir));
                }
                if ((pythonInterpreter = this.getPythonInterpreterVersion(envName, projectKey)) != null && (specRequirementsFile = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName, "spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()})).exists()) {
                    String specRequirements = DKUFileUtils.readFileToStringUTF8((File)specRequirementsFile);
                    File rootDir = CodeEnvResolutionService.getActualEnvDir(envName, CodeEnvModel.EnvLang.PYTHON, null, nodeType);
                    PythonCodeEnvPackagesUtils.updateEnvWithPipInstalledCUDA(environmentVariablesForPythonCmd, pythonInterpreter, specRequirements, rootDir.getAbsolutePath());
                }
            } else {
                File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"env.json"}), CodeEnvModel.AutomationEnvRootDef.class);
                switch (rootDef.deploymentMode) {
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: 
                    case EXTERNAL_CONDA_NAMED: {
                        break;
                    }
                    case AUTOMATION_SINGLE: 
                    case DSS_INTERNAL: 
                    case PLUGIN_MANAGED: 
                    case BUSINESS_APP_MANAGED: {
                        File specRequirementsFile;
                        StandardPythonInterpreter pythonInterpreter;
                        File resourcesRootDir = ApplicationConfigurator.getFile((File)envRootDir, (String[])new String[]{"resources"});
                        environmentVariablesForPythonCmd.put(CODE_ENV_RESOURCES_PATH_ENV_VAR_NAME, resourcesRootDir.getAbsolutePath());
                        File resourcesEnvVariablesFile = ApplicationConfigurator.getFile((File)envRootDir, (String[])new String[]{"desc", "actual", "resources_env.json"});
                        if (resourcesEnvVariablesFile.exists()) {
                            CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvVariablesFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                            environmentVariablesForPythonCmd.putAll(resourcesEnvVariables.resolve(resourcesRootDir));
                        }
                        if ((pythonInterpreter = this.getPythonInterpreterVersion(envName, projectKey)) == null || !(specRequirementsFile = ApplicationConfigurator.getFile((File)envRootDir, (String[])new String[]{"desc", "spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()})).exists()) break;
                        String specRequirements = DKUFileUtils.readFileToStringUTF8((File)specRequirementsFile);
                        File rootDir = CodeEnvResolutionService.getActualEnvDir(envName, CodeEnvModel.EnvLang.PYTHON, null, nodeType);
                        PythonCodeEnvPackagesUtils.updateEnvWithPipInstalledCUDA(environmentVariablesForPythonCmd, pythonInterpreter, specRequirements, rootDir.getAbsolutePath());
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        File specRequirementsFile;
                        StandardPythonInterpreter pythonInterpreter;
                        String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                        if (versionRef == null) {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                        }
                        File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                        File resourcesRootDir = ApplicationConfigurator.getFile((File)envVersionDir, (String[])new String[]{"resources"});
                        environmentVariablesForPythonCmd.put(CODE_ENV_RESOURCES_PATH_ENV_VAR_NAME, resourcesRootDir.getAbsolutePath());
                        File resourcesEnvVariablesFile = ApplicationConfigurator.getFile((File)envVersionDir, (String[])new String[]{"desc", "actual", "resources_env.json"});
                        if (resourcesEnvVariablesFile.exists()) {
                            CodeEnvModel.CodeEnvResourcesEnvVariables resourcesEnvVariables = (CodeEnvModel.CodeEnvResourcesEnvVariables)JSON.parseFile((File)resourcesEnvVariablesFile, CodeEnvModel.CodeEnvResourcesEnvVariables.class);
                            environmentVariablesForPythonCmd.putAll(resourcesEnvVariables.resolve(resourcesRootDir));
                        }
                        if ((pythonInterpreter = this.getPythonInterpreterVersion(envName, projectKey)) == null || !(specRequirementsFile = ApplicationConfigurator.getFile((File)envVersionDir, (String[])new String[]{"desc", "spec", CodeEnvModel.EnvLang.PYTHON.getPackageFileName()})).exists()) break;
                        String specRequirements = DKUFileUtils.readFileToStringUTF8((File)specRequirementsFile);
                        File rootDir = CodeEnvResolutionService.getActualEnvDir(envName, CodeEnvModel.EnvLang.PYTHON, versionRef.envVersion, nodeType);
                        PythonCodeEnvPackagesUtils.updateEnvWithPipInstalledCUDA(environmentVariablesForPythonCmd, pythonInterpreter, specRequirements, rootDir.getAbsolutePath());
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                }
            }
        }
        return environmentVariablesForPythonCmd;
    }

    @Override
    public String getYarnPythonBin(String envName, String projectKey) throws IOException {
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            return System.getenv("PYSPARK_PYTHON");
        }
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
            File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
            CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
            return desc.yarnPythonBin;
        }
        File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        switch (rootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: 
            case AUTOMATION_SINGLE: 
            case DSS_INTERNAL: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: {
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(new File(envRootDir, "desc"), "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                return desc.yarnPythonBin;
            }
            case AUTOMATION_VERSIONED: {
                String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                if (versionRef == null) {
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                }
                File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(new File(envVersionDir, "desc"), "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                return desc.yarnPythonBin;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
            }
        }
        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Unknown env mode: " + String.valueOf((Object)rootDef.deploymentMode));
    }

    public StandardPythonInterpreter getPythonInterpreterVersion(String envName, String projectKey) throws IOException {
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            return null;
        }
        this.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, envName);
        switch (ApplicationConfigurator.getNodeType()) {
            case DESIGN: {
                File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                return this.designNodeCodeEnvsAccessService.getPythonInterpreter(desc);
            }
            case AUTOMATION: {
                File envDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                return this.automationNodeCodeEnvsAccessService.getPythonInterpreter(envName, projectKey, null, rootDef);
            }
        }
        throw new Error("unreachable");
    }

    public List<String> getPythonCmdAndGetBundleIdIfNull(String envName, String projectKey, String bundleId, List<String> args) throws IOException {
        List<String> cmd = new ArrayList<String>();
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            logger.info((Object)"Executing Python activity in builtin env");
            String pythonBin = System.getenv("DKUPYTHONBIN");
            if (pythonBin == null) {
                throw new Error("environment variable DKUPYTHONBIN not defined");
            }
            cmd.add(new File(pythonBin).getAbsolutePath());
            CodeEnvResolutionService.addPythonCmdArgs(cmd, args);
        } else {
            ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
            logger.info((Object)("Executing Python activity in env: " + envName));
            this.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, envName);
            if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
                File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                if (desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                    cmd = this.getPythonCommandForConda(desc.externalCondaEnvName, args);
                } else {
                    File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                    cmd = this.getPythonCommandForEnvRoot(envRootDir, args);
                }
            } else {
                File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                switch (rootDef.deploymentMode) {
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: {
                        cmd = this.getPythonCommandForEnvRoot(new File(envRootDir, "env"), args);
                        break;
                    }
                    case AUTOMATION_SINGLE: 
                    case DSS_INTERNAL: 
                    case PLUGIN_MANAGED: 
                    case BUSINESS_APP_MANAGED: {
                        cmd = this.getPythonCommandForEnvRoot(new File(envRootDir, "env"), args);
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        bundleId = bundleId == null ? CommonBundleUtils.getActiveBundleId(projectKey) : bundleId;
                        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                        if (versionRef == null) {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                        }
                        File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                        cmd = this.getPythonCommandForEnvRoot(new File(envVersionDir, "env"), args);
                        break;
                    }
                    case EXTERNAL_CONDA_NAMED: {
                        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(envRootDir, "desc/desc.json"), CodeEnvModel.PythonEnvDesc.class);
                        cmd = this.getPythonCommandForConda(desc.externalCondaEnvName, args);
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                }
            }
        }
        return cmd;
    }

    private List<String> getPythonCommandForConda(String condaEnvName, List<String> args) throws IOException {
        String prefix = CondaEnvUtils.getEnvPrefix(condaEnvName);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "conda-support", "conda-run.sh"}).getAbsolutePath());
        cmd.add(prefix);
        cmd.add("python");
        CodeEnvResolutionService.addPythonCmdArgs(cmd, args);
        return cmd;
    }

    private List<String> getPythonCommandForEnvRoot(File envRootDir, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (new File(envRootDir, "conda-meta").isDirectory()) {
            cmd.add(ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "conda-support", "conda-run.sh"}).getAbsolutePath());
            cmd.add(envRootDir.getAbsolutePath());
            cmd.add("python");
            CodeEnvResolutionService.addPythonCmdArgs(cmd, args);
        } else {
            cmd.add(new File(envRootDir, CodeEnvPackageSystems.pythonBinary).getAbsolutePath());
            CodeEnvResolutionService.addPythonCmdArgs(cmd, args);
        }
        return cmd;
    }

    private static void addPythonCmdArgs(List<String> cmd, List<String> args) {
        cmd.add("-u");
        cmd.addAll(args);
    }

    public List<String> getRCmd(String envName, String projectKey, List<String> args) throws IOException {
        return this.getRCmdAndGetBundleIdIfNull(envName, projectKey, null, args);
    }

    public List<String> getRCmdAndGetBundleIdIfNull(String envName, String projectKey, String bundleId, List<String> args) throws IOException {
        List<String> cmd = new ArrayList<String>();
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            logger.info((Object)"Executing R activity in builtin env");
            String rBin = System.getenv("DKURBIN");
            if (rBin == null) {
                throw new Error("environment variable DKURBIN not defined");
            }
            cmd.add(new File(rBin).getAbsolutePath());
            cmd.add("--quiet");
            cmd.add("--no-save");
            if (!args.isEmpty() && "-e".equals(args.get(0))) {
                cmd.addAll(args);
            } else {
                cmd.add("--args");
                cmd.addAll(args);
            }
        } else {
            ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
            logger.info((Object)("Executing R activity in env: " + envName));
            this.checkEnvExists(CodeEnvModel.EnvLang.R, envName);
            if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
                File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.REnvDesc.class);
                if (desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                    cmd = this.getRCommandForConda(desc.externalCondaEnvName, args);
                } else {
                    File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                    cmd = this.getRCommandForEnvRoot(envRootDir, args);
                }
            } else {
                File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                switch (rootDef.deploymentMode) {
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: {
                        cmd = this.getRCommandForEnvRoot(new File(envRootDir, "env"), args);
                        break;
                    }
                    case AUTOMATION_SINGLE: 
                    case DSS_INTERNAL: 
                    case PLUGIN_MANAGED: 
                    case BUSINESS_APP_MANAGED: {
                        cmd = this.getRCommandForEnvRoot(new File(envRootDir, "env"), args);
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        bundleId = bundleId == null ? CommonBundleUtils.getActiveBundleId(projectKey) : bundleId;
                        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId);
                        if (versionRef == null) {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                        }
                        File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.R, envName, versionRef.envVersion);
                        cmd = this.getRCommandForEnvRoot(new File(envVersionDir, "env"), args);
                        break;
                    }
                    case EXTERNAL_CONDA_NAMED: {
                        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(envRootDir, "desc/desc.json"), CodeEnvModel.REnvDesc.class);
                        cmd = this.getRCommandForConda(desc.externalCondaEnvName, args);
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                }
            }
        }
        return cmd;
    }

    private List<String> getRCommandForConda(String condaEnvName, List<String> args) throws IOException {
        String prefix = CondaEnvUtils.getEnvPrefix(condaEnvName);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(new File(new File(prefix), "bin/R").getAbsolutePath());
        cmd.add("--quiet");
        cmd.add("--no-save");
        if (!args.isEmpty() && "-e".equals(args.get(0))) {
            cmd.addAll(args);
        } else {
            cmd.add("--args");
            cmd.addAll(args);
        }
        return cmd;
    }

    private List<String> getRCommandForEnvRoot(File envRootDir, List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(new File(envRootDir, rBinary).getAbsolutePath());
        cmd.add("--quiet");
        cmd.add("--no-save");
        if (!args.isEmpty() && "-e".equals(args.get(0))) {
            cmd.addAll(args);
        } else {
            cmd.add("--args");
            cmd.addAll(args);
        }
        return cmd;
    }

    public void setupPySparkCmd(String envName, String projectKey, ExecutionEnv executionEnv) throws IOException {
        this.setupPySparkCmdAndGetBundleIdIfNull(envName, projectKey, null, executionEnv);
    }

    public List<String> getActualPythonPackagesForDatabricks(String envName, String projectKey, boolean forNotebook) throws IOException {
        if (envName == null) {
            if (forNotebook) {
                return Lists.newArrayList((Object[])new String[]{"ipykernel", "numpy", "pandas==0.23.4", "matplotlib", "urllib3", "requests", "jinja2"});
            }
            return Lists.newArrayList((Object[])new String[]{"pandas==0.23.4"});
        }
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        logger.info((Object)("Executing Python activity in env: " + envName));
        if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
            File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
            CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
            switch (desc.deploymentMode) {
                case AUTOMATION_NON_MANAGED_PATH: 
                case AUTOMATION_SINGLE: 
                case AUTOMATION_VERSIONED: {
                    assert (false);
                    break;
                }
                case DESIGN_MANAGED: 
                case DSS_INTERNAL: 
                case PLUGIN_MANAGED: 
                case BUSINESS_APP_MANAGED: {
                    File envDescFolder = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                    File requirementsFile = DKUFileUtils.getWithin((File)envDescFolder, (String[])new String[]{"actual", "requirements.txt"});
                    return FileUtils.readLines((File)requirementsFile, (Charset)StandardCharsets.UTF_8);
                }
                case PLUGIN_NON_MANAGED: 
                case BUSINESS_APP_NON_MANAGED: 
                case EXTERNAL_CONDA_NAMED: 
                case DESIGN_NON_MANAGED: {
                    throw new IllegalArgumentException("Code env of kind " + String.valueOf((Object)desc.deploymentMode) + " not supported for run on Databricks");
                }
            }
            throw new Error("unreachable");
        }
        File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(CodeEnvModel.EnvLang.PYTHON, envName);
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        File versionDescFolder = null;
        switch (rootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: {
                throw new IllegalArgumentException("Code env of kind " + String.valueOf((Object)rootDef.deploymentMode) + " not supported for run on Databricks");
            }
            case AUTOMATION_SINGLE: 
            case DSS_INTERNAL: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: {
                versionDescFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                break;
            }
            case AUTOMATION_VERSIONED: {
                String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                if (versionRef == null) {
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                }
                File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                versionDescFolder = new File(envVersionDir, "desc");
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
            }
        }
        File requirementsFile = DKUFileUtils.getWithin((File)versionDescFolder, (String[])new String[]{"actual", "requirements.txt"});
        return FileUtils.readLines((File)requirementsFile, (Charset)StandardCharsets.UTF_8);
    }

    public boolean isPython3ForDatabricks(String envName, String projectKey) throws IOException {
        if (envName == null) {
            return ApplicationConfigurator.getParams().getBoolParam("dku.builtin.python.isPython3", false);
        }
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        logger.info((Object)("Executing Python activity in env: " + envName));
        if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
            File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
            CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
            switch (desc.deploymentMode) {
                case AUTOMATION_NON_MANAGED_PATH: 
                case AUTOMATION_SINGLE: 
                case AUTOMATION_VERSIONED: {
                    assert (false);
                    break;
                }
                case DESIGN_MANAGED: 
                case DSS_INTERNAL: 
                case PLUGIN_MANAGED: 
                case BUSINESS_APP_MANAGED: {
                    if (desc.pythonInterpreter == StandardPythonInterpreter.CUSTOM) {
                        return StringUtils.defaultIfBlank((String)desc.customInterpreter, (String)"").contains("python3");
                    }
                    return desc.pythonInterpreter != StandardPythonInterpreter.PYTHON27;
                }
                case PLUGIN_NON_MANAGED: 
                case BUSINESS_APP_NON_MANAGED: 
                case EXTERNAL_CONDA_NAMED: 
                case DESIGN_NON_MANAGED: {
                    throw new IllegalArgumentException("Code env of kind " + String.valueOf((Object)desc.deploymentMode) + " not supported for run on Databricks");
                }
            }
            throw new Error("unreachable");
        }
        File envRootDir = AutomationNodeManagedEnvUtils.getEnvDir(CodeEnvModel.EnvLang.PYTHON, envName);
        CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
        File versionDescFolder = null;
        switch (rootDef.deploymentMode) {
            case AUTOMATION_NON_MANAGED_PATH: 
            case PLUGIN_NON_MANAGED: 
            case BUSINESS_APP_NON_MANAGED: 
            case EXTERNAL_CONDA_NAMED: {
                throw new IllegalArgumentException("Code env of kind " + String.valueOf((Object)rootDef.deploymentMode) + " not supported for run on Databricks");
            }
            case AUTOMATION_SINGLE: 
            case DSS_INTERNAL: 
            case PLUGIN_MANAGED: 
            case BUSINESS_APP_MANAGED: {
                versionDescFolder = DKUFileUtils.getWithin((File)envRootDir, (String[])new String[]{"desc"});
                break;
            }
            case AUTOMATION_VERSIONED: {
                String bundleId = CommonBundleUtils.getActiveBundleId(projectKey);
                CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                if (versionRef == null) {
                    throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                }
                File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                versionDescFolder = new File(envVersionDir, "desc");
                break;
            }
            case DESIGN_MANAGED: 
            case DESIGN_NON_MANAGED: {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
            }
        }
        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(versionDescFolder, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
        if (desc.pythonInterpreter == StandardPythonInterpreter.CUSTOM) {
            return StringUtils.defaultIfBlank((String)desc.customInterpreter, (String)"").contains("python3");
        }
        return desc.pythonInterpreter != StandardPythonInterpreter.PYTHON27;
    }

    public void setupPySparkCmdAndGetBundleIdIfNull(String envName, String projectKey, String bundleId, ExecutionEnv executionEnv) throws IOException {
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            logger.info((Object)"Executing pyspark activity in builtin env");
            String pythonBin = System.getenv("DKUPYTHONBIN");
            if (pythonBin == null) {
                throw new Error("environment variable DKUPYTHONBIN not defined");
            }
            executionEnv.env.put("PYSPARK_DRIVER_PYTHON", new File(pythonBin).getAbsolutePath());
        } else {
            ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
            logger.info((Object)("Executing Python activity in env: " + envName));
            if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
                File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.PythonEnvDesc.class);
                if (desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                    this.setupPySparkCommandForConda(desc.externalCondaEnvName, executionEnv);
                } else {
                    File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                    this.setupPySparkCommandForEnvRoot(envRootDir, executionEnv);
                }
                if (StringUtils.isNotBlank((String)desc.yarnPythonBin)) {
                    executionEnv.env.put("PYSPARK_PYTHON", desc.yarnPythonBin);
                }
            } else {
                File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.PYTHON.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                switch (rootDef.deploymentMode) {
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: {
                        this.setupPySparkCommandForEnvRoot(new File(envRootDir, "env"), executionEnv);
                        this.addExecutorPythonBin(envRootDir, executionEnv);
                        break;
                    }
                    case AUTOMATION_SINGLE: 
                    case DSS_INTERNAL: 
                    case PLUGIN_MANAGED: 
                    case BUSINESS_APP_MANAGED: {
                        this.setupPySparkCommandForEnvRoot(new File(envRootDir, "env"), executionEnv);
                        this.addExecutorPythonBin(envRootDir, executionEnv);
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        bundleId = bundleId == null ? CommonBundleUtils.getActiveBundleId(projectKey) : bundleId;
                        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.PYTHON, envName, projectKey, bundleId);
                        if (versionRef == null) {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                        }
                        File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.PYTHON, envName, versionRef.envVersion);
                        this.setupPySparkCommandForEnvRoot(new File(envVersionDir, "env"), executionEnv);
                        this.addExecutorPythonBin(envVersionDir, executionEnv);
                        break;
                    }
                    case EXTERNAL_CONDA_NAMED: {
                        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(envRootDir, "desc/desc.json"), CodeEnvModel.PythonEnvDesc.class);
                        this.setupPySparkCommandForConda(desc.externalCondaEnvName, executionEnv);
                        this.addExecutorPythonBin(envRootDir, executionEnv);
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                    default: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Unknown env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                }
            }
        }
    }

    private void addExecutorPythonBin(File envDir, ExecutionEnv executionEnv) throws IOException {
        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)JSON.parseFile((File)new File(new File(envDir, "desc"), "desc.json"), CodeEnvModel.PythonEnvDesc.class);
        if (StringUtils.isNotBlank((String)desc.yarnPythonBin)) {
            executionEnv.env.put("PYSPARK_PYTHON", desc.yarnPythonBin);
        }
    }

    private void setupPySparkCommandForConda(String condaEnvName, ExecutionEnv executionEnv) throws IOException {
        String prefix = CondaEnvUtils.getEnvPrefix(condaEnvName);
        executionEnv.env.put("PYSPARK_DRIVER_PYTHON", "python");
        executionEnv.cmd.add(0, ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "conda-support", "conda-run.sh"}).getAbsolutePath());
        executionEnv.cmd.add(1, prefix);
    }

    private void setupPySparkCommandForEnvRoot(File envRootDir, ExecutionEnv executionEnv) {
        if (new File(envRootDir, "conda-meta").isDirectory()) {
            executionEnv.env.put("PYSPARK_DRIVER_PYTHON", "python");
            executionEnv.cmd.add(0, ApplicationConfigurator.getResourceFile((String[])new String[]{"code-envs", "conda-support", "conda-run.sh"}).getAbsolutePath());
            executionEnv.cmd.add(1, envRootDir.getAbsolutePath());
        } else {
            executionEnv.env.put("PYSPARK_DRIVER_PYTHON", new File(envRootDir, "bin/python").getAbsolutePath());
        }
    }

    public void setupSparkRCmd(String envName, String projectKey, ExecutionEnv executionEnv) throws IOException {
        this.setupSparkRCmdAndGetBundleIdIfNull(envName, projectKey, null, executionEnv);
    }

    public void setupSparkRCmdAndGetBundleIdIfNull(String envName, String projectKey, String bundleId, ExecutionEnv executionEnv) throws IOException {
        if (envName == null || "__BUILTIN_ENV__".equals(envName)) {
            logger.info((Object)"Executing sparkr activity in builtin env");
            String rBin = System.getenv("DKURBIN");
            if (rBin == null) {
                throw new Error("environment variable DKURBIN not defined");
            }
        } else {
            ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
            logger.info((Object)("Executing SparkR activity in env: " + envName));
            if (nodeType == ApplicationConfigurator.DSSNodeType.DESIGN) {
                File descDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(descDir, "desc.json"), CodeEnvModel.REnvDesc.class);
                if (desc.deploymentMode == CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED) {
                    this.setupSparkRCommandForConda(desc.externalCondaEnvName, executionEnv);
                } else {
                    File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                    this.setupSparkRCommandForEnvRoot(envRootDir, executionEnv);
                }
                if (StringUtils.isNotBlank((String)desc.yarnRBin)) {
                    executionEnv.sparkConf.put("spark.r.command", desc.yarnRBin);
                }
            } else {
                File envRootDir = ApplicationConfigurator.getFile((String[])new String[]{"acode-envs", CodeEnvModel.EnvLang.R.getFolderName(), envName});
                CodeEnvModel.AutomationEnvRootDef rootDef = (CodeEnvModel.AutomationEnvRootDef)JSON.parseFile((File)new File(envRootDir, "env.json"), CodeEnvModel.AutomationEnvRootDef.class);
                switch (rootDef.deploymentMode) {
                    case AUTOMATION_NON_MANAGED_PATH: 
                    case PLUGIN_NON_MANAGED: 
                    case BUSINESS_APP_NON_MANAGED: {
                        this.setupSparkRCommandForEnvRoot(new File(envRootDir, "env"), executionEnv);
                        this.addExecutorRBin(envRootDir, executionEnv);
                        break;
                    }
                    case AUTOMATION_SINGLE: 
                    case DSS_INTERNAL: 
                    case PLUGIN_MANAGED: 
                    case BUSINESS_APP_MANAGED: {
                        this.setupSparkRCommandForEnvRoot(new File(envRootDir, "env"), executionEnv);
                        this.addExecutorRBin(envRootDir, executionEnv);
                        break;
                    }
                    case AUTOMATION_VERSIONED: {
                        bundleId = bundleId == null ? CommonBundleUtils.getActiveBundleId(projectKey) : bundleId;
                        CodeEnvModel.EnvVersionRef versionRef = AutomationNodeManagedEnvUtils.getNamedBundleLink(CodeEnvModel.EnvLang.R, envName, projectKey, bundleId);
                        if (versionRef == null) {
                            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
                        }
                        File envVersionDir = AutomationNodeManagedEnvUtils.getEnvVersionDir(CodeEnvModel.EnvLang.R, envName, versionRef.envVersion);
                        this.setupSparkRCommandForEnvRoot(new File(envVersionDir, "env"), executionEnv);
                        this.addExecutorRBin(envVersionDir, executionEnv);
                        break;
                    }
                    case EXTERNAL_CONDA_NAMED: {
                        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(envRootDir, "desc/desc.json"), CodeEnvModel.REnvDesc.class);
                        this.setupSparkRCommandForConda(desc.externalCondaEnvName, executionEnv);
                        this.addExecutorRBin(envRootDir, executionEnv);
                        break;
                    }
                    case DESIGN_MANAGED: 
                    case DESIGN_NON_MANAGED: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Illegal env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                    default: {
                        throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_INCORRECT_ENV_TYPE, "Unknown env mode: " + String.valueOf((Object)rootDef.deploymentMode));
                    }
                }
            }
        }
    }

    private void addExecutorRBin(File envDir, ExecutionEnv executionEnv) throws IOException {
        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)JSON.parseFile((File)new File(new File(envDir, "desc"), "desc.json"), CodeEnvModel.REnvDesc.class);
        if (StringUtils.isNotBlank((String)desc.yarnRBin)) {
            executionEnv.sparkConf.put("spark.r.command", desc.yarnRBin);
        }
    }

    private void setupSparkRCommand(ExecutionEnv executionEnv, String rBin, String rscriptBin) {
        executionEnv.env.put("SPARKR_DRIVER_R", rBin);
        executionEnv.sparkConf.put("spark.r.driver.command", rscriptBin);
    }

    private void setupSparkRCommandForConda(String condaEnvName, ExecutionEnv executionEnv) throws IOException {
        String prefix = CondaEnvUtils.getEnvPrefix(condaEnvName);
        String rBin = new File(prefix, "bin/R").getAbsolutePath();
        String rscriptBin = new File(prefix, "bin/Rscript").getAbsolutePath();
        this.setupSparkRCommand(executionEnv, rBin, rscriptBin);
    }

    private void setupSparkRCommandForEnvRoot(File envRootDir, ExecutionEnv executionEnv) throws IOException {
        String rBin = new File(envRootDir, "bin/R").getAbsolutePath();
        String rscriptBin = new File(envRootDir, "bin/Rscript").getAbsolutePath();
        this.setupSparkRCommand(executionEnv, rBin, rscriptBin);
    }

    public static class ExecutionEnv {
        public List<String> cmd = Lists.newArrayList();
        public Map<String, String> env = Maps.newHashMap();
        public Map<String, String> sparkConf = Maps.newHashMap();
    }

    public static class CodeEnvMissingVersionException
    extends CodedIOException {
        public CodeEnvMissingVersionException(String projectKey, String bundleId) {
            super((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV_VERSION, "Failed to resolve env link for " + projectKey + " " + bundleId);
        }
    }
}

