/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.ICodeEnvResolutionService;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FixedPythonBinCodeEnvResolutionService
implements ICodeEnvResolutionService {
    private final Map<String, String> pythonBins;
    private final String builtinPythonBin;
    private static Logger logger = Logger.getLogger((String)"dip.code.env.fixed");

    public FixedPythonBinCodeEnvResolutionService(String builtinPythonBin, Map<String, String> pythonBins) {
        this.builtinPythonBin = builtinPythonBin;
        this.pythonBins = pythonBins;
    }

    public void addCodeEnvs(String builtinYarnPythonBin, Map<String, String> yarnPythonBins) {
        this.pythonBins.putAll(yarnPythonBins);
    }

    @Override
    public List<String> getPythonCmd(String envName, String projectKey, List<String> args) throws IOException {
        ArrayList cmd = Lists.newArrayList();
        String pythonBin = StringUtils.isBlank((String)envName) || "__BUILTIN_ENV__".equals(envName) ? this.builtinPythonBin : this.pythonBins.get(envName);
        logger.info((Object)("Executing Python activity in env " + envName));
        if (pythonBin == null) {
            throw new IOException("No python binary recorded for code env " + envName);
        }
        cmd.add(pythonBin);
        cmd.add("-u");
        cmd.addAll(args);
        return cmd;
    }

    @Override
    public Map<String, String> getEnvironmentVariablesForPythonCmd(String envName, String projectKey) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    public String getYarnPythonBin(String envName, String projectKey) {
        throw new NotImplementedException("Method not available on executor nodes");
    }
}

