/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.anthropic.AnthropicPricing;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class AnthropicConnection
extends AbstractLLMConnection<AnthropicModel, HardcodedAnthropicModel, CustomAnthropicModel> {
    private static final EnrichedLLMStructuredRef.FieldRange TEMPERATURE_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 1.0, 0.01);
    private static final EnrichedLLMStructuredRef.FieldRange TOP_K_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 500.0, 1.0);
    public AnthropicConnectionParams params = new AnthropicConnectionParams();
    public static final String connectionType = "Anthropic";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.connections.anthropic");

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected List<HardcodedAnthropicModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedAnthropicModel.values());
    }

    @Override
    protected List<CustomAnthropicModel> listRawCustomModels() {
        return this.params.customModels;
    }

    @Override
    protected AnthropicModel loadRawHardcodedModel(HardcodedAnthropicModel hardcodedModel) {
        AnthropicModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    protected AnthropicModel loadRawCustomModel(CustomAnthropicModel customModel) {
        AnthropicModel model = customModel.toModel();
        this.loadDefaultCustomModelSettings(model);
        return model;
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedAnthropicModel anthropicModel) {
        return anthropicModel.allowedModel.apply(this.params);
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential("", this.params.apiKey);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testAnthropic(this, authCtx);
    }

    public static class AnthropicConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
        public String apiKey;
        public int maxParallelism = 2;
        public boolean allowClaudeV4Opus = false;
        public boolean allowClaudeV41Opus = false;
        public boolean allowClaudeV45Opus = false;
        public boolean allowClaudeV4Sonnet = false;
        public boolean allowClaudeV45Sonnet = false;
        public boolean allowClaudeV37Sonnet = false;
        public boolean allowClaudeV3Haiku = false;
        public boolean allowClaudeV35Haiku = false;
        public boolean allowClaudeV45Haiku = false;
        public List<CustomAnthropicModel> customModels = new ArrayList<CustomAnthropicModel>();
    }

    public static enum HardcodedAnthropicModel implements AbstractLLMConnection.IHardcodedConnectionModel
    {
        CLAUDE_V4_OPUS("claude-opus-4-20250514", "Claude 4 Opus", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV4Opus),
        CLAUDE_V41_OPUS("claude-opus-4-1-20250805", "Claude 4.1 Opus", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV41Opus),
        CLAUDE_V45_OPUS("claude-opus-4-5-20251101", "Claude 4.5 Opus", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV45Opus),
        CLAUDE_V37_SONNET("claude-3-7-sonnet-20250219", "Claude 3.7 Sonnet (deprecated / scheduled for retirement on Feb. 19th, 2026)", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV37Sonnet),
        CLAUDE_V4_SONNET("claude-sonnet-4-20250514", "Claude 4 Sonnet", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV4Sonnet),
        CLAUDE_V45_SONNET("claude-sonnet-4-5-20250929", "Claude 4.5 Sonnet", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV45Sonnet),
        CLAUDE_V3_HAIKU("claude-3-haiku-20240307", "Claude 3 Haiku", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowClaudeV3Haiku),
        CLAUDE_V35_HAIKU("claude-3-5-haiku-20241022", "Claude 3.5 Haiku (deprecated / scheduled for retirement on Feb. 19th, 2026)", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowClaudeV35Haiku),
        CLAUDE_V45_HAIKU("claude-haiku-4-5-20251001", "Claude 4.5 Haiku", AnthropicModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowClaudeV45Haiku);

        public final String id;
        public final String displayName;
        public final Function<AnthropicConnectionParams, Boolean> allowedModel;
        public final boolean isReasoning;
        public final AnthropicModelType modelType;

        private HardcodedAnthropicModel(String id, String displayName, AnthropicModelType anthropicModelType, boolean isReasoning, Function<AnthropicConnectionParams, Boolean> allowedModel) {
            this.id = id;
            this.isReasoning = isReasoning;
            this.displayName = displayName;
            this.allowedModel = allowedModel;
            this.modelType = anthropicModelType;
        }

        public AnthropicModel toModel() {
            AnthropicModel model = new AnthropicModel();
            model.id = this.id;
            model.isReasoning = this.isReasoning;
            model.displayName = this.displayName;
            model.completionCost = AnthropicPricing.getAnthropicCompletionCostPer1KTokens(this.id);
            model.promptCost = AnthropicPricing.getAnthropicPromptCostPer1KTokens(this.id);
            model.modelType = this.modelType;
            return model;
        }
    }

    public static class AnthropicModel
    extends AbstractLLMConnection.BaseModel {
        public AnthropicModelType modelType;
        public boolean isReasoning = false;

        @Override
        public boolean canBeUsedForPurpose(@Nonnull AbstractLLMConnection.LLMUsagePurpose purpose) {
            return this.modelType.matchesPurpose(purpose);
        }

        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.canGenerateCrossLanguageOutput = true;
            capabilities.handlesSystemMessage = true;
            capabilities.temperatureRange = TEMPERATURE_RANGE;
            capabilities.topKRange = TOP_K_RANGE;
            capabilities.isReasoning = this.isReasoning;
            capabilities.supportsImageInputs = this.canBeUsedForPurpose(AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT);
            return capabilities;
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forAnthropicConnection(connection, this.getId());
        }
    }

    public static class CustomAnthropicModel
    extends AbstractLLMConnection.CustomModel<AnthropicModel> {
        public String id;
        public String displayName;
        public boolean isReasoning = false;
        public AnthropicModelType modelType = AnthropicModelType.COMPLETION_CHAT;

        @Override
        public AnthropicModel toModel() {
            AnthropicModel model = new AnthropicModel();
            model.loadFromCustomModel(this);
            model.id = this.id;
            model.displayName = this.displayName;
            model.isReasoning = this.isReasoning;
            model.modelType = this.modelType;
            return model;
        }
    }

    public static enum AnthropicModelType {
        COMPLETION_CHAT(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION), true),
        COMPLETION_CHAT_MULTIMODAL(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION, AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT), true);

        public final List<AbstractLLMConnection.LLMUsagePurpose> matchingPurposes;

        private AnthropicModelType(List<AbstractLLMConnection.LLMUsagePurpose> purposes, boolean useChatAPI) {
            this.matchingPurposes = purposes;
        }

        public boolean matchesPurpose(AbstractLLMConnection.LLMUsagePurpose purpose) {
            return this.matchingPurposes.contains((Object)purpose);
        }
    }
}

