/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AWSCredentialsProviders;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.connections.RedshiftConnection;
import com.dataiku.dip.connections.aws.ShadedS3ConnectionAWSSessionCredentialsProviderV2;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.ClientConfiguration;
import com.dataiku.dss.legacy.aws.com.amazonaws.regions.RegionUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.s3.AmazonS3Client;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.s3.S3ClientOptions;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.builder.SdkSyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkClientException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.apache.ApacheHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.servicemetadata.S3ServiceMetadata;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.GlueClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.glue.GlueClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.s3.S3ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EC2Connection
extends AbstractCloudStorageConnection
implements ConnectionWithEncryptedFields,
ConnectionWithAWSAuthCredentials {
    private static final Pattern ENDPOINT_PATTERN = Pattern.compile(".*://.*\\.([^.]+)\\.vpce\\.amazonaws\\.com.*");
    private static final Pattern ENDPOINT_PREPENDED_BY_BUCKET_PATTERN = Pattern.compile(".*://bucket\\.vpce-.+\\.vpce\\.amazonaws\\.com.*");
    private static final Logger log = LoggerFactory.getLogger(EC2Connection.class);
    public Params params = new Params();
    public static final String connectionType = "EC2";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.aws.ec2");

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        if (this.params.credentialsMode == ConnectionWithAWSAuthCredentials.AWSCredentialMode.KEYPAIR) {
            this.params.accessKey = vc.expand(this.params.accessKey);
            this.params.secretKey = vc.expand(this.params.secretKey);
        }
        this.params.regionOrEndpoint = vc.expand(this.params.regionOrEndpoint);
        this.params.chbucket = vc.expand(this.params.chbucket);
        this.params.chroot = vc.expand(this.params.chroot);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public ConnectionWithAWSAuthCredentials.IAWSAuthParams getIAWSAuthNonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return this.getProxySettings();
    }

    @Override
    public DSSConnection.CredentialsMode getCredentialsMode() {
        return this.credentialsMode;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    public String getMainManagedDatasetType() {
        return "S3";
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveAWSAuthOnDSSHost();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class));
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential creds = this.getResolvedCredential(ctx.authCtx);
        return clazz.cast(creds);
    }

    public String getS3APropertyPrefix(String bucketName) {
        boolean perBucket;
        Object s3aPropertyPrefix = "fs.s3a.";
        boolean bl = perBucket = ApplicationConfigurator.getParams().getBoolParam("dku.s3.perBucketHadoopPropertiesEnabled", true) && this.getDkuPropertiesAsParams().getBoolParam("dku.perBucketHadoopPropertiesEnabled", true);
        if (perBucket && StringUtils.isNotBlank((String)bucketName)) {
            s3aPropertyPrefix = (String)s3aPropertyPrefix + "bucket." + bucketName + ".";
        }
        return s3aPropertyPrefix;
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopConfigForS3Access(AuthCtx authCtx, String bucket) throws IOException, DKUSecurityException {
        ArrayList ret = Lists.newArrayList();
        switch (this.params.hdfsInterface) {
            case S3A: 
            case S3A_DATABRICKS: {
                String s3aPropertyPrefix = this.getS3APropertyPrefix(bucket);
                if (!this.couldRunWithEnvironmentCredentials(this.params)) {
                    ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "access.key", cred.accessKey, false));
                    ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "secret.key", cred.secretKey, true));
                    if (cred.sessionToken != null) {
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "session.token", cred.sessionToken, true));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "session.expirationTime", Long.toString(cred.expirationTime), false));
                        if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.UNKNOWN) {
                            String dkuSparkHome = System.getenv("DKU_SPARK_HOME");
                            if (cred.expirationTime > 0L && StringUtils.isNotBlank((String)dkuSparkHome) && DKUFileUtils.isWithin((File)ApplicationConfigurator.getInstallFolderF(), (File)new File(dkuSparkHome))) {
                                logger.info((Object)"In a standalone spark -> use slim provider");
                                MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "dku.connectionName", this.name, false));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "dku.projectKey", "__DKU_ANY_PROJECT__", false));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "aws.credentials.provider", "com.dataiku.dip.spark.aws.RemoteFetchCredentialsProvider", false));
                            } else {
                                logger.info((Object)("Not in a standalone spark -> use aws-sdk provider (expiry=" + cred.expirationTime + ")"));
                                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider", false));
                            }
                        } else if (cred.expirationTime > 0L && CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo.canFindAuthCtx()) {
                            MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
                            CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "dku.connectionName", this.name, false));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "dku.projectKey", "__DKU_ANY_PROJECT__", false));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "dku.fetchInfo", JSON.json((Object)fetchInfo), true));
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "aws.credentials.provider", AWSCredentialsProviders.SerializableAWSCredentialHadoopProvider.class.getName(), false));
                        } else {
                            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider", false));
                        }
                    }
                    if (this.params.hdfsInterface == S3DatasetHandler.HDFSInterface.S3A_DATABRICKS) {
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3n.awsAccessKeyId", cred.accessKey, false));
                        ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3n.awsSecretAccessKey", cred.secretKey, true));
                    }
                }
                if (!this.params.usePathMode) break;
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty(s3aPropertyPrefix + "path.style.access", "true", false));
                break;
            }
            case EMRFS: {
                if (this.params.credentialsMode == ConnectionWithAWSAuthCredentials.AWSCredentialMode.ENVIRONMENT) break;
                ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3.awsAccessKeyId", cred.accessKey, false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3.awsSecretAccessKey", cred.secretKey, true));
                if (cred.sessionToken == null) break;
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.s3.awsSessionToken", cred.sessionToken, true));
                break;
            }
            case NONE: {
                assert (false);
                break;
            }
        }
        this.addDisableCacheIfNeeded(ret, this.params.dkuProperties);
        this.addExtraHadoopConf(ret, this.params.dkuProperties);
        return ret;
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkConfigForS3Access(AuthCtx authCtx) throws IOException, DKUSecurityException {
        List<AbstractSQLConnection.CustomDatabaseProperty> ret = this.getHadoopConfigForS3Access(authCtx, null);
        for (AbstractSQLConnection.CustomDatabaseProperty cdp : ret) {
            cdp.name = "spark.hadoop." + cdp.name;
        }
        return ret;
    }

    public String getS3CredentialsForRedshift(Dataset dataset, AuthCtx authCtx, PasswordEncryptionService symetricCryptoService) throws IOException, DKUSecurityException {
        String s3Credentials;
        String outputConnectionName = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getConnection();
        RedshiftConnection redshiftConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, outputConnectionName, RedshiftConnection.class);
        if (!StringUtils.isBlank((String)redshiftConnection.params.iamRole)) {
            s3Credentials = String.format("IAM_ROLE '%s'", redshiftConnection.params.iamRole);
        } else if (!this.couldRunWithEnvironmentCredentials(this.params)) {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, dataset.getProjectKey()), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (StringUtils.isBlank((String)cred.accessKey) || StringUtils.isBlank((String)cred.secretKey)) {
                throw ErrorContext.iae((String)"No EC2 access credentials for output connection");
            }
            s3Credentials = StringUtils.isNotBlank((String)cred.sessionToken) ? String.format("CREDENTIALS 'aws_access_key_id=%s;aws_secret_access_key=%s;token=%s'", cred.accessKey, cred.secretKey, cred.sessionToken) : String.format("CREDENTIALS 'aws_access_key_id=%s;aws_secret_access_key=%s'", cred.accessKey, cred.secretKey);
        } else {
            throw ErrorContext.iae((String)"No IAM role and S3 connection is using default credentials");
        }
        return s3Credentials;
    }

    public S3FastPathCredentials getS3CredentialsForFastPath(AuthCtx authCtx) throws IOException, DKUSecurityException {
        return new S3FastPathCredentials(authCtx, this.params);
    }

    public AmazonS3Client getS3ClientSdk1(AuthCtx authCtx) throws CodedException, IOException, DKUSecurityException {
        String regionOrEndpoint;
        AmazonS3Client client;
        ClientConfiguration awsConfig = new ClientConfiguration();
        if (!ApplicationConfigurator.isInSparkDriver()) {
            ProxyUtils.applyProxySettings((ProxySettings)this.getProxySettings(), (ClientConfiguration)awsConfig);
        }
        if (this.couldRunWithEnvironmentCredentials(this.params)) {
            client = new AmazonS3Client(awsConfig);
        } else {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (StringUtils.isBlank((String)cred.accessKey)) {
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing accessKey parameter");
            }
            if (StringUtils.isBlank((String)cred.secretKey)) {
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing secretKey parameter");
            }
            client = cred.expirationTime > 0L ? new AmazonS3Client(ConnectionWithAWSAuthCredentials.fromAwsToV1Credentials(new AWSCredentialsProviders.SerializableAWSCredentialProvider(authCtx, cred, this).resolveCredentials()), awsConfig) : new AmazonS3Client(ConnectionWithAWSAuthCredentials.fromAwsToV1Credentials(cred.toAWSCredentials()), awsConfig);
        }
        if (this.params.usePathMode) {
            client.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(true).build());
        }
        if (StringUtils.isNotBlank((String)(regionOrEndpoint = this.params.regionOrEndpoint))) {
            if (regionOrEndpoint.contains("://")) {
                try {
                    client.setEndpoint(regionOrEndpoint);
                }
                catch (Exception e) {
                    throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: error setting endpoint: " + regionOrEndpoint, (Throwable)e);
                }
                Matcher endpointMatcher = ENDPOINT_PATTERN.matcher(regionOrEndpoint);
                if (endpointMatcher.matches()) {
                    String region = endpointMatcher.group(1);
                    Matcher endpointWithBucketMatcher = ENDPOINT_PREPENDED_BY_BUCKET_PATTERN.matcher(regionOrEndpoint);
                    if (!endpointWithBucketMatcher.matches()) {
                        throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: aws endpoints must start with \"http[s]://bucket.vpce-\" : " + regionOrEndpoint);
                    }
                    if (!this.params.usePathMode) {
                        throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: please enable \"Use path style\" in order to use an AWS vpc endpoint: " + regionOrEndpoint);
                    }
                    if (this.params.switchToRegionFromBucket) {
                        throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: please disable \"Switch to bucket region\" in order to use an AWS vpc endpoint: " + regionOrEndpoint);
                    }
                    client.setSignerRegionOverride(region);
                }
            } else {
                com.dataiku.dss.legacy.aws.com.amazonaws.regions.Region region = RegionUtils.getRegion((String)regionOrEndpoint);
                if (region == null) {
                    throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: not a valid region: " + String.valueOf(region));
                }
                client.setRegion(region);
            }
        }
        return client;
    }

    public void setRegionOrEndpoint(S3ClientBuilder client) throws CodedException {
        String regionOverride;
        String regionOrEndpoint = this.params.regionOrEndpoint;
        if (this.params.hasCustomEndpoint()) {
            logger.debug((Object)"Setup region for custom endpoint to default");
            client.region(Region.US_EAST_1);
            try {
                client.endpointOverride(URI.create(regionOrEndpoint));
            }
            catch (Exception e) {
                throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: error setting endpoint: " + regionOrEndpoint, (Throwable)e);
            }
            Matcher endpointMatcher = ENDPOINT_PATTERN.matcher(regionOrEndpoint);
            if (endpointMatcher.matches()) {
                String region = endpointMatcher.group(1);
                Matcher endpointWithBucketMatcher = ENDPOINT_PREPENDED_BY_BUCKET_PATTERN.matcher(regionOrEndpoint);
                if (!endpointWithBucketMatcher.matches()) {
                    throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: aws endpoints must start with \"http[s]://bucket.vpce-\" : " + regionOrEndpoint);
                }
                if (!this.params.usePathMode) {
                    throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: please enable \"Use path style\" in order to use an AWS vpc endpoint: " + regionOrEndpoint);
                }
                if (this.params.switchToRegionFromBucket) {
                    throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: please disable \"Switch to bucket region\" in order to use an AWS vpc endpoint: " + regionOrEndpoint);
                }
                if (StringUtils.isNotBlank((String)region)) {
                    if (this.params.isRegionOnVpceEnabled()) {
                        logger.info((Object)("Setting region for VPCE to '" + region + "' for " + this.getName()));
                        client.region(Region.of((String)region));
                    } else {
                        logger.info((Object)("Not setting region for VPCE on " + this.getName()));
                    }
                }
            }
        }
        if (this.params.hasRegion()) {
            Region region = Region.of((String)regionOrEndpoint);
            client.region(region);
        }
        if (StringUtils.isNotBlank((String)(regionOverride = this.params.overrideClientRegionParam()))) {
            logger.info((Object)("Forcing region to '" + regionOverride + "' for " + this.getName()));
            client.region(Region.of((String)regionOverride));
        }
    }

    public StsClient getStsClient(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        try {
            return awsClientBrokerService.createStsClient((AwsCredentialsProvider)this.getSerializableAwsCredentialsFromConnection(authCtx), this.params.regionOrEndpoint);
        }
        catch (SdkClientException sdkClientException) {
            if (sdkClientException.getMessage().contains("Unable to load region from any of the providers in the chain")) {
                return awsClientBrokerService.createStsClient((AwsCredentialsProvider)this.getSerializableAwsCredentialsFromConnection(authCtx), Region.US_EAST_1.id());
            }
            throw sdkClientException;
        }
    }

    private AWSCredentialsProviders.SerializableAWSCredentialProvider getSerializableAwsCredentialsFromConnection(AuthCtx authCtx) throws CodedException, IOException, DKUSecurityException {
        ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
        if (StringUtils.isBlank((String)cred.accessKey)) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing accessKey parameter");
        }
        if (StringUtils.isBlank((String)cred.secretKey)) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing secretKey parameter");
        }
        return new AWSCredentialsProviders.SerializableAWSCredentialProvider(authCtx, cred, this);
    }

    private S3ClientBuilder getS3ClientBuilder(AuthCtx authCtx) throws CodedException, IOException, DKUSecurityException {
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
        if (!ApplicationConfigurator.isInSparkDriver()) {
            ProxyUtils.applyProxySettings((ProxySettings)this.getProxySettings(), (ApacheHttpClient.Builder)httpClientBuilder);
        }
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        boolean useTelemetry = this.params.regionOrEndpoint == null || this.params.hasRegion();
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        if (useTelemetry) {
            awsClientBrokerService.applyTelemetry(clientOverrideConfiguration);
        }
        if (this.params.useAwsS3V4Signer()) {
            clientOverrideConfiguration.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)AwsS3V4Signer.create());
        }
        S3ClientBuilder s3ClientBuilder = awsClientBrokerService.S3ClientBuilder(clientOverrideConfiguration);
        s3ClientBuilder = (S3ClientBuilder)s3ClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        if (!this.couldRunWithEnvironmentCredentials(this.params)) {
            s3ClientBuilder = (S3ClientBuilder)s3ClientBuilder.credentialsProvider((AwsCredentialsProvider)this.getSerializableAwsCredentialsFromConnection(authCtx));
        }
        if (this.params.usePathMode) {
            s3ClientBuilder.forcePathStyle(Boolean.valueOf(true));
        }
        s3ClientBuilder.crossRegionAccessEnabled(Boolean.valueOf(true));
        try {
            this.setRegionOrEndpoint(s3ClientBuilder);
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: error setting endpoint: " + this.params.regionOrEndpoint, (Throwable)e);
        }
        return s3ClientBuilder;
    }

    public S3Client getS3Client(AuthCtx authCtx) throws CodedException, IOException, DKUSecurityException {
        try {
            return (S3Client)this.getS3ClientBuilder(authCtx).build();
        }
        catch (SdkClientException sdkClientException) {
            if (sdkClientException.getMessage().contains("Unable to load region from any of the providers in the chain")) {
                return this.getS3Client(authCtx, Region.US_EAST_1);
            }
            throw sdkClientException;
        }
    }

    public S3Client getS3Client(AuthCtx authCtx, Region region) throws CodedException, IOException, DKUSecurityException {
        S3ClientBuilder builder = (S3ClientBuilder)this.getS3ClientBuilder(authCtx).region(region);
        return (S3Client)builder.build();
    }

    public GlueClient getGlueClient(AuthCtx authCtx) throws IOException, DKUSecurityException, CodedException {
        GlueClientBuilder builder = GlueClient.builder();
        if (!ApplicationConfigurator.isInSparkDriver()) {
            ProxyUtils.addHttpClientBuilderAndApplyProxySettings((ProxySettings)this.getProxySettings(), (SdkSyncClientBuilder)builder);
        }
        String region = this.params.regionOrEndpoint;
        AWSClientBrokerService.setRegionOrEndpoint((String)region, (AwsClientBuilder)builder);
        if (!this.couldRunWithEnvironmentCredentials(this.params)) {
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential cred = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            if (StringUtils.isBlank((String)cred.accessKey)) {
                throw new CodedIOException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing accessKey parameter");
            }
            if (StringUtils.isBlank((String)cred.secretKey)) {
                throw new CodedIOException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_S3_INVALID_CONFIG, "Invalid S3 account configuration: missing secretKey parameter");
            }
            builder.credentialsProvider((AwsCredentialsProvider)new ShadedS3ConnectionAWSSessionCredentialsProviderV2(authCtx, this));
        }
        return (GlueClient)builder.build();
    }

    public String getEndpoint() {
        String regionOrEndpoint = this.params.regionOrEndpoint;
        if (this.params.hasCustomEndpoint()) {
            return regionOrEndpoint;
        }
        if (this.params.hasRegion()) {
            Region region = Region.of((String)regionOrEndpoint);
            return new S3ServiceMetadata().endpointFor(region).getPath();
        }
        return null;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (securitySettings.secureSecretKeys) {
            this.params.secretKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.secretKey);
        }
        AbstractSQLConnection.CustomDatabaseProperty.encryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.secretKey = cryptoService.decryptIfEncrypted(this.params.secretKey);
        AbstractSQLConnection.CustomDatabaseProperty.decryptList(this.params.customAWSCredentialsProviderParams, cryptoService);
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{"S3"});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    public String getHDFSScheme() {
        switch (this.params.hdfsInterface) {
            case S3A: 
            case S3A_DATABRICKS: {
                return "s3a";
            }
            case EMRFS: {
                return "s3";
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    public com.dataiku.dip.utils.Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.params.dkuProperties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allowManagedDatasets() {
        return this.allowManagedDatasets;
    }

    @Override
    public String getResolvedHDFSRoot(AuthCtx authCtx, String projectKey) {
        String bucket = StringUtils.isNotBlank((String)this.params.chbucket) ? this.params.chbucket : this.params.defaultManagedBucket;
        switch (this.params.hdfsInterface) {
            case S3A: 
            case S3A_DATABRICKS: {
                return "s3a://" + bucket + PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
            }
            case EMRFS: {
                return "s3://" + bucket + PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
            }
            case NONE: {
                return null;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String getPredictionLogsRoot() {
        String bucket = StringUtils.isNotBlank((String)this.params.chbucket) ? this.params.chbucket : StringUtils.defaultIfBlank((String)this.params.defaultManagedBucket, (String)"");
        if (StringUtils.isBlank((String)bucket)) {
            return "s3://" + PathUtils.makeNotLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
        }
        return "s3://" + PathUtils.makeNotLeadingNoTrailing((String)bucket) + PathUtils.makeLeadingNoTrailing((String)StringUtils.defaultIfBlank((String)this.params.chroot, (String)""));
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testEC2(authCtx, this);
    }

    public static class Params
    extends ConnectionWithAWSAuthCredentials.AWSAuthParams {
        private static final String ENABLE_AWSS3V4SIGNER_PARAM = "dku.s3.AWSS3V4Signer.enable";
        private static final String OVERRIDE_CLIENT_REGION_PARAM = "dku.s3.client.region";
        private static final String SET_REGION_ON_VPCE_ENABLE = "dku.s3.client.vpce.region.enable";
        public String defaultManagedBucket;
        public String defaultManagedPath;
        public String regionOrEndpoint;
        public S3DatasetHandler.HDFSInterface hdfsInterface = S3DatasetHandler.HDFSInterface.S3A;
        public S3DatasetHandler.EncryptionMode encryptionMode = S3DatasetHandler.EncryptionMode.NONE;
        public String encryptionKeyId;
        public String chbucket;
        public String chroot;
        public boolean switchToRegionFromBucket = true;
        public boolean usePathMode;
        public String snowflakeStorageIntegration;
        public String snowflakeExternalStageName;
        public String snowflakeExternalStagePath;
        public HDFSConnection.HiveSynchronizationMode metastoreSynchronizationMode = HDFSConnection.HiveSynchronizationMode.NO_SYNC;
        public String defaultMetastoreDatabase;
        public String associatedAthenaConnection;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.MetastoreAwareFilesBasedDatasetNamingRule();

        public void setCredentialsForTests(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        public String getDefaultManagedBucket() {
            return StringUtils.isNotBlank((String)this.chbucket) ? this.chbucket : this.defaultManagedBucket;
        }

        public String getDefaultManagedPath() {
            return ChrootUtils.getChrootedPath(this.chroot, this.defaultManagedPath, false);
        }

        public boolean useAwsS3V4Signer() {
            return this.dkuProperties.stream().anyMatch(p -> StringUtils.equals((String)p.name, (String)ENABLE_AWSS3V4SIGNER_PARAM) && Boolean.parseBoolean(p.value));
        }

        public String overrideClientRegionParam() {
            return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.dkuProperties).getParam(OVERRIDE_CLIENT_REGION_PARAM, null);
        }

        public boolean isRegionOnVpceEnabled() {
            return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.dkuProperties).getBoolParam(SET_REGION_ON_VPCE_ENABLE, true);
        }

        public boolean hasCustomEndpoint() {
            return Params.isCustomEndpoint(this.regionOrEndpoint);
        }

        public boolean hasRegion() {
            return Params.isRegion(this.regionOrEndpoint);
        }

        public static boolean isRegion(String candidateRegion) {
            return StringUtils.isNotBlank((String)candidateRegion) && !candidateRegion.contains("://");
        }

        public static boolean isCustomEndpoint(String candidateEndpoint) {
            return StringUtils.isNotBlank((String)candidateEndpoint) && candidateEndpoint.contains("://");
        }
    }

    public class S3FastPathCredentials {
        private final Params ec2Params;
        private final String accessKey;
        private final String secretKey;
        private String sessionToken;

        public S3FastPathCredentials(AuthCtx authCtx, Params params) throws IOException, DKUSecurityException {
            this.ec2Params = params;
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential resolvedCredential = EC2Connection.this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            this.accessKey = resolvedCredential.accessKey;
            this.secretKey = resolvedCredential.secretKey;
            this.sessionToken = resolvedCredential.sessionToken;
        }

        public Params getEC2Params() {
            return this.ec2Params;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public String getCredentialStringForSnowflake() {
            Object credentialString = String.format("aws_key_id='%s' aws_secret_key='%s'", this.accessKey, this.secretKey);
            if (StringUtils.isNotBlank((String)this.sessionToken)) {
                credentialString = (String)credentialString + String.format(" aws_token='%s'", this.sessionToken);
            }
            return credentialString;
        }

        public String getCredentialStringForDatabricks() {
            Object credentialString = String.format("AWS_ACCESS_KEY='%s', AWS_SECRET_KEY='%s'", this.accessKey, this.secretKey);
            if (StringUtils.isNotBlank((String)this.sessionToken)) {
                credentialString = (String)credentialString + String.format(", AWS_SESSION_TOKEN='%s'", this.sessionToken);
            }
            return credentialString;
        }
    }
}

