/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FsConnection
extends DSSConnection
implements FSProviderizableConnection {
    public Params params = new Params();
    public static final String connectionType = "Filesystem";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.connection");

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.root = vc.expand(this.params.root);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public boolean isFSLike() {
        return true;
    }

    @Override
    public boolean isFS() {
        return true;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public List<String> getProviderTypes() {
        return Lists.newArrayList((Object[])new String[]{connectionType});
    }

    @Override
    public boolean allowManagedFolders() {
        return this.allowManagedFolders;
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    @Override
    public boolean mayBeSavedAsPersonalConnectionByNonAdmin() {
        return false;
    }

    @Override
    public void prepareConnectionForProvider() throws IOException {
        File root = new File(this.params.root);
        if (!root.exists()) {
            DKUFileUtils.mkdirs((File)root);
            ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
            if (impersonationService.isEnabled()) {
                new FilesystemACLHandler().ensureStudioPrivate(root);
                logger.debugV("Successfully tightened permissions for connection %s root path %s", new Object[]{this.name, root.toPath()});
            }
        }
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        throw new NotImplementedException();
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public String root;
        public boolean forcePathsOnDatasetsImport = false;
        public boolean manageLocalACLsForManagedFolders = true;
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public FSProviderizableConnection.FilesBasedDatasetNamingRule namingRule = new FSProviderizableConnection.FilesBasedDatasetNamingRule();
    }
}

