/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SAPHANASQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;

public class SAPHANAConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials {
    public static final String connectionType = "SAPHANA";
    protected Params params = new Params();
    private static SAPHANASQLDialect dialect;
    private static DKULogger logger;

    @Override
    public AbstractSQLConnection.AbstractSQLParams getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public SAPHANASQLDialect getDialect() {
        if (dialect == null) {
            dialect = new SAPHANASQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        return "com.sap.db.jdbc.Driver";
    }

    @Override
    String getJdbcUrl() {
        return "jdbc:sap://" + this.params.host + ":" + this.params.port;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.appSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecret);
        this.encryptCustomFields(cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.appSecret = cryptoService.decryptIfEncrypted(this.params.appSecret);
        this.decryptCustomFields(cryptoService);
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authType == AuthType.PASSWORD;
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = null;
        if (this.actuallyHasBasicCredential()) {
            creds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
        } else if (this.actuallyHasPerUserOAuth2Credential()) {
            String accessToken = this.getAccessToken(ctx.authCtx, this.getProxySettings());
            creds = new ICredentialsService.BasicCredential("", accessToken);
        }
        return clazz.cast(creds);
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(this.params.authorizationEndpoint).tokenEndpoint(this.params.tokenEndpoint).clientId(this.params.appId).clientSecret(this.params.appSecret).scope(this.params.scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        ICredentialsService.BasicCredential creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        if (this.actuallyHasBasicCredential() && creds != null) {
            if (creds.user != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            }
            if (creds.password != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
            }
        } else if (this.actuallyHasPerUserOAuth2Credential() && creds != null) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", "", false));
            if (creds.password != null) {
                cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
            }
        }
        return cd;
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()));
    }

    public String getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            OAuth2Client.AccessTokenResult result = this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, this.params.useIdToken);
            return result.getAccessToken();
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    static {
        logger = DKULogger.getLogger((String)"dku.sql.hana");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public AuthType authType = AuthType.PASSWORD;
        public int port = 5480;
        public String appId;
        public String appSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean useIdToken;
        public boolean refreshTokenRotation;
    }

    public static enum AuthType {
        PASSWORD,
        OAUTH2;

    }
}

