/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.iceberg;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.connections.iceberg.ClassFixingHTTPClient;
import com.dataiku.dip.connections.iceberg.IcebergCatalogHandler;
import com.dataiku.dip.util.IsolatedClassLoaderBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.hive.HiveCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.jdbc.JdbcCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.nessie.NessieCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.BaseHTTPClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTCatalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTUtil;
import com.dataiku.dss.shadelibawssk2.org.apache.iceberg.aws.glue.GlueCatalog;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;

public class IcebergCatalogHandlers {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.iceberg.handler");

    public static IcebergCatalogHandler getCatalogHandler(IcebergConnection connection) {
        switch (connection.params.icebergCatalogType) {
            case REST: {
                return RESTIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case GLUE: {
                return GlueIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case HIVE: {
                return HiveIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case HADOOP: {
                return HadoopIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case SNOWFLAKE: {
                return SnowflakeIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case JDBC: {
                return JdbcIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
            case NESSIE: {
                return NessieIcebergCatalogHandler.make(connection.params.icebergCatalogParams);
            }
        }
        throw new UnsupportedOperationException("Unknown iceberg catalog type " + String.valueOf((Object)connection.params.icebergCatalogType));
    }

    static class RESTIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final RESTIcebergCatalogParams params;

        static RESTIcebergCatalogHandler make(JsonObject catalogParams) {
            return new RESTIcebergCatalogHandler((RESTIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, RESTIcebergCatalogParams.class));
        }

        RESTIcebergCatalogHandler(RESTIcebergCatalogParams params) {
            this.params = params;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.uri), (Object)"No URI defined");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.warehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            Function<Map, RESTClient> clientBuilder = config -> new ClassFixingHTTPClient((BaseHTTPClient)HTTPClient.builder((Map)config).uri((String)config.get("uri")).withHeaders(RESTUtil.configHeaders((Map)config)).build());
            return new RESTCatalog(clientBuilder);
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return false;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return false;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("uri", this.params.uri, false));
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.warehouse, false));
            switch (creds.authType) {
                case PASSWORD: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.auth.type", "oauth2", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("credential", String.format("%s:%s", creds.user, creds.password), true));
                    break;
                }
                case OAUTH2_APP: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.auth.type", "oauth2", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("token", creds.oauth2AccessToken, true));
                    break;
                }
                case SIG_V4: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.auth.type", "sigv4", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.signing-name", creds.signingName, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.signing-region", creds.signingRegion, false));
                }
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.rest.RESTCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class RESTIcebergCatalogParams {
            public String uri;
            public String warehouse;

            RESTIcebergCatalogParams() {
            }
        }
    }

    static class GlueIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final GlueIcebergCatalogParams params;

        static GlueIcebergCatalogHandler make(JsonObject catalogParams) {
            return new GlueIcebergCatalogHandler((GlueIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, GlueIcebergCatalogParams.class));
        }

        GlueIcebergCatalogHandler(GlueIcebergCatalogParams params) {
            this.params = params;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.glueId), (Object)"AWS account ID not specified");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.glueWarehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            return new GlueCatalog();
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return false;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return false;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            if (StringUtils.isBlank((String)this.params.glueId)) {
                throw new IllegalArgumentException("No Glue Id defined");
            }
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("glue.id", this.params.glueId, false));
            if (StringUtils.isNotBlank((String)this.params.glueWarehouse)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.glueWarehouse, false));
            }
            if (StringUtils.isNotBlank((String)this.params.glueRegion)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.region", this.params.glueRegion, false));
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.aws.glue.GlueCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class GlueIcebergCatalogParams {
            public String glueId;
            public String glueWarehouse;
            public String glueRegion;

            GlueIcebergCatalogParams() {
            }
        }
    }

    static class HiveIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final HiveIcebergCatalogParams params;

        static HiveIcebergCatalogHandler make(JsonObject catalogParams) {
            return new HiveIcebergCatalogHandler((HiveIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, HiveIcebergCatalogParams.class));
        }

        HiveIcebergCatalogHandler(HiveIcebergCatalogParams params) {
            this.params = params;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.hiveUri), (Object)"No connection URI to Hive defined");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.hiveWarehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            return new HiveCatalog();
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return true;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return this.params.hiveImpersonateUser;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            if (StringUtils.isNotBlank((String)this.params.hiveUri)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("uri", this.params.hiveUri, false));
            }
            if (StringUtils.isNotBlank((String)this.params.hiveWarehouse)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.hiveWarehouse, false));
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.addAll(this.params.hiveProperties);
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.hive.HiveCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class HiveIcebergCatalogParams {
            public String hiveUri;
            public String hiveWarehouse;
            public boolean hiveImpersonateUser = true;
            public List<AbstractSQLConnection.CustomDatabaseProperty> hiveProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

            HiveIcebergCatalogParams() {
            }
        }
    }

    static class HadoopIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final HadoopIcebergCatalogParams params;

        static HadoopIcebergCatalogHandler make(JsonObject catalogParams) {
            return new HadoopIcebergCatalogHandler((HadoopIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, HadoopIcebergCatalogParams.class));
        }

        HadoopIcebergCatalogHandler(HadoopIcebergCatalogParams params) {
            this.params = params;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.hadoopWarehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            return new HadoopCatalog();
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return true;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return this.params.hadoopImpersonateUser;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            if (StringUtils.isNotBlank((String)this.params.hadoopWarehouse)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.hadoopWarehouse, false));
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.addAll(this.params.hadoopProperties);
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.hadoop.HadoopCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class HadoopIcebergCatalogParams {
            public String hadoopWarehouse;
            public boolean hadoopImpersonateUser = true;
            public List<AbstractSQLConnection.CustomDatabaseProperty> hadoopProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

            HadoopIcebergCatalogParams() {
            }
        }
    }

    static class SnowflakeIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final SnowflakeIcebergCatalogParams params;
        private static ClassLoader classLoader = null;

        static SnowflakeIcebergCatalogHandler make(JsonObject catalogParams) {
            return new SnowflakeIcebergCatalogHandler((SnowflakeIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, SnowflakeIcebergCatalogParams.class));
        }

        SnowflakeIcebergCatalogHandler(SnowflakeIcebergCatalogParams params) {
            this.params = params;
        }

        static ClassLoader getOrCreateSnowflakeClassloader() {
            if (classLoader == null) {
                try {
                    File driverJarsDirectory = DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-snowflake"});
                    File shadedSnowflakeJar = DKUApp.getInstallFile((String[])new String[]{"lib", "dss-shadelib", "dss-shadelib-snowflake.jar"});
                    classLoader = new IsolatedClassLoaderBuilder().withJarsInRecursiveDir(driverJarsDirectory).withJarFile(shadedSnowflakeJar).build();
                    Driver actualDriver = (Driver)Class.forName("net.snowflake.client.jdbc.SnowflakeDriver", true, classLoader).newInstance();
                    SQLDriverLoader.DriverWrapper driver = new SQLDriverLoader.DriverWrapper(actualDriver);
                    DriverManager.registerDriver(driver);
                    logger.info((Object)("Got the driver : " + actualDriver.getClass().getCanonicalName()));
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                    throw new IllegalArgumentException("Unable to create classloader for snowflake catalog", e);
                }
            }
            return classLoader;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.sfHost), (Object)"No Snowflake host defined");
        }

        @Override
        public Catalog newCatalog() {
            try {
                ClassLoader classLoader = SnowflakeIcebergCatalogHandler.getOrCreateSnowflakeClassloader();
                return (Catalog)classLoader.loadClass("com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake.SnowflakeCatalog").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Unable to load snowflake catalog class", e);
            }
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return false;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return false;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            String base = "https://" + this.params.sfHost;
            if (tokenEndpoint) {
                return base + "/oauth/token-request";
            }
            return base + "/oauth/authorize";
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            if (StringUtils.isBlank((String)this.params.sfHost)) {
                throw new IllegalArgumentException("No Snowflake host");
            }
            String jdbcUrl = String.format("jdbc:snowflake://%s", this.params.sfHost);
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("uri", jdbcUrl, false));
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.role", this.params.sfRole, false));
            switch (creds.authType) {
                case PASSWORD: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.user", creds.user, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.password", creds.password, true));
                    break;
                }
                case KEY_PAIR: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.user", creds.user, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.private_key_base64", creds.privateKeyB64, true));
                    if (!StringUtils.isNotBlank((String)creds.privateKeyPassword)) break;
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.private_key_pwd", creds.privateKeyPassword, true));
                    break;
                }
                case OAUTH2_APP: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.authenticator", "oauth", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.token", creds.oauth2AccessToken, true));
                }
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.snowflake.SnowflakeCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class SnowflakeIcebergCatalogParams {
            public String sfHost;
            public String sfRole;

            SnowflakeIcebergCatalogParams() {
            }
        }
    }

    static class JdbcIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final JdbcIcebergCatalogParams params;
        private static Map<String, ClassLoader> classloaders = new ConcurrentHashMap<String, ClassLoader>();
        private static Map<String, Driver> drivers = new ConcurrentHashMap<String, Driver>();

        static JdbcIcebergCatalogHandler make(JsonObject catalogParams) {
            return new JdbcIcebergCatalogHandler((JdbcIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, JdbcIcebergCatalogParams.class));
        }

        JdbcIcebergCatalogHandler(JdbcIcebergCatalogParams params) {
            this.params = params;
        }

        static ClassLoader getOrCreateClassloader(String jarsDirectory) throws IOException {
            if (!classloaders.containsKey(jarsDirectory)) {
                classloaders.put(jarsDirectory, new IsolatedClassLoaderBuilder().withJarsInRecursiveDir(jarsDirectory).build());
            }
            return classloaders.get(jarsDirectory);
        }

        static void ensureDriverIsLoaded(String driverClass, String jarsDirectory) {
            if (!drivers.containsKey(driverClass)) {
                try {
                    ClassLoader classLoader = JdbcIcebergCatalogHandler.getOrCreateClassloader(jarsDirectory);
                    Driver actualDriver = (Driver)Class.forName(driverClass, true, classLoader).newInstance();
                    SQLDriverLoader.DriverWrapper driver = new SQLDriverLoader.DriverWrapper(actualDriver);
                    DriverManager.registerDriver(driver);
                    logger.info((Object)("Got the driver : " + actualDriver.getClass().getCanonicalName()));
                    drivers.put(driverClass, driver);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
                    throw new IllegalArgumentException("Unable to load jdbc catalog class", e);
                }
            }
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.jdbcUri), (Object)"No connection URI defined");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.jdbcDriver), (Object)"No JDBC driver class specified");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.jdbcJarsDirectory), (Object)"No directory specified for the JDBC jars");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.jdbcWarehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            if (StringUtils.isBlank((String)this.params.jdbcJarsDirectory)) {
                throw new IllegalArgumentException("Driver jars directory is not defined");
            }
            if (StringUtils.isBlank((String)this.params.jdbcDriver)) {
                throw new IllegalArgumentException("Driver class is not defined");
            }
            JdbcIcebergCatalogHandler.ensureDriverIsLoaded(this.params.jdbcDriver, this.params.jdbcJarsDirectory);
            return new JdbcCatalog();
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return false;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return false;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            if (StringUtils.isBlank((String)this.params.jdbcUri)) {
                throw new IllegalArgumentException("No JDBC url defined");
            }
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("uri", this.params.jdbcUri, false));
            if (StringUtils.isNotBlank((String)this.params.jdbcWarehouse)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.jdbcWarehouse, false));
            }
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("io-impl", "com.dataiku.dss.shadelib.org.apache.iceberg.io.ResolvingFileIO", false));
            for (AbstractSQLConnection.CustomDatabaseProperty prop : this.params.jdbcProperties) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc." + prop.name, prop.value, prop.secret));
            }
            switch (creds.authType) {
                case PASSWORD: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.user", creds.user, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.password", creds.password, true));
                    break;
                }
                case OAUTH2_APP: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("jdbc.token", creds.oauth2AccessToken, true));
                }
            }
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.jdbc.JdbcCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            if (!this.params.sendDriverJarsToSpark) {
                return Lists.newArrayList();
            }
            String jarsDirectory = this.params.jdbcJarsDirectory;
            if (StringUtils.isBlank((String)jarsDirectory)) {
                jarsDirectory = ApplicationConfigurator.getFile((String[])new String[]{"lib", "jdbc"}).getAbsolutePath();
            }
            File jarsDir = new File(jarsDirectory);
            ArrayList ret = Lists.newArrayList();
            FilenameFilter jarFilter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.endsWith(".jar");
                }
            };
            for (File file : jarsDir.listFiles(jarFilter)) {
                ret.add(file.getAbsolutePath());
            }
            return ret;
        }

        static class JdbcIcebergCatalogParams {
            public String jdbcUri;
            public String jdbcDriver;
            public String jdbcWarehouse;
            public String jdbcJarsDirectory;
            public boolean sendDriverJarsToSpark;
            public List<AbstractSQLConnection.CustomDatabaseProperty> jdbcProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

            JdbcIcebergCatalogParams() {
            }
        }
    }

    static class NessieIcebergCatalogHandler
    implements IcebergCatalogHandler {
        private final NessieIcebergCatalogParams params;

        static NessieIcebergCatalogHandler make(JsonObject catalogParams) {
            return new NessieIcebergCatalogHandler((NessieIcebergCatalogParams)JSON.parse((JsonElement)catalogParams, NessieIcebergCatalogParams.class));
        }

        NessieIcebergCatalogHandler(NessieIcebergCatalogParams params) {
            this.params = params;
        }

        @Override
        public void checkConfiguration() {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.uri), (Object)"No URI defined");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.warehouse), (Object)"No warehouse defined");
        }

        @Override
        public Catalog newCatalog() {
            return new NessieCatalog();
        }

        @Override
        public boolean addCredentialsHadoopProperties() {
            return false;
        }

        @Override
        public boolean impersonateHadoopUser() {
            return false;
        }

        @Override
        public String guessOauth2Endpoint(boolean tokenEndpoint) {
            throw new IllegalArgumentException("Oauth2 endpoints are not defined");
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getCatalogProperties(IcebergConnection.SerializableIcebergCredentials creds) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("uri", this.params.uri, false));
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("warehouse", this.params.warehouse, false));
            switch (creds.authType) {
                case PASSWORD: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("authentication.type", "BASIC", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("authentication.username", creds.user, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("authentication.password", creds.password, true));
                    break;
                }
                case OAUTH2_APP: {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("authentication.type", "BEARER", false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("authentication.token", creds.oauth2AccessToken, true));
                }
            }
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("io-impl", "com.dataiku.dss.shadelib.org.apache.iceberg.io.ResolvingFileIO", false));
            return properties;
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getHadoopProperties() {
            return new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        }

        @Override
        public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkProperties(String sparkPropertyPrefix) {
            ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty(sparkPropertyPrefix + ".catalog-impl", "org.apache.iceberg.nessie.NessieCatalog", false));
            return properties;
        }

        @Override
        public List<String> getAdditionalSparkDriverJars() {
            return new ArrayList<String>();
        }

        static class NessieIcebergCatalogParams {
            public String uri;
            public String warehouse;

            NessieIcebergCatalogParams() {
            }
        }
    }
}

