/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.AbstractIsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class DeploymentMonitorThread
extends Thread {
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    private final String executionId;
    private final String deploymentName;
    private final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
    private final DKUtils.LineSubscriptionAttacher backendLog;
    private final DKUtils.LineSubscriptionAttacher setupLog;
    private final AuthCtx authCtx;
    private final String projectKey;
    private final ContainerExecRuntimeConfig containerConfig;
    private final File tmpDir;
    private final int initialReplicas;
    private final IStateLabelAggregator stateLabelAggregator;
    private final RunningProcessList runningProcessList;
    private DeploymentRolloutMonitorThread deploymentRolloutMonitorThread;
    private BackOffStrategy.BackOffNoException backOff;
    private static BackOffStrategy BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)DKUApp.getParams().getIntParam("dku.k8s.deployment.monitor.initialPollDelayMS", Integer.valueOf(8000)), (int)DKUApp.getParams().getIntParam("dku.k8s.deployment.monitor.maxPollDelayMS", Integer.valueOf(30000)), (double)DKUApp.getParams().getDoubleParam("dku.k8s.deployment.monitor.pollDelayMultiplier", 1.04));
    private boolean keepLooping = true;
    private final Object logRetrievingChange = new Object();
    private final Map<String, PodMonitorThread> pods = Maps.newConcurrentMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.k8s.deployment");

    public DeploymentMonitorThread(AuthCtx authCtx, String projectKey, String deploymentName, ContainerExecRuntimeConfig containerConfig, String executionId, IStateLabelAggregator stateLabelAggregator, int initialReplicas, File tmpDir, DKUtils.LineSubscriptionAttacher backendLog, DKUtils.LineSubscriptionAttacher setupLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder, RunningProcessList runningProcessList) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.deploymentName = deploymentName;
        this.containerConfig = containerConfig;
        this.executionId = executionId;
        this.stateLabelAggregator = stateLabelAggregator;
        this.initialReplicas = initialReplicas;
        this.tmpDir = tmpDir;
        this.backendLog = backendLog;
        this.setupLog = setupLog;
        this.smartLogTailBuilder = smartLogTailBuilder;
        this.runningProcessList = runningProcessList;
        this.backOff = BACKOFF_STRATEGY.buildNoException();
        this.setName("K8SDeplMonitor-" + executionId + "-" + this.getId());
    }

    public void logLine(String line) {
        logger.info((Object)line);
        String now = dateFormat.format(Instant.now());
        String lineWithTimestampAndContext = "[" + now + "] [k8s] " + line;
        try {
            this.setupLog.handle(lineWithTimestampAndContext, false);
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to log to rotating file", (Throwable)e);
        }
        this.smartLogTailBuilder.appendLine(lineWithTimestampAndContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info((Object)("Start monitoring deployment " + this.deploymentName));
        Closeable state = this.stateLabelAggregator.startWaitingOn("Waiting for pods in deployment");
        try {
            while (this.keepLooping) {
                try {
                    PodMonitorThread t;
                    ProcessBuilder pollDeploymentProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "get", "deployments", "-o", "name", "-l", "dataiku.com/dku-execution-id=" + this.executionId));
                    pollDeploymentProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                    pollDeploymentProcessBuilder.directory(this.tmpDir);
                    this.logLine("Polling deployment status: " + Joiner.on((String)" ").join(pollDeploymentProcessBuilder.command()));
                    RegularProcess pollDeploymentProcess = new RegularProcess(pollDeploymentProcessBuilder, this.tmpDir);
                    pollDeploymentProcess.setChattiness(AbstractIsolableProcess.Chattiness.SILENT);
                    pollDeploymentProcess.start();
                    DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
                    DKUtils.ExecOutputConsumer pollDeploymentEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.WARN)).withErrorConsumer((DKUtils.ExecSubscription)this.setupLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withTimestamps(true).withLineContext("[k8s] ");
                    pollDeploymentEoc.start(pollDeploymentProcess.getInputStream(), pollDeploymentProcess.getErrorStream(), null);
                    int rv = pollDeploymentProcess.waitFor();
                    if (rv != 0) {
                        throw new Exception("Unable to get status of deployment " + this.deploymentName);
                    }
                    pollDeploymentEoc.finish();
                    String found = new String(outputCollector.getCollected());
                    if (StringUtils.isBlank((String)found)) {
                        this.logLine("Deployment disappeared");
                        break;
                    }
                    this.logLine("Deployment found is " + found);
                    JsonObject obj = this.getPodList();
                    if (obj.has("items")) {
                        KubernetesExecUtils.PodStatusesSummary podStatuses = KubernetesExecUtils.getPodStatusesCount(obj);
                        for (String msg : podStatuses.errors) {
                            this.logLine(msg);
                        }
                        if (state != null) {
                            state.close();
                            state = null;
                            int runningCount = podStatuses.getRunningCount();
                            int failingCount = podStatuses.errors.size();
                            if (runningCount < this.initialReplicas) {
                                String counts = podStatuses.byStatus.entrySet().stream().map(e -> (String)e.getKey() + "*" + ((List)e.getValue()).size()).collect(Collectors.joining(", "));
                                state = this.stateLabelAggregator.startWaitingOn("Waiting for pods in deployment (" + counts + ")");
                            }
                            if (failingCount >= this.initialReplicas) {
                                throw new Exception("All pods failed to start");
                            }
                        }
                    }
                    HashMap podPhases = Maps.newHashMap();
                    if (obj.has("items")) {
                        JsonArray podList = obj.getAsJsonArray("items");
                        for (JsonElement e2 : podList) {
                            JsonObject podObj = (JsonObject)e2;
                            if (!podObj.has("metadata") || !podObj.getAsJsonObject("metadata").has("name")) continue;
                            String podId = podObj.getAsJsonObject("metadata").get("name").getAsString();
                            String podPhase = null;
                            if (podObj.has("status") && podObj.getAsJsonObject("status").has("phase")) {
                                podPhase = podObj.getAsJsonObject("status").get("phase").getAsString();
                            }
                            podPhases.put(podId, podPhase);
                        }
                    }
                    Set podIds = podPhases.keySet();
                    this.logLine("Pod list is " + Joiner.on((String)", ").join(podIds));
                    HashSet existing = Sets.newHashSet(this.pods.keySet());
                    Sets.SetView deadPods = Sets.difference((Set)existing, podIds);
                    Sets.SetView newPods = Sets.difference(podIds, (Set)existing);
                    for (String pod : deadPods) {
                        this.logLine("Pod " + pod + " died");
                        t = this.pods.remove(pod);
                        t.kill();
                    }
                    for (String pod : newPods) {
                        this.logLine("Pod " + pod + " arrived");
                        t = new PodMonitorThread(pod, this.logRetrievingChange, this);
                        t.start();
                        this.pods.put(pod, t);
                    }
                    for (String pod : podIds) {
                        PodMonitorThread podThread = this.pods.get(pod);
                        if (podThread == null) continue;
                        podThread.setPodPhase((String)podPhases.get(pod));
                    }
                }
                catch (Exception e3) {
                    logger.warn((Object)"Deployment watching failed", (Throwable)e3);
                }
                try {
                    Object e3 = this.logRetrievingChange;
                    synchronized (e3) {
                        long waitMillis = this.backOff.nextBackOffMillis();
                        if (waitMillis < 0L) {
                            logger.warn((Object)"Maximum waiting time reached for deployment monitor, stopping current");
                            this.keepLooping = false;
                            break;
                        }
                        logger.info((Object)("Will wait " + waitMillis + " ms"));
                        this.logRetrievingChange.wait(waitMillis);
                    }
                }
                catch (InterruptedException e4) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Interrupted in deployment monitor loop (wait)", (Throwable)e4);
                }
            }
        }
        finally {
            for (Map.Entry<String, PodMonitorThread> e5 : this.pods.entrySet()) {
                try {
                    e5.getValue().kill();
                }
                catch (Throwable t) {
                    logger.error((Object)"Failed to kill deployment monitor thread", t);
                }
            }
        }
    }

    boolean podIsKnown(String podId) {
        return this.pods.containsKey(podId);
    }

    public void kill() {
        this.keepLooping = false;
        this.interrupt();
        if (this.deploymentRolloutMonitorThread != null) {
            this.deploymentRolloutMonitorThread.kill();
        }
    }

    public JsonObject getPodList() throws Exception {
        ProcessBuilder listPodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "get", "pods", "-o", "json", "-l", "dataiku.com/dku-execution-id=" + this.executionId));
        listPodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
        listPodsProcessBuilder.directory(this.tmpDir);
        this.logLine("Listing pods: " + Joiner.on((String)" ").join(listPodsProcessBuilder.command()));
        RegularProcess listPodsProcess = new RegularProcess(listPodsProcessBuilder, this.tmpDir);
        listPodsProcess.setChattiness(AbstractIsolableProcess.Chattiness.SILENT);
        listPodsProcess.start();
        DKUtils.ByteCollectingSubscription podsOutputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer listPodsEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)podsOutputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.WARN)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)this.setupLog).withTimestamps(true).withLineContext("[k8s] ");
        listPodsEoc.start(listPodsProcess.getInputStream(), listPodsProcess.getErrorStream(), null);
        int podsRv = listPodsProcess.waitFor();
        if (podsRv != 0) {
            throw new Exception("Unable to get pods of deployment " + this.deploymentName);
        }
        listPodsEoc.finish();
        JsonObject obj = (JsonObject)JSON.parse((InputStream)new ByteArrayInputStream(podsOutputCollector.getCollected()), JsonObject.class);
        logger.trace(() -> "Pods JSON: " + JSON.prettyLog((Object)obj));
        return obj;
    }

    private long grabPodLogs(String podId, boolean stream, Long lastLogEnd) throws Exception {
        ArrayList kcommand = Lists.newArrayList((Object[])new String[]{"logs"});
        if (stream) {
            kcommand.add("-f");
        }
        kcommand.addAll(Lists.newArrayList((Object[])new String[]{"pods/" + podId, "-c", "c"}));
        String[] podLogCommand = KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, kcommand.toArray(new String[0]));
        ArrayList podlogCommandWithSince = Lists.newArrayList(Arrays.asList(podLogCommand));
        if (lastLogEnd != null) {
            long sinceLast = Math.max(0L, System.currentTimeMillis() - lastLogEnd) + 1000L;
            podlogCommandWithSince.add("--since=" + sinceLast + "ms");
        }
        ProcessBuilder logProcessBuilder = new ProcessBuilder(podlogCommandWithSince.toArray(new String[0]));
        logProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
        logProcessBuilder.directory(this.tmpDir);
        this.logLine("Polling pod logs: " + Joiner.on((String)" ").join(logProcessBuilder.command()));
        RegularProcess logProcess = new RegularProcess(logProcessBuilder, this.tmpDir);
        logProcess.setChattiness(AbstractIsolableProcess.Chattiness.SILENT);
        logProcess.start();
        DKUtils.ExecOutputConsumer logProcessEoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(logger, Level.WARN)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)this.backendLog).withErrorConsumer((DKUtils.ExecSubscription)this.backendLog).withTimestamps(true).withLineContext("[backend] ");
        logProcessEoc.start(logProcess.getInputStream(), logProcess.getErrorStream(), null);
        int lrv = logProcess.waitFor();
        if (lrv != 0) {
            logger.warn((Object)("Unable to get logs of pod " + podId));
        } else {
            logger.debug((Object)("Pod " + podId + " log streaming finished successfully"));
        }
        long logEnd = System.currentTimeMillis();
        logProcessEoc.finish();
        return logEnd;
    }

    public void grabPodsLogs() {
        try {
            JsonObject obj = this.getPodList();
            KubernetesExecUtils.PodStatusesSummary podStatuses = KubernetesExecUtils.getPodStatusesCount(obj);
            logger.info((Object)("Pod statuses are " + JSON.log((Object)podStatuses)));
            for (List<String> podIdList : podStatuses.byStatus.values()) {
                for (String podId : podIdList) {
                    this.grabPodLogs(podId, false, null);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get logs of pods before killing deployment", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRollout() throws Exception {
        block11: {
            try (Closeable state = this.stateLabelAggregator.startWaitingOn("Waiting for deployment rollout");){
                int podsRv;
                ProcessBuilder rolloutProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, true, "rollout", "status", "deployment/" + this.deploymentName));
                rolloutProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                rolloutProcessBuilder.directory(this.tmpDir);
                this.logLine("Rollout deployment " + Joiner.on((String)" ").join(rolloutProcessBuilder.command()));
                RegularProcess rolloutProcess = new RegularProcess(rolloutProcessBuilder, this.tmpDir);
                this.runningProcessList.addRunning(rolloutProcess);
                rolloutProcess.start();
                DKUtils.ExecOutputConsumer rolloutEoc = new DKUtils.ExecOutputConsumer().withTimestamps(true).withLineContext("[k8s] ").withOutputConsumer((DKUtils.ExecSubscription)this.setupLog).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)this.setupLog).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
                rolloutEoc.start(rolloutProcess.getInputStream(), rolloutProcess.getErrorStream(), null);
                RemoteRunsRegistry.get((String)this.executionId).uploadListener = new RemoteRunsRegistry.RemoteFileUploadListener(){

                    @Override
                    public void notifyUpload(String path) {
                        if ("error.json".equals(path)) {
                            DeploymentMonitorThread.this.runningProcessList.killRunningProcesses();
                        }
                    }
                };
                this.deploymentRolloutMonitorThread = new DeploymentRolloutMonitorThread();
                this.deploymentRolloutMonitorThread.start();
                int rv = rolloutProcess.waitFor();
                this.deploymentRolloutMonitorThread.kill();
                this.runningProcessList.removeRunning(rolloutProcess);
                RemoteRunsRegistry.get((String)this.executionId).uploadListener = null;
                rolloutEoc.finish();
                if (new File(this.tmpDir, "error.json").exists()) {
                    logger.info((Object)"Rollout was killed by the uploading of an error file");
                    this.grabPodsLogs();
                    return;
                }
                if (rv == 0) break block11;
                try {
                    logger.info((Object)("Describing pods of deployment " + this.deploymentName));
                    ProcessBuilder describePodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "describe", "pods", "-l", "dataiku.com/dku-execution-id=" + this.executionId));
                    describePodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                    describePodsProcessBuilder.directory(this.tmpDir);
                    this.logLine("Describe pods " + Joiner.on((String)" ").join(describePodsProcessBuilder.command()));
                    RegularProcess describePodsProcess = new RegularProcess(describePodsProcessBuilder, this.tmpDir);
                    describePodsProcess.start();
                    DKUtils.ExecOutputConsumer describePodsEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)this.setupLog).withErrorConsumer((DKUtils.ExecSubscription)this.setupLog).withTimestamps(true).withLineContext("[k8s] ");
                    describePodsEoc.start(describePodsProcess.getInputStream(), describePodsProcess.getErrorStream(), null);
                    podsRv = describePodsProcess.waitFor();
                    if (podsRv != 0) {
                        throw new Exception("Unable to describe pods of deployment " + this.deploymentName);
                    }
                    describePodsEoc.finish();
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to describe pods", (Throwable)e);
                }
                try {
                    logger.info((Object)("Grabbing logs of pods of deployment " + this.deploymentName));
                    ProcessBuilder logPodsProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, "logs", "-l", "dataiku.com/dku-execution-id=" + this.executionId, "-c", "c"));
                    logPodsProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                    logPodsProcessBuilder.directory(this.tmpDir);
                    this.logLine("Log pods " + Joiner.on((String)" ").join(logPodsProcessBuilder.command()));
                    RegularProcess logPodsProcess = new RegularProcess(logPodsProcessBuilder, this.tmpDir);
                    logPodsProcess.start();
                    DKUtils.ExecOutputConsumer logPodsEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)this.backendLog).withErrorConsumer((DKUtils.ExecSubscription)this.backendLog).withTimestamps(true).withLineContext("[backend] ");
                    logPodsEoc.start(logPodsProcess.getInputStream(), logPodsProcess.getErrorStream(), null);
                    podsRv = logPodsProcess.waitFor();
                    if (podsRv != 0) {
                        throw new Exception("Unable to log pods of deployment " + this.deploymentName);
                    }
                    logPodsEoc.finish();
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to log pods", (Throwable)e);
                }
                throw new Exception("Unable to rollout deployment " + this.deploymentName);
            }
        }
    }

    private String doKubectlDescribe(String type, String name) {
        ArrayList command = Lists.newArrayList((Object[])new String[]{"describe", type});
        if (StringUtils.isNotBlank((String)name)) {
            command.add(name);
        } else {
            command.add("-l");
            command.add("dataiku.com/dku-execution-id=" + this.executionId);
        }
        try {
            ProcessBuilder describeProcessBuilder = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(this.authCtx, this.projectKey, this.containerConfig, false, command.toArray(new String[0])));
            describeProcessBuilder.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
            describeProcessBuilder.directory(this.tmpDir);
            logger.info((Object)("Describe " + Joiner.on((String)" ").join(describeProcessBuilder.command())));
            RegularProcess describeProcess = new RegularProcess(describeProcessBuilder, this.tmpDir);
            describeProcess.start();
            DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
            DKUtils.ExecOutputConsumer describeEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)outputCollector).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
            describeEoc.start(describeProcess.getInputStream(), describeProcess.getErrorStream(), null);
            int rv = describeProcess.waitFor();
            if (rv != 0) {
                throw new Exception("Unable to get status of deployment " + this.deploymentName);
            }
            describeEoc.finish();
            return new String(outputCollector.getCollected());
        }
        catch (Exception e) {
            logger.error((Object)("Failed to describe " + type + "/" + name), (Throwable)e);
            return ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
    }

    public List<DeployedKubectlObject> getKubectlDescribes() {
        DeployedKubectlObject deployment = new DeployedKubectlObject();
        deployment.type = "deployment";
        deployment.name = this.deploymentName;
        deployment.describe = this.doKubectlDescribe(deployment.type, deployment.name);
        ArrayList ret = Lists.newArrayList((Object[])new DeployedKubectlObject[]{deployment});
        ArrayList podNames = Lists.newArrayList(this.pods.keySet());
        for (String podName : podNames) {
            DeployedKubectlObject pod = new DeployedKubectlObject();
            pod.type = "pod";
            pod.name = podName;
            pod.describe = this.doKubectlDescribe(pod.type, pod.name);
            ret.add(pod);
        }
        return ret;
    }

    public static interface RunningProcessList {
        public void addRunning(RegularProcess var1);

        public void removeRunning(RegularProcess var1);

        public List<RegularProcess> getRunning();

        public void killRunningProcesses();
    }

    private class PodMonitorThread
    extends Thread {
        private final String podId;
        private final Object logRetrievingChange;
        private final DeploymentMonitorThread parent;
        private volatile boolean keepLooping = true;
        private volatile String podPhase = null;
        private boolean polledAfterDeath = false;

        public PodMonitorThread(String podId, Object logRetrievingChange, DeploymentMonitorThread parent) {
            this.podId = podId;
            this.logRetrievingChange = logRetrievingChange;
            this.parent = parent;
            String podShortId = podId.replace(DeploymentMonitorThread.this.deploymentName, "");
            this.setName("K8SDeplMonitor-" + DeploymentMonitorThread.this.executionId + "-Pod-" + podShortId + "-" + this.getId());
        }

        public void kill() {
            this.keepLooping = false;
            this.interrupt();
        }

        public void setPodPhase(String phase) {
            this.podPhase = phase;
        }

        private boolean isPodDead() {
            if (!this.parent.podIsKnown(this.podId)) {
                logger.warn((Object)("Pod thread for " + this.podId + " not known by parent anymore (keepLooping=" + this.keepLooping + ")"));
                return true;
            }
            return "succeeded".equalsIgnoreCase(this.podPhase) || "failed".equalsIgnoreCase(this.podPhase);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            DeploymentMonitorThread.this.logLine("Start retrieving logs for pod " + this.podId);
            Long lastLogEnd = null;
            while (this.keepLooping && !this.polledAfterDeath) {
                try {
                    logger.debug((Object)("Starting to grab logs of " + this.podId));
                    boolean podWasDead = this.isPodDead();
                    lastLogEnd = DeploymentMonitorThread.this.grabPodLogs(this.podId, true, lastLogEnd);
                    if (podWasDead) {
                        DeploymentMonitorThread.this.logLine("Pod is finished, not expecting logs anymore");
                        this.polledAfterDeath = true;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Pod log retrieval failed", (Throwable)e);
                }
                finally {
                    logger.debug((Object)("Done grabbing logs of " + this.podId));
                }
                Object e = this.logRetrievingChange;
                synchronized (e) {
                    this.logRetrievingChange.notifyAll();
                }
                try {
                    Thread.sleep(pollInterval);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Interrupted in port forwarder loop", (Throwable)e2);
                }
            }
            DeploymentMonitorThread.this.logLine("Done retrieving logs for pod " + this.podId);
        }
    }

    private class DeploymentRolloutMonitorThread
    extends Thread {
        private boolean keepLooping = true;

        private DeploymentRolloutMonitorThread() {
        }

        @Override
        public void run() {
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            logger.info((Object)("Start monitoring deployment rollout " + DeploymentMonitorThread.this.deploymentName));
            while (this.keepLooping) {
                try {
                    JsonObject obj = DeploymentMonitorThread.this.getPodList();
                    if (obj.has("items")) {
                        KubernetesExecUtils.PodStatusesSummary podStatuses = KubernetesExecUtils.getPodStatusesCount(obj);
                        int failingCount = podStatuses.errors.size();
                        if (failingCount >= DeploymentMonitorThread.this.initialReplicas) {
                            DeploymentMonitorThread.this.runningProcessList.killRunningProcesses();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Deployment rollout watching failed", (Throwable)e);
                }
                try {
                    Thread.sleep(pollInterval);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Deployment rollout watching interrupted");
                }
            }
        }

        public void kill() {
            if (this.keepLooping) {
                this.keepLooping = false;
                this.interrupt();
            }
        }
    }

    public static class DeployedKubectlObject {
        public String type;
        public String name;
        public String describe;
    }
}

