/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.ConditionalOutput;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.SavedModelHandler;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.documenttemplating.DocumentTemplatingInput;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.retrieval.RAGLLMSettings;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.projects.importexport.RetrievalAugmentedLLMConnectionsUtils;
import com.dataiku.dip.savedmodels.agents.AgentTypesRegistry;
import com.dataiku.dip.savedmodels.agents.CustomAgentDependenciesCollector;
import com.dataiku.dip.savedmodels.agents.CustomAgentMeta;
import com.dataiku.dip.savedmodels.proxymodels.ProxyModelConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.util.Strings;
import com.dataiku.j2py.annotations.PyModel;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@UIModel
public class SavedModel
extends TaggableObjectsService.TaggableObject
implements Partitionable {
    public boolean needsInputDataFolder = false;
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public SavedModelType savedModelType = SavedModelType.DSS_MANAGED;
    public ModelPublishPolicy publishPolicy = ModelPublishPolicy.UNCONDITIONAL;
    public SerializedDataset.RebuildBehavior rebuildBehavior = SerializedDataset.RebuildBehavior.EXPLICIT;
    public boolean cleanTemporaryVersionsPostJob;
    public String name;
    public String contentType;
    public static String llmFinetuningContentType = "llm/fine-tuning";
    public String activeVersion;
    @Nullable
    public ProxyModelConfiguration proxyModelConfiguration;
    public List<SavedModelInlineVersion> inlineVersions = new ArrayList<SavedModelInlineVersion>();
    public List<ConditionalOutput> conditionalOutputs = new ArrayList<ConditionalOutput>();
    public PartitioningScheme partitioning = new PartitioningScheme();
    public SerializedDataset.FlowOptions flowOptions = new SerializedDataset.FlowOptions();
    public String lastExportedFrom;
    public ProbesSet metrics = new ProbesSet();
    public ChecksSet metricsChecks = new ChecksSet();
    public MLTask miniTask;
    public long lastTrainIndex = 1L;
    public String lastTrainJobId = "";

    public SavedModel() {
    }

    public SavedModel(String projectKey, String id) {
        this.projectKey = projectKey;
        this.id = id;
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.SAVED_MODEL;
    }

    @Override
    public String getSubtype() {
        return this.getType().toString();
    }

    public IndexableType getIndexableType() {
        if (this.savedModelType != null && this.savedModelType.isGenAiModel()) {
            return IndexableType.GEN_AI_MODEL;
        }
        if (this.savedModelType != null && this.savedModelType.isAgent()) {
            return IndexableType.AGENT;
        }
        return IndexableType.SAVED_MODEL;
    }

    @Override
    public PartitioningScheme getPartitioningSchema() {
        return this.partitioning;
    }

    @Override
    public SerializedDataset.FlowOptions getFlowOptions() {
        return this.flowOptions;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public PartitionableHandler buildHandler(AuthCtx authCtx) {
        return new SavedModelHandler(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getActiveVersion() {
        return this.activeVersion;
    }

    public SavedModelInlineVersion getActiveSaveModelInlineVersion() {
        return this.inlineVersions.stream().filter(inlineVersion -> this.activeVersion.equals(inlineVersion.versionId)).findAny().orElse(null);
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public MLTask.MLTaskType getType() {
        if (this.savedModelType == null) {
            Logger.getLogger((String)"dku").warn((Object)("Bad SM type in SM " + this.id));
            throw new NullPointerException("Bad SM type in SM " + this.id);
        }
        switch (this.savedModelType.savedModelHandlingType) {
            case INTERNAL: {
                return this.miniTask.taskType;
            }
            case EXTERNAL_MLFLOW: {
                return MLTask.MLTaskType.PREDICTION;
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: 
            case LLM_GENERIC: 
            case RETRIEVAL_AUGMENTED_LLM: {
                return MLTask.MLTaskType.LLM_GENERIC_RAW;
            }
        }
        throw new Error("unreachable");
    }

    public boolean isPartitioned() {
        return this.partitioning != null && this.partitioning.getDimensionNames().size() > 0;
    }

    public void incrementLastTrainIndex(String jobId) {
        if (!StringUtils.equals((String)this.lastTrainJobId, (String)jobId)) {
            ++this.lastTrainIndex;
            this.lastTrainJobId = jobId;
        }
    }

    public String getNextVersionSuffix() {
        return " - v" + (this.lastTrainIndex + 1L);
    }

    public String getInitialVersionSuffix() {
        return " - v1";
    }

    public String getMLCategory() {
        switch (this.savedModelType) {
            case MLFLOW_PYFUNC: {
                return "mlflow";
            }
            case LLM_GENERIC: {
                return "fine_tuning";
            }
            case PYTHON_AGENT: {
                return "python_agent";
            }
            case PLUGIN_AGENT: {
                return "plugin_agent";
            }
            case TOOLS_USING_AGENT: {
                return "tools_using_agent";
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                return "retrieval_augmented_llm";
            }
            case PROXY_MODEL: {
                if (this.proxyModelConfiguration == null) break;
                switch (this.proxyModelConfiguration.protocol) {
                    case "sagemaker": {
                        return "sagemaker";
                    }
                    case "vertex-ai": {
                        return "vertex";
                    }
                    case "azure-ml": {
                        return "azure-ml";
                    }
                    case "databricks": {
                        return "databricks";
                    }
                }
            }
        }
        switch (this.getType()) {
            case CLUSTERING: {
                return "clustering";
            }
            case PREDICTION: {
                if (this.miniTask.backendType == MLTask.BackendType.KERAS) {
                    return "keras";
                }
                switch (((PredictionMLTask)this.miniTask).predictionType) {
                    case TIMESERIES_FORECAST: {
                        return "timeseries";
                    }
                    case CAUSAL_REGRESSION: 
                    case CAUSAL_BINARY_CLASSIFICATION: {
                        return "causal";
                    }
                    case DEEP_HUB_IMAGE_CLASSIFICATION: {
                        return "deephub_image_classification";
                    }
                    case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                        return "deephub_object_detection";
                    }
                }
            }
        }
        return "prediction";
    }

    public String getObjectIconPath() {
        switch (this.savedModelType) {
            case MLFLOW_PYFUNC: {
                return "ml/dku-icon-flow-colored-model-mlflow.png";
            }
            case LLM_GENERIC: {
                return "llm/dku-icon-flow-colored-finetuned-savedmodel.png";
            }
            case PYTHON_AGENT: {
                return "llm/dku-icon-flow-colored-agent-code.png";
            }
            case PLUGIN_AGENT: {
                return "llm/dku-icon-flow-colored-agent-plugin.png";
            }
            case TOOLS_USING_AGENT: {
                return "llm/dku-icon-flow-colored-agent-visual.png";
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                return "llm/dku-icon-flow-colored-retrieval-augmented.png";
            }
            case PROXY_MODEL: {
                if (this.proxyModelConfiguration == null) break;
                switch (this.proxyModelConfiguration.protocol) {
                    case "sagemaker": {
                        return "ml/dku-icon-flow-colored-model-external-sagemaker.png";
                    }
                    case "vertex-ai": {
                        return "ml/dku-icon-flow-colored-model-external-vertex.png";
                    }
                    case "azure-ml": {
                        return "ml/dku-icon-flow-colored-model-external-azure-ml.png";
                    }
                    case "databricks": {
                        return "ml/dku-icon-flow-colored-model-external-databricks.png";
                    }
                }
            }
        }
        switch (this.getType()) {
            case CLUSTERING: {
                return "ml/dku-icon-flow-colored-machine-learning-clustering.png";
            }
            case PREDICTION: {
                if (this.miniTask.backendType == MLTask.BackendType.KERAS) {
                    return "ml/dku-icon-flow-colored-machine-learning-deep-learning.png";
                }
                switch (((PredictionMLTask)this.miniTask).predictionType) {
                    case TIMESERIES_FORECAST: {
                        return "ml/dku-icon-flow-colored-machine-learning-timeseries.png";
                    }
                    case CAUSAL_REGRESSION: 
                    case CAUSAL_BINARY_CLASSIFICATION: {
                        return "ml/dku-icon-flow-colored-machine-learning-causal.png";
                    }
                    case DEEP_HUB_IMAGE_CLASSIFICATION: 
                    case DEEP_HUB_IMAGE_OBJECT_DETECTION: {
                        return "ml/dku-icon-flow-colored-machine-computer-vision.png";
                    }
                }
            }
        }
        return "ml/dku-icon-flow-colored-machine-learning-regression.png";
    }

    public AgentSettings getAgentSettings(SavedModelInlineVersion smiv) {
        switch (this.savedModelType) {
            case PYTHON_AGENT: {
                return smiv.pythonAgentSettings;
            }
            case PLUGIN_AGENT: {
                return smiv.pluginAgentSettings;
            }
            case TOOLS_USING_AGENT: {
                return smiv.toolsUsingAgentSettings;
            }
        }
        throw new IllegalStateException("getAgentSettings shouldn't only be used with agent, used with " + String.valueOf((Object)this.savedModelType) + " instead.");
    }

    public Set<String> getLlmConnections() {
        HashSet<String> llmConnections = new HashSet<String>();
        switch (this.savedModelType) {
            case TOOLS_USING_AGENT: {
                block9: for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    ToolsUsingAgentSettings agentSettings = (ToolsUsingAgentSettings)this.getAgentSettings(smiv);
                    switch (agentSettings.mode) {
                        case SIMPLE: {
                            if (agentSettings.llmId == null || agentSettings.llmId.isEmpty()) break;
                            LLMStructuredRef llmRef = LLMStructuredRef.decodeId(agentSettings.llmId);
                            if (llmRef == null || llmRef.connection == null) continue block9;
                            llmConnections.add(llmRef.connection);
                            break;
                        }
                        case BLOCKS_GRAPH: {
                            Set blocksConnections = agentSettings.blocks.stream().flatMap(block -> {
                                LLMStructuredRef llmRef;
                                LLMBlock llmBlock;
                                if (block instanceof LLMBlock && !Strings.isBlank((String)(llmBlock = (LLMBlock)((Object)block)).getLlmId()) && (llmRef = LLMStructuredRef.decodeId(llmBlock.getLlmId())) != null && llmRef.connection != null) {
                                    return Stream.of(llmRef.connection);
                                }
                                return Stream.empty();
                            }).collect(Collectors.toSet());
                            llmConnections.addAll(blocksConnections);
                        }
                    }
                }
                break;
            }
            case PLUGIN_AGENT: {
                for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    CustomAgentMeta meta = AgentTypesRegistry.getMeta(smiv.pluginAgentType);
                    for (LLMStructuredRef llmRef : CustomAgentDependenciesCollector.collectLlmDependencies(meta.getAgentDesc().params, smiv.pluginAgentConfig).values()) {
                        if (llmRef == null || llmRef.connection == null) continue;
                        llmConnections.add(llmRef.connection);
                    }
                }
                break;
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    RAGLLMSettings settings = smiv.ragllmSettings;
                    if (settings.llmId == null) continue;
                    LLMStructuredRef ref = LLMStructuredRef.decodeId(settings.llmId);
                    if (ref.connection != null) {
                        llmConnections.add(ref.connection);
                    }
                    if (!settings.hasGuardrailsEnabled()) continue;
                    if (settings.ragSpecificGuardrails.embeddingModelId != null) {
                        LLMStructuredRef guardrailEmbedRef = LLMStructuredRef.decodeId(settings.ragSpecificGuardrails.embeddingModelId);
                        if (ref.connection != null) {
                            llmConnections.add(guardrailEmbedRef.connection);
                        }
                    }
                    if (settings.ragSpecificGuardrails.llmId == null) continue;
                    LLMStructuredRef guardrailCompletionRef = LLMStructuredRef.decodeId(settings.ragSpecificGuardrails.llmId);
                    if (ref.connection == null) continue;
                    llmConnections.add(guardrailCompletionRef.connection);
                }
                break;
            }
        }
        return llmConnections;
    }

    public void remapLLmConnections(Map<String, String> replacements) {
        switch (this.savedModelType) {
            case TOOLS_USING_AGENT: {
                for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    ToolsUsingAgentSettings agentSettings = (ToolsUsingAgentSettings)this.getAgentSettings(smiv);
                    switch (agentSettings.mode) {
                        case SIMPLE: {
                            if (agentSettings.llmId == null || agentSettings.llmId.isEmpty()) break;
                            LLMStructuredRef oldRef = LLMStructuredRef.decodeId(agentSettings.llmId);
                            if (oldRef.connection == null || !replacements.containsKey(oldRef.connection)) break;
                            LLMStructuredRef newRef = oldRef.withOtherConnection(replacements.get(oldRef.connection));
                            agentSettings.llmId = newRef.encodeToId();
                            break;
                        }
                        case BLOCKS_GRAPH: {
                            agentSettings.blocks.forEach(block -> {
                                if (block instanceof LLMBlock) {
                                    LLMBlock llmBlock = (LLMBlock)((Object)block);
                                    if (Strings.isBlank((String)llmBlock.getLlmId())) {
                                        return;
                                    }
                                    LLMStructuredRef oldRef = LLMStructuredRef.decodeId(llmBlock.getLlmId());
                                    if (oldRef.connection == null || !replacements.containsKey(oldRef.connection)) {
                                        return;
                                    }
                                    LLMStructuredRef newRef = oldRef.withOtherConnection((String)replacements.get(oldRef.connection));
                                    llmBlock.setLlmId(newRef.encodeToId());
                                }
                            });
                        }
                    }
                }
                break;
            }
            case PLUGIN_AGENT: {
                for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    CustomAgentMeta meta = AgentTypesRegistry.getMeta(smiv.pluginAgentType);
                    for (Map.Entry<String, LLMStructuredRef> entry : CustomAgentDependenciesCollector.collectLlmDependencies(meta.getAgentDesc().params, smiv.pluginAgentConfig).entrySet()) {
                        String newConnection;
                        LLMStructuredRef llmRef = entry.getValue();
                        if (llmRef == null || llmRef.connection == null || (newConnection = replacements.get(llmRef.connection)) == null) continue;
                        LLMStructuredRef newLlmRef = llmRef.withOtherConnection(newConnection);
                        JsonUtils.addFieldIfNotNull(smiv.pluginAgentConfig, entry.getKey(), newLlmRef.encodeToId());
                    }
                }
                break;
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                for (SavedModelInlineVersion smiv : this.inlineVersions) {
                    RetrievalAugmentedLLMConnectionsUtils.remapConnections(smiv.ragllmSettings, replacements);
                }
                break;
            }
        }
    }

    public Optional<SavedModelInlineVersion> getVersion(String versionId) {
        return this.inlineVersions.stream().filter(version -> versionId.equals(version.versionId)).findFirst();
    }

    @UIModel
    public static enum SavedModelType {
        DSS_MANAGED(SavedModelHandlingType.INTERNAL),
        MLFLOW_PYFUNC(SavedModelHandlingType.EXTERNAL_MLFLOW),
        PROXY_MODEL(SavedModelHandlingType.EXTERNAL_MLFLOW),
        PYTHON_AGENT(SavedModelHandlingType.PYTHON_AGENT),
        PLUGIN_AGENT(SavedModelHandlingType.PLUGIN_AGENT),
        TOOLS_USING_AGENT(SavedModelHandlingType.TOOLS_USING_AGENT),
        LLM_GENERIC(SavedModelHandlingType.LLM_GENERIC),
        RETRIEVAL_AUGMENTED_LLM(SavedModelHandlingType.RETRIEVAL_AUGMENTED_LLM);

        public final SavedModelHandlingType savedModelHandlingType;

        private SavedModelType(SavedModelHandlingType savedModelHandlingType) {
            this.savedModelHandlingType = savedModelHandlingType;
        }

        public boolean isAgent() {
            return this == PYTHON_AGENT || this == PLUGIN_AGENT || this == TOOLS_USING_AGENT;
        }

        public boolean isPluginAgent() {
            return this == PLUGIN_AGENT;
        }

        public boolean isRetrievalAugmentedLlm() {
            return this == RETRIEVAL_AUGMENTED_LLM;
        }

        public boolean isLLM() {
            return !this.isML();
        }

        public boolean isGenAiModel() {
            return this == LLM_GENERIC || this == RETRIEVAL_AUGMENTED_LLM;
        }

        public boolean isML() {
            return this == DSS_MANAGED || this == MLFLOW_PYFUNC || this == PROXY_MODEL;
        }
    }

    public static enum ModelPublishPolicy {
        MANUAL,
        UNCONDITIONAL;

    }

    @UIModel
    public static class SavedModelInlineVersion {
        public String versionId;
        public String description;
        @Nullable
        public VersionTag versionTag;
        @Nullable
        public VersionTag creationTag;
        @JSON.FileTransient
        @Nullable
        public String code;
        public PythonAgentSettings pythonAgentSettings = new PythonAgentSettings();
        @Nullable
        public String pluginAgentType;
        @Nullable
        public JsonObject pluginAgentConfig;
        public PluginAgentSettings pluginAgentSettings = new PluginAgentSettings();
        public ToolsUsingAgentSettings toolsUsingAgentSettings = new ToolsUsingAgentSettings();
        public RAGLLMSettings ragllmSettings = new RAGLLMSettings();
        public String quickTestQueryStr;
        public GuardrailsPipelineSettings guardrailsPipelineSettings = new GuardrailsPipelineSettings();

        public SavedModelInlineVersion() {
        }

        public SavedModelInlineVersion(SavedModelInlineVersion other) {
            this.versionId = other.versionId;
            this.description = other.description;
            this.code = other.code;
            this.versionTag = (VersionTag)JSON.parse((String)JSON.json((Object)other.versionTag), VersionTag.class);
            this.creationTag = (VersionTag)JSON.parse((String)JSON.json((Object)other.creationTag), VersionTag.class);
            this.pythonAgentSettings = new PythonAgentSettings(other.pythonAgentSettings);
            this.pluginAgentType = other.pluginAgentType;
            if (other.pluginAgentConfig != null) {
                this.pluginAgentConfig = other.pluginAgentConfig.deepCopy();
            }
            this.pluginAgentSettings = new PluginAgentSettings(other.pluginAgentSettings);
            this.toolsUsingAgentSettings = new ToolsUsingAgentSettings(other.toolsUsingAgentSettings);
            this.quickTestQueryStr = other.quickTestQueryStr;
            this.guardrailsPipelineSettings = new GuardrailsPipelineSettings(other.guardrailsPipelineSettings);
            this.ragllmSettings = new RAGLLMSettings(other.ragllmSettings);
        }

        public AgentSettings getAgentSettings(SavedModelType savedModelType) {
            return switch (savedModelType) {
                case SavedModelType.TOOLS_USING_AGENT -> this.toolsUsingAgentSettings;
                case SavedModelType.PYTHON_AGENT -> this.pythonAgentSettings;
                case SavedModelType.PLUGIN_AGENT -> this.pluginAgentSettings;
                default -> null;
            };
        }
    }

    public static enum SavedModelHandlingType {
        INTERNAL,
        EXTERNAL_MLFLOW,
        PYTHON_AGENT,
        PLUGIN_AGENT,
        TOOLS_USING_AGENT,
        LLM_GENERIC,
        RETRIEVAL_AUGMENTED_LLM;

    }

    public static class PythonAgentSettings
    extends AgentSettings {
        public CodeEnvSelection codeEnvSelection = new CodeEnvSelection();
        public List<AgentDependency> dependencies = new ArrayList<AgentDependency>();
        public Boolean supportsImageInputs = false;
        public Boolean canBeBlockedByCostLimiting = true;

        public PythonAgentSettings() {
        }

        public PythonAgentSettings(PythonAgentSettings other) {
            super(other);
            this.codeEnvSelection = new CodeEnvSelection(other.codeEnvSelection);
            for (AgentDependency otherDependency : other.dependencies) {
                this.dependencies.add(new AgentDependency(otherDependency));
            }
            this.supportsImageInputs = other.supportsImageInputs;
            this.canBeBlockedByCostLimiting = other.canBeBlockedByCostLimiting;
        }
    }

    public static class PluginAgentSettings
    extends AgentSettings {
        public Boolean canBeBlockedByCostLimiting = true;

        public PluginAgentSettings() {
        }

        public PluginAgentSettings(PluginAgentSettings other) {
            super(other);
            this.canBeBlockedByCostLimiting = other.canBeBlockedByCostLimiting;
        }
    }

    @PyModel
    public static class ToolsUsingAgentSettings
    extends AgentSettings {
        public ToolsUsingAgentMode mode = ToolsUsingAgentMode.SIMPLE;
        public boolean debugMode = false;
        public boolean shortTermMemoryEnabled = false;
        public boolean newLineAfterBlockOutput = true;
        @Nullable
        public Integer shortTermMemoryHorizon;
        public List<UsedTool> tools = new ArrayList<UsedTool>();
        public String llmId;
        public String systemPromptAppend;
        public LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        public boolean allowAgentsAsLLM = false;
        public ImageSupportMode imageSupportMode = ImageSupportMode.AUTOMATIC;
        public List<BlocksGraphBlock> blocks = new ArrayList<BlocksGraphBlock>();
        public String startingBlockId;
        public NextTurnBehaviour nextTurnBehaviour = NextTurnBehaviour.STARTING_BLOCK;
        public CodeEnvSelection codeEnvSelection = CodeEnvSelection.builtInEnvSelection();
        public String nextTurnSmartModeLLMId;
        public String nextTurnSmartModeInstructionsAppend;
        public LLMClient.CompletionSettings nextTurnSmartModeCompletionSettings = new LLMClient.CompletionSettings();
        public String preChainHeadBlockId;
        public String postChainHeadBlockId;

        public ToolsUsingAgentSettings() {
        }

        public ToolsUsingAgentSettings(ToolsUsingAgentSettings other) {
            super(other);
            this.mode = other.mode;
            this.debugMode = other.debugMode;
            for (UsedTool otherTool : other.tools) {
                this.tools.add(new UsedTool(otherTool));
            }
            this.llmId = other.llmId;
            this.imageSupportMode = other.imageSupportMode;
            this.systemPromptAppend = other.systemPromptAppend;
            this.completionSettings = (LLMClient.CompletionSettings)JSON.deepCopy((Object)other.completionSettings);
            this.allowAgentsAsLLM = other.allowAgentsAsLLM;
            this.shortTermMemoryEnabled = other.shortTermMemoryEnabled;
            this.shortTermMemoryHorizon = other.shortTermMemoryHorizon;
            this.newLineAfterBlockOutput = other.newLineAfterBlockOutput;
            for (BlocksGraphBlock otherBlock : other.blocks) {
                this.blocks.add((BlocksGraphBlock)JSON.deepCopy((Object)otherBlock));
            }
            this.startingBlockId = other.startingBlockId;
            this.nextTurnBehaviour = other.nextTurnBehaviour;
            this.preChainHeadBlockId = other.preChainHeadBlockId;
            this.postChainHeadBlockId = other.postChainHeadBlockId;
            this.codeEnvSelection = other.codeEnvSelection != null ? new CodeEnvSelection(other.codeEnvSelection) : CodeEnvSelection.builtInEnvSelection();
            this.nextTurnSmartModeLLMId = other.nextTurnSmartModeLLMId;
            this.nextTurnSmartModeInstructionsAppend = other.nextTurnSmartModeInstructionsAppend;
            this.nextTurnSmartModeCompletionSettings = (LLMClient.CompletionSettings)JSON.deepCopy((Object)other.nextTurnSmartModeCompletionSettings);
        }

        public static enum ImageSupportMode {
            AUTOMATIC,
            ENABLED,
            DISABLED;

        }

        public static enum NextTurnBehaviour {
            LAST_BLOCK,
            STARTING_BLOCK,
            SMART;

        }
    }

    public static class AgentSettings {
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public int maxParallelRequestsPerProcess = 16;
        public ContainerExecSelection containerExecSelection = new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.NONE);
        public boolean singleInstance = false;
        @Nullable
        public Integer minimumRetentionTimeSeconds;

        public AgentSettings() {
        }

        public AgentSettings(AgentSettings other) {
            this.dkuProperties = (List)JSON.deepCopy(other.dkuProperties);
            this.maxParallelRequestsPerProcess = other.maxParallelRequestsPerProcess;
            this.containerExecSelection = new ContainerExecSelection(other.containerExecSelection);
            this.singleInstance = other.singleInstance;
            this.minimumRetentionTimeSeconds = other.minimumRetentionTimeSeconds;
        }
    }

    public static enum ToolsUsingAgentMode {
        SIMPLE,
        BLOCKS_GRAPH;

    }

    public static interface LLMBlock {
        public String getLlmId();

        public void setLlmId(String var1);
    }

    public static class ReflectionBlock
    extends BlocksGraphBlock
    implements LLMBlock {
        public static final String TYPE = "REFLECTION";
        public ReflectionMode mode = ReflectionMode.CRITIQUE_AND_IMPROVE;
        public String generatorBlockId;
        public String llmId;
        public String nextBlock;
        public boolean streamOutput = true;
        public BlocksGraphBlock.OutputMode outputMode = BlocksGraphBlock.OutputMode.ADD_TO_MESSAGES;
        public String outputStateKey;
        public String outputScratchpadKey;
        public String expectationsPrompt;
        public LLMClient.CompletionSettings critiqueCompletionSettings = new LLMClient.CompletionSettings();
        public int critiqueMaxIterations = 3;
        public boolean failOnMaxIterations = true;
        public String synthesizePrompt;
        public LLMClient.CompletionSettings synthesizeCompletionSettings = new LLMClient.CompletionSettings();
        public int synthesizeIterations = 3;
        public int maxThreads = 32;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public String getLlmId() {
            return this.llmId;
        }

        @Override
        public void setLlmId(String llmId) {
            this.llmId = llmId;
        }
    }

    public static enum ReflectionMode {
        CRITIQUE_AND_IMPROVE,
        CRITIQUE_OR_RETRY,
        SYNTHESIZE;

    }

    public static class CustomBlock
    extends BlocksGraphBlock {
        public static final String TYPE = "CUSTOM";
        public String componentId;
        public JsonObject config;
        public List<String> validNextBlocks = new ArrayList<String>();
        public String defaultNextBlock;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class PythonCodeBlock
    extends BlocksGraphBlock {
        public static final String TYPE = "PYTHON_CODE";
        public String code;
        public String functionName;
        public List<String> validNextBlocksFromCode = new ArrayList<String>();
        public String defaultNextBlock;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static enum CodeMode {
        PROCESS_STREAM,
        SIMPLE_FUNCTION;

    }

    public static class EditLastUserMessageBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "EDIT_LAST_USER_MESSAGE";
        public String expression;
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class GenerateArtifactBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "GENERATE_ARTIFACT";
        public DocumentTemplatingInput.TemplateType templateType = DocumentTemplatingInput.TemplateType.CEL_EXPANSION;
        public String template;
        public String managedFolderRef;
        public String templateFilename;
        public ArtifactOutputFormat outputFormat = ArtifactOutputFormat.TEXT;
        public String outputManagedFolderRef;
        public String outputFilename;
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static enum ArtifactOutputFormat {
        TEXT,
        MARKDOWN,
        DOCX,
        PDF;

    }

    public static class ContextCompressionBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock,
    LLMBlock {
        public static final String TYPE = "CONTEXT_COMPRESSION";
        public int activeBufferSize = 5;
        public int compressionTriggerChars = 1000;
        public boolean appliesToInitial = true;
        public boolean appliesToGenerated = false;
        public String llmId;
        public LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public String getLlmId() {
            return this.llmId;
        }

        @Override
        public void setLlmId(String llmId) {
            this.llmId = llmId;
        }
    }

    public static class EmitOutputBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "EMIT_OUTPUT";
        public TemplateType templateType = TemplateType.CEL_EXPANSION;
        public String template;
        public String nextBlock;
        public boolean addToMessages = true;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        public static enum TemplateType {
            CEL_EXPANSION,
            JINJA;

        }
    }

    public static class SetScratchpadEntriesBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "SET_SCRATCHPAD_ENTRIES";
        public List<SimpleKeyValue> entriesToSet = new ArrayList<SimpleKeyValue>();
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class SetStateEntriesBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "SET_STATE_ENTRIES";
        public List<SimpleKeyValue> entriesToSet = new ArrayList<SimpleKeyValue>();
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ForEachBlock
    extends BlocksGraphBlock {
        public static final String TYPE = "FOR_EACH";
        public String sourceExpression;
        public String blockIdToRepeat;
        public String forEachInputKey;
        public GeneratedOutputStorageLocation generatedOutputStorageLocation = GeneratedOutputStorageLocation.SCRATCHPAD;
        public String targetOutputKey;
        public List<GeneratedKey> generatedStateKeys = new ArrayList<GeneratedKey>();
        public List<GeneratedKey> generatedScratchpadKeys = new ArrayList<GeneratedKey>();
        public String nextBlock;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ParallelBlock
    extends BlocksGraphBlock {
        public static final String TYPE = "PARALLEL";
        public List<String> blockIds = new ArrayList<String>();
        public int maxThreads = 32;
        public GeneratedOutputStorageLocation generatedOutputStorageLocation = GeneratedOutputStorageLocation.SCRATCHPAD;
        public String targetOutputKey;
        public List<GeneratedKey> generatedStateKeys = new ArrayList<GeneratedKey>();
        public List<GeneratedKey> generatedScratchpadKeys = new ArrayList<GeneratedKey>();
        public String nextBlock;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static enum GeneratedOutputStorageLocation {
        SCRATCHPAD,
        STATE;

    }

    public static class GeneratedKey {
        public String key;
        public BlocksGraphExpression expression;
    }

    public static class RoutingBlock
    extends BlocksGraphBlock
    implements LLMBlock {
        public static final String TYPE = "ROUTING";
        public RoutingMode routingMode = RoutingMode.CLAUSES;
        public List<RoutingClauseBasedDecision> clausesBasedDecisions = new ArrayList<RoutingClauseBasedDecision>();
        public String defaultNextBlockIfNoClauseMatch;
        public String llmId;
        public String prompt;
        public List<SimpleKeyValue> resultDispatch = new ArrayList<SimpleKeyValue>();
        public String expression;
        public List<String> validNextBlocksFromExpression = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public String getLlmId() {
            return this.llmId;
        }

        @Override
        public void setLlmId(String llmId) {
            this.llmId = llmId;
        }

        public static enum RoutingMode {
            CLAUSES,
            LLM_DISPATCH,
            EXPRESSION_DISPATCH;

        }
    }

    public static class RoutingClauseBasedDecision {
        public RoutingConditionClause clause;
        public String nextBlock;
    }

    public static class LLMBasedDecisionRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "LLM_BASED";
        public boolean passConversationHistory;
        public String systemPromptBeforeHistory;
        public String systemPromptAfterHistory;
        public String additionalUserMessage;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class OrRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "OR";
        public List<RoutingConditionClause> clauses = new ArrayList<RoutingConditionClause>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class AndRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "AND";
        public List<RoutingConditionClause> clauses = new ArrayList<RoutingConditionClause>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ExpressionRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "EXPRESSION";
        public BlocksGraphExpression expression = new BlocksGraphExpression();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ToolsCalledInHistoryRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "TOOLS_CALLED";
        public List<BlockGraphTool> toolRefs;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ScratchpadHasKeysRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "SCRATCHPAD_HAS_KEYS";
        public List<String> scratchpadKeys = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class StateHasKeysRoutingConditionClause
    extends RoutingConditionClause {
        public static final String TYPE = "STATE_HAS_KEYS";
        public List<String> stateKeys = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    @PolyJSON(value={@Mapping(value=StateHasKeysRoutingConditionClause.class, type="STATE_HAS_KEYS"), @Mapping(value=ScratchpadHasKeysRoutingConditionClause.class, type="SCRATCHPAD_HAS_KEYS"), @Mapping(value=ToolsCalledInHistoryRoutingConditionClause.class, type="TOOLS_CALLED"), @Mapping(value=ExpressionRoutingConditionClause.class, type="EXPRESSION"), @Mapping(value=AndRoutingConditionClause.class, type="AND"), @Mapping(value=OrRoutingConditionClause.class, type="OR"), @Mapping(value=LLMBasedDecisionRoutingConditionClause.class, type="LLM_BASED")})
    @PyModel
    public static abstract class RoutingConditionClause {
        public abstract String getType();
    }

    public static class ManualToolCallBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock,
    ToolUsingBlock {
        public static final String TYPE = "MANUAL_TOOL_CALL";
        public ManualToolCall tool = new ManualToolCall();
        public BlocksGraphBlock.OutputMode outputMode = BlocksGraphBlock.OutputMode.ADD_TO_MESSAGES;
        public String outputStateKey;
        public String outputScratchpadKey;
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public List<? extends BlockGraphTool> getToolRefs() {
            return List.of(this.tool);
        }
    }

    public static class ManualToolCall
    extends BlockGraphTool {
        public List<SimpleKeyValue> setArgs = new ArrayList<SimpleKeyValue>();
    }

    public static class MandatoryToolCallBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock,
    LLMBlock,
    ToolUsingBlock {
        public static final String TYPE = "MANDATORY_TOOL_CALL";
        public BlockGraphReactTool tool;
        public String llmId;
        public String systemPrompt;
        public LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        public boolean stateAware;
        public String nextBlock;
        public BlocksGraphBlock.OutputMode outputMode = BlocksGraphBlock.OutputMode.ADD_TO_MESSAGES;
        public String outputStateKey;
        public String outputScratchpadKey;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public String getLlmId() {
            return this.llmId;
        }

        @Override
        public void setLlmId(String llmId) {
            this.llmId = llmId;
        }

        @Override
        public List<? extends BlockGraphTool> getToolRefs() {
            return List.of(this.tool);
        }
    }

    public static class DelegateToOtherAgentBlock
    extends BlocksGraphBlock
    implements BasicLinearBlock {
        public static final String TYPE = "DELEGATE_TO_OTHER_AGENT";
        public String agentRef;
        public boolean streamOutput;
        public BlocksGraphBlock.OutputMode outputMode = BlocksGraphBlock.OutputMode.ADD_TO_MESSAGES;
        public String outputStateKey;
        public String outputScratchpadKey;
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class LLMRequestBlock
    extends LLMBaseBlock
    implements BasicLinearBlock {
        public static final String TYPE = "LLM_REQUEST";
        public String nextBlock;

        @Override
        public String getSingleNextBlock() {
            return this.nextBlock;
        }

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class StandardReactBlock
    extends LLMBaseBlock
    implements ToolUsingBlock {
        public static final String TYPE = "STANDARD_REACT";
        public List<BlockGraphReactTool> tools = new ArrayList<BlockGraphReactTool>();
        public int maxLoopIterations = 25;
        public int maxParallelToolExecutions = 2;
        public boolean stateAware;
        public boolean scratchpadAware;
        public List<ReactBlockExitCondition> exitConditions = new ArrayList<ReactBlockExitCondition>();
        public String defaultNextBlock;

        @Override
        public String getType() {
            return TYPE;
        }

        @Override
        public List<? extends BlockGraphTool> getToolRefs() {
            return this.tools;
        }
    }

    public static class ToolsCalledExitCondition
    extends ReactBlockExitCondition {
        public static final String TYPE = "TOOLS_CALLED";
        public List<BlockGraphTool> toolRefs;

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ExpressionExitCondition
    extends ReactBlockExitCondition {
        public static final String TYPE = "EXPRESSION";
        public BlocksGraphExpression expression = new BlocksGraphExpression();
        public List<String> validNextBlocks = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class ScratchpadHasKeysExitCondition
    extends ReactBlockExitCondition {
        public static final String TYPE = "SCRATCHPAD_HAS_KEYS";
        public List<String> scratchpadKeys = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    public static class StateHasKeysExitCondition
    extends ReactBlockExitCondition {
        public static final String TYPE = "STATE_HAS_KEYS";
        public List<String> stateKeys = new ArrayList<String>();

        @Override
        public String getType() {
            return TYPE;
        }
    }

    @PolyJSON(value={@Mapping(value=StateHasKeysExitCondition.class, type="STATE_HAS_KEYS"), @Mapping(value=ScratchpadHasKeysExitCondition.class, type="SCRATCHPAD_HAS_KEYS"), @Mapping(value=ToolsCalledExitCondition.class, type="TOOLS_CALLED"), @Mapping(value=ExpressionExitCondition.class, type="EXPRESSION")})
    public static abstract class ReactBlockExitCondition {
        public String nextBlock;

        public abstract String getType();
    }

    public static class BlockGraphReactTool
    extends BlockGraphTool {
        public String agentId;
        public String systemPromptPrepend;
        public Boolean forwardContext = true;
        public Boolean returnArtifacts = true;
        public Boolean returnSources = true;
        public String additionalDescription;
        public Boolean enableSetArgs = false;
        public List<SimpleKeyValue> setArgs = new ArrayList<SimpleKeyValue>();
        public OutputHandling outputHandling = OutputHandling.ADD_TO_MESSAGES;
        public boolean treatAsJSON;
        public List<SimpleKeyValue> outputToStoreInMessages;
        public List<SimpleKeyValue> outputToStoreInState;
        public List<SimpleKeyValue> outputToStoreInScratchpad;

        public static enum OutputHandling {
            ADD_TO_MESSAGES,
            POSTPROCESS_OUTPUT;

        }
    }

    public static class BlockGraphTool {
        public Type type = Type.EXPLICIT_TOOL;
        public String toolRef;
        public String subtoolName;

        public static enum Type {
            EXPLICIT_TOOL,
            SUB_AGENT;

        }
    }

    private static abstract class LLMBaseBlock
    extends BlocksGraphBlock
    implements LLMBlock {
        public String llmId;
        public boolean passConversationHistory;
        public String systemPromptBeforeHistory;
        public String systemPromptAfterHistory;
        public String additionalUserMessage;
        public LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
        public boolean streamOutput;
        public BlocksGraphBlock.OutputMode outputMode = BlocksGraphBlock.OutputMode.ADD_TO_MESSAGES;
        public String outputStateKey;
        public String outputScratchpadKey;

        private LLMBaseBlock() {
        }

        @Override
        public String getLlmId() {
            return this.llmId;
        }

        @Override
        public void setLlmId(String llmId) {
            this.llmId = llmId;
        }
    }

    public static class BlocksGraphExpression {
        public ExpressionLanguage language = ExpressionLanguage.CEL;
        public String expression;

        public static enum ExpressionLanguage {
            CEL,
            DSS_FORMULA,
            JQ;

        }
    }

    @PolyJSON(value={@Mapping(value=StandardReactBlock.class, type="STANDARD_REACT"), @Mapping(value=LLMRequestBlock.class, type="LLM_REQUEST"), @Mapping(value=DelegateToOtherAgentBlock.class, type="DELEGATE_TO_OTHER_AGENT"), @Mapping(value=MandatoryToolCallBlock.class, type="MANDATORY_TOOL_CALL"), @Mapping(value=ManualToolCallBlock.class, type="MANUAL_TOOL_CALL"), @Mapping(value=RoutingBlock.class, type="ROUTING"), @Mapping(value=ForEachBlock.class, type="FOR_EACH"), @Mapping(value=ParallelBlock.class, type="PARALLEL"), @Mapping(value=SetStateEntriesBlock.class, type="SET_STATE_ENTRIES"), @Mapping(value=SetScratchpadEntriesBlock.class, type="SET_SCRATCHPAD_ENTRIES"), @Mapping(value=EmitOutputBlock.class, type="EMIT_OUTPUT"), @Mapping(value=GenerateArtifactBlock.class, type="GENERATE_ARTIFACT"), @Mapping(value=EditLastUserMessageBlock.class, type="EDIT_LAST_USER_MESSAGE"), @Mapping(value=ContextCompressionBlock.class, type="CONTEXT_COMPRESSION"), @Mapping(value=PythonCodeBlock.class, type="PYTHON_CODE"), @Mapping(value=ReflectionBlock.class, type="REFLECTION"), @Mapping(value=CustomBlock.class, type="CUSTOM")})
    public static abstract class BlocksGraphBlock {
        public String id;
        String description;

        public abstract String getType();

        public static enum OutputMode {
            NONE,
            ADD_TO_MESSAGES,
            SAVE_TO_STATE,
            SAVE_TO_SCRATCHPAD;

        }
    }

    public static interface ToolUsingBlock {
        public List<? extends BlockGraphTool> getToolRefs();
    }

    public static interface BasicLinearBlock {
        public String getSingleNextBlock();
    }

    public static class UsedTool {
        public String toolRef;
        public String additionalDescription;
        public boolean disabled = false;

        public UsedTool() {
        }

        public UsedTool(UsedTool other) {
            this.toolRef = other.toolRef;
            this.additionalDescription = other.additionalDescription;
            this.disabled = other.disabled;
        }
    }

    public static class AgentDependency {
        public ITaggingService.TaggableType type;
        public String ref;

        public AgentDependency() {
        }

        public AgentDependency(ITaggingService.TaggableType type, String ref) {
            this.type = type;
            this.ref = ref;
        }

        public AgentDependency(AgentDependency other) {
            this.type = other.type;
            this.ref = other.ref;
        }
    }

    public static class SavedModelListItem
    extends TaggableObjectsService.TaggableListItem {
        public final MLTask.MLTaskType type;
        public final MLTask.BackendType backendType;
        @Nullable
        public PredictionMLTask.PredictionType predictionType;
        public SavedModelType savedModelType;
        public String pluginAgentType;
        @Nullable
        public ProxyModelConfiguration proxyModelConfiguration;
        public long versionsCount = 0L;

        public SavedModelListItem(SavedModel model) {
            super(model);
            this.type = model.getType();
            this.backendType = model.miniTask != null ? model.miniTask.backendType : null;
            this.savedModelType = model.savedModelType;
            if (this.savedModelType == SavedModelType.PLUGIN_AGENT && !model.inlineVersions.isEmpty()) {
                this.pluginAgentType = model.inlineVersions.get((int)0).pluginAgentType;
            }
            this.proxyModelConfiguration = model.proxyModelConfiguration;
            if (this.type == MLTask.MLTaskType.PREDICTION) {
                this.predictionType = ((PredictionMLTask)model.miniTask).predictionType;
            }
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.SAVED_MODEL;
        }
    }
}

