/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.UIDataCollection;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import java.util.Objects;
import javax.annotation.Nullable;

public class DataCollectionDataset
extends AbstractDataCollectionItem {
    public AnyLoc reference;
    public static final String TYPE = "dataset";
    @Nullable
    public Long dataCollectionAddedOn;

    public DataCollectionDataset() {
    }

    public DataCollectionDataset(AnyLoc reference, long addedOn) {
        this.reference = reference;
        this.dataCollectionAddedOn = addedOn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataCollectionDataset)) {
            return false;
        }
        DataCollectionDataset o = (DataCollectionDataset)obj;
        return this.reference.equals(o.reference);
    }

    public int hashCode() {
        return Objects.hash(this.reference, TYPE);
    }

    @Override
    public UIDataCollection.AbstractDataCollectionItemInfo summarize(AbstractDataCollectionItem.SummarizeContext context) {
        String projectKey = this.reference.getProjectKey();
        SerializedProject project = context.projects.get(projectKey);
        SerializedDataset dataset = context.datasets.get(this.reference);
        ProjectsService.ObjectVisibility visibility = context.datasetVisibility.get(this.reference);
        if (project == null || dataset == null) {
            return null;
        }
        AnyLoc loc = new AnyLoc(projectKey, dataset.name);
        return switch (visibility) {
            default -> throw new IncompatibleClassChangeError();
            case ProjectsService.ObjectVisibility.READ -> {
                long lastBuiltOn = context.lastBuildTimes.getOrDefault(this.reference.getFullName(), -1L);
                yield new UIDataCollection.DatasetInfo(dataset, project, lastBuiltOn, context.datasetQualityStatuses.get(loc), context.emptyDescriptionColumnsCount.get(loc), context.projectCanRequestShare.get(projectKey), context.projectCanManageShare.get(projectKey), context.datasetIsQuickShareable.get(loc));
            }
            case ProjectsService.ObjectVisibility.DISCOVER -> new UIDataCollection.DiscoverableDatasetInfo(dataset, project, context.datasetQualityStatuses.get(loc), context.emptyDescriptionColumnsCount.get(loc), context.projectCanRequestShare.get(projectKey), context.projectCanManageShare.get(projectKey), context.datasetIsQuickShareable.get(loc));
            case ProjectsService.ObjectVisibility.NONE -> null;
        };
    }

    @Override
    public AbstractDataCollectionItemRef.DatasetRef getRef() {
        return new AbstractDataCollectionItemRef.DatasetRef(this.reference.getProjectKey(), this.reference.getId());
    }
}

