/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedRecipeRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPythonRecipeRunner
extends AbstractCodeBasedRecipeRunner {
    private final CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
    private static final Logger logger = Logger.getLogger((String)"dku.flow.abstract.python");

    public AbstractPythonRecipeRunner(JobActivity activity) {
        super(activity);
    }

    protected List<String> getPythonCmd(String projectKey, String envName, List<String> args) throws IOException {
        return this.codeEnvResolutionService.getPythonCmd(envName, projectKey, args);
    }

    private void warnDeprecatedPythonInterpreterVersion(String envName) throws IOException {
        this.warnDeprecatedPythonInterpreterVersion(new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, envName));
    }

    protected void executeScript(File recipeTmpDir, File targetLogFile, String pyScriptData, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException, Exception {
        this.warnDeprecatedPythonInterpreterVersion(envName);
        try (WorkerPool workerPool = this.createWorkerPool(envName);){
            File tmpScriptData = new File(recipeTmpDir, "script.py");
            logger.info((Object)("Dumping Python script to " + String.valueOf(tmpScriptData)));
            DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)pyScriptData);
            String wrapperContent = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/dataflow/exec/python-exec-wrapper.py");
            File wrapperFile = new File(recipeTmpDir, "python-exec-wrapper.py");
            DKUFileUtils.writeFileUTF8((File)wrapperFile, (String)wrapperContent);
            this.writeRemoteRunEnvDefForLocalExecution(recipeTmpDir, envName);
            ArrayList args = Lists.newArrayList((Object[])new String[]{wrapperFile.getAbsolutePath(), tmpScriptData.getAbsolutePath()});
            List<String> command = this.getPythonCmd(this.projectKey, envName, args);
            logger.info((Object)("Execute activity command: " + JSON.log(command)));
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(recipeTmpDir);
            builder.command(command);
            builder.environment().put("REMOTE_WORKER_POOL_ID", workerPool.getId());
            logger.info((Object)("Attached worker pool to " + this.getClass().getName() + " recipe runner: " + workerPool.getId()));
            builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
            this.execute(builder, targetLogFile, null, "Python", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false);
        }
    }

    public void enrichModuleProcess(ProcessBuilder builder) {
    }

    protected void executeModule(String envName, File tmpDirectory, String module, String ... params) throws Exception {
        this.executeModule(envName, tmpDirectory, module, true, params);
    }

    protected void executeModule(String envName, File tmpDirectory, String module, boolean impersonateModule, String ... params) throws Exception {
        this.executeModule(envName, tmpDirectory, module, impersonateModule, (Map<String, String>)null, params);
    }

    protected void executeModule(String envName, File tmpDirectory, String module, boolean impersonateModule, Map<String, String> envVariables, String ... params) throws Exception {
        this.warnDeprecatedPythonInterpreterVersion(envName);
        try (WorkerPool workerPool = this.createWorkerPool(envName);){
            ArrayList args = Lists.newArrayList((Object[])new String[]{"-m", module});
            for (String arg : params) {
                args.add(arg);
            }
            this.writeRemoteRunEnvDefForLocalExecution(tmpDirectory, envName);
            List<String> command = this.getPythonCmd(this.projectKey, envName, args);
            logger.info((Object)("Execute activity command: " + JSON.log(command)));
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory(tmpDirectory);
            builder.command(command);
            builder.environment().put("REMOTE_WORKER_POOL_ID", workerPool.getId());
            if (envVariables != null) {
                builder.environment().putAll(envVariables);
            }
            logger.info((Object)("Attached worker pool to " + this.getClass().getName() + " recipe runner: " + workerPool.getId()));
            builder.environment().putAll(this.codeEnvResolutionService.getEnvironmentVariablesForPythonCmd(envName, this.projectKey));
            this.enrichModuleProcess(builder);
            File logFile = new File(tmpDirectory, "process-out.log");
            FileUtils.touch((File)logFile);
            String relativePath = FlowJobUtils.pathRelativeToActivity(logFile);
            JobContext.getCurrentActivityObj().getStatus().addStatusOutput("Python execution output", relativePath, "text/plain");
            this.execute(builder, logFile, null, "Python", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, !impersonateModule);
        }
    }
}

