/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FuzzyJoinRecipeHelper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    Map<String, Dataset> datasetsMap;
    static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.fuzzyjoin.helper");

    public FuzzyJoinRecipeHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void initInputDatasets(JobActivity activity, FuzzyJoinRecipePayloadParams params) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        this.datasetsMap = new HashMap<String, Dataset>();
        for (JoinInputDescBase vi : params.virtualInputs) {
            Dataset source = ServiceUtils.getDataset(activity, this.datasetsDAO, vi.name);
            logger.trace(() -> "Register dataset " + vi.name + " : " + JSON.log((Object)source));
            this.datasetsMap.put(vi.name, source);
        }
        params.resolveSelectedColumns(this.datasetsMap, false);
    }

    public FuzzyJoinRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        FuzzyJoinRecipePayloadParams params = (FuzzyJoinRecipePayloadParams)JSON.parse((String)payload, FuzzyJoinRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.resolveDatasetNames(params, sr);
        return params;
    }

    public void initAliases(FuzzyJoinRecipePayloadParams params) {
        this.unicizeTableAliases(params);
        this.computeColumnAliases(params);
    }

    private void resolveDatasetNames(FuzzyJoinRecipePayloadParams params, SerializedRecipe sr) {
        List<String> datasets = this.getDatasets(sr);
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            JoinInputDescBase vi = (JoinInputDescBase)params.virtualInputs.get(i);
            if (vi.index < 0 || vi.index >= datasets.size()) {
                throw ErrorContext.iae((String)("Recipes inputs are incorrect. Input index: " + vi.index));
            }
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(datasets.get(vi.index));
            vi.name = loc.getFullName();
            vi.alias = loc.getName();
        }
    }

    private List<String> getDatasets(SerializedRecipe sr) {
        ArrayList<String> datasets = new ArrayList<String>(sr.getFlatInputs().size());
        for (SerializedRecipe.RecipeInput in : sr.getFlatInputs()) {
            AnyLoc loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasets.add(loc.getFullName());
        }
        return datasets;
    }

    private void unicizeTableAliases(FuzzyJoinRecipePayloadParams params) {
        HashSet<String> usedNames = new HashSet<String>(params.virtualInputs.size());
        for (JoinInputDescBase inputDesc : params.virtualInputs) {
            String tableId = StringUtils.isNotBlank((String)inputDesc.alias) ? inputDesc.alias : inputDesc.name;
            int n = 2;
            Object newTableId = tableId;
            while (usedNames.contains(((String)newTableId).toLowerCase())) {
                newTableId = tableId + "_" + n++;
            }
            inputDesc.alias = newTableId;
            usedNames.add(((String)newTableId).toLowerCase());
        }
    }

    private void computeColumnAliases(FuzzyJoinRecipePayloadParams params) {
        if (params.getSelectedColumns() != null) {
            for (ColumnDesc cd : params.getSelectedColumns()) {
                if (!StringUtils.isBlank((String)cd.alias)) continue;
                cd.alias = cd.name;
                JoinInputDescBase id = (JoinInputDescBase)params.virtualInputs.get(cd.table);
                if (!StringUtils.isNotBlank((String)id.prefix)) continue;
                cd.alias = id.prefix + "_" + cd.alias;
            }
        }
    }
}

