/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.exceptions.DSSIllegalArgumentException;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKULogger;
import java.awt.geom.Point2D;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import si.uom.SI;
import systems.uom.common.USCustomary;

public class GeoUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.utils.geo");
    private static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private static final GeometryMeaning GEOMETRY_MEANING = new GeometryMeaning();
    private static final GeoPoint GEO_POINT = new GeoPoint();
    private static final GeometryFactory FACTORY_4326 = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;

    public static Geometry geometryFromLiteralExpression(Expression expression1, Expression expression2) {
        if (expression1 instanceof Literal) {
            return (Geometry)((Literal)expression1).getValue();
        }
        return (Geometry)((Literal)expression2).getValue();
    }

    public static MinMaxDegrees minMaxDegrees(Envelope env, Double meters) {
        Point point = geometryFactory.createPoint(new Coordinate(env.getMaxX(), env.getMaxY()));
        try {
            MinMaxDegrees minMaxDegrees = GeoUtils.minMaxDegrees(point, meters);
            List<MinMaxDegrees> distances = Arrays.asList(minMaxDegrees, GeoUtils.minMaxDegrees(geometryFactory.createPoint(new Coordinate(env.getMaxX(), env.getMinY())), meters), GeoUtils.minMaxDegrees(geometryFactory.createPoint(new Coordinate(env.getMinX(), env.getMinY())), meters), GeoUtils.minMaxDegrees(geometryFactory.createPoint(new Coordinate(env.getMinX(), env.getMaxY())), meters));
            return new MinMaxDegrees(distances.stream().min(Comparator.comparingDouble((ToDoubleFunction<MinMaxDegrees>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$minMaxDegrees$0(com.dataiku.dip.dataflow.exec.geojoin.GeoUtils$MinMaxDegrees ), (Lcom/dataiku/dip/dataflow/exec/geojoin/GeoUtils$MinMaxDegrees;)D)())).get().min, distances.stream().max(Comparator.comparingDouble((ToDoubleFunction<MinMaxDegrees>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, lambda$minMaxDegrees$1(com.dataiku.dip.dataflow.exec.geojoin.GeoUtils$MinMaxDegrees ), (Lcom/dataiku/dip/dataflow/exec/geojoin/GeoUtils$MinMaxDegrees;)D)())).get().max);
        }
        catch (IllegalArgumentException e) {
            logger.warnV((Throwable)e, "Failed to calculate min/max degrees for envelope: %s, distance %s", new Object[]{env.toString(), meters});
            return MinMaxDegrees.UNDEFINED;
        }
    }

    private static MinMaxDegrees minMaxDegrees(Point point, Double meters) {
        GeodeticCalculator calc = new GeodeticCalculator((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        calc.setStartingGeographicPoint(point.getX(), point.getY());
        DegreesCalculator degreesCalc = new DegreesCalculator(point, meters, calc);
        double east = 360.0 * meters / 6378.137 / 1000.0;
        double north = Math.min(degreesCalc.inDirection(0.0), degreesCalc.inDirection(180.0));
        return east > north ? new MinMaxDegrees(north, east) : new MinMaxDegrees(east, north);
    }

    public static double convertToMeters(double distance, GeoJoinRecipePayloadParams.DistanceUnit unit) {
        switch (unit) {
            case METER: {
                return distance;
            }
            case KILOMETER: {
                return MetricPrefix.KILO((Unit)SI.METRE).getConverterTo(SI.METRE).convert(distance);
            }
            case MILE: {
                return USCustomary.MILE.getConverterTo(SI.METRE).convert(distance);
            }
            case YARD: {
                return USCustomary.YARD.getConverterTo(SI.METRE).convert(distance);
            }
            case FOOT: {
                return USCustomary.FOOT.getConverterTo(SI.METRE).convert(distance);
            }
            case NAUTICAL_MILE: {
                return USCustomary.NAUTICAL_MILE.getConverterTo(SI.METRE).convert(distance);
            }
        }
        throw new IllegalArgumentException("Unsupported distance unit");
    }

    public static Geometry fromLngLat(double lng, double lat) {
        return FACTORY_4326.createPoint(new Coordinate(lng, lat));
    }

    public static Geometry convertSupportedFormatsToGeometry(String geometry) throws DSSIllegalArgumentException {
        try {
            Geometry translatedGeom = GEO_POINT.toGeometry(geometry);
            if (translatedGeom == null) {
                translatedGeom = GEOMETRY_MEANING.toGeometry(geometry);
            }
            if (translatedGeom != null) {
                return translatedGeom;
            }
        }
        catch (Exception e) {
            throw new DSSIllegalArgumentException("Failed to parse geometry as a supported format: " + e.getMessage(), (Throwable)e);
        }
        throw new DSSIllegalArgumentException("Failed to parse geometry as a supported format");
    }

    private static /* synthetic */ double lambda$minMaxDegrees$1(MinMaxDegrees o) {
        return o.max;
    }

    private static /* synthetic */ double lambda$minMaxDegrees$0(MinMaxDegrees o) {
        return o.min;
    }

    public static class MinMaxDegrees {
        final double min;
        final double max;
        public static final MinMaxDegrees UNDEFINED = new MinMaxDegrees(Double.MAX_VALUE, Double.MIN_VALUE);

        public MinMaxDegrees(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }

    public static class DegreesCalculator {
        private final Point point;
        private final Double meters;
        private final GeodeticCalculator calc;

        public DegreesCalculator(Point point, Double meters, GeodeticCalculator calc) {
            this.point = point;
            this.meters = meters;
            this.calc = calc;
        }

        public double inDirection(double azimuth) {
            this.calc.setDirection(azimuth, this.meters.doubleValue());
            Point2D dest2D = this.calc.getDestinationGeographicPoint();
            double dist = this.point.distance((Geometry)geometryFactory.createPoint(new Coordinate(dest2D.getX(), dest2D.getY())));
            return Math.min(dist, 360.0 - dist);
        }
    }
}

