/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.pivot.ModalitySlugifier;
import com.dataiku.dip.dataflow.exec.pivot.PivotElement;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PivotedModality {
    private static final Boolean booleanMeaning = new Boolean();
    private static final LongMeaning longMeaning = new LongMeaning();
    private static final DoubleMeaning doubleMeaning = new DoubleMeaning();
    public List<String> keyValues = Lists.newArrayList();
    public String name;
    public List<PivotedColumn> valueColumns = Lists.newArrayList();
    public String globalCountColumn;

    public static PivotedModality fromModalities(Map<String, String> keyValues, PivotElement pivotElement, ModalitySlugifier modalitySlugifier) {
        ArrayList keyValuesList = Lists.newArrayList();
        for (String keyColumn : pivotElement.keyColumns) {
            keyValuesList.add(keyValues.get(keyColumn));
        }
        return PivotedModality.fromModalities(keyValuesList, pivotElement, modalitySlugifier);
    }

    public static PivotedModality fromModalities(List<String> keyValues, PivotElement pivotElement, ModalitySlugifier modalitySlugifier) {
        PivotedModality ret = new PivotedModality();
        ret.keyValues.addAll(keyValues);
        ret.name = modalitySlugifier.slugify(PivotedModality.getModalityPrefix(pivotElement.keyColumns, ret.keyValues));
        HashSet columnNames = Sets.newHashSet();
        for (GroupingRecipePayloadParams.GroupingValue valueColumn : pivotElement.valueColumns) {
            columnNames.add(valueColumn.column);
        }
        for (String columnName : columnNames) {
            ret.valueColumns.add(new PivotedColumn(columnName, ret.name + "_" + columnName));
        }
        ret.globalCountColumn = pivotElement.globalCount ? ret.name : null;
        return ret;
    }

    private static String getModalityPrefix(List<String> keyColumns, List<String> keyValues) {
        ArrayList modalityChunks = Lists.newArrayList();
        for (int i = 0; i < keyColumns.size(); ++i) {
            String keyValue = keyValues.get(i);
            if (keyValue == null) {
                modalityChunks.add("null_" + keyColumns.get(i));
                continue;
            }
            if (keyValue.isEmpty()) {
                modalityChunks.add("empty_" + keyColumns.get(i));
                continue;
            }
            modalityChunks.add(keyValue);
        }
        return Joiner.on((String)"_").join((Iterable)modalityChunks);
    }

    public PivotedColumn getPivotedColumn(String column) {
        for (PivotedColumn valueColumn : this.valueColumns) {
            if (!column.equals(valueColumn.source)) continue;
            return valueColumn;
        }
        throw new IllegalArgumentException("Cannot find pivoted name for column " + column);
    }

    public String asExpression(List<String> keyColumns, Schema schema) {
        ArrayList tests = Lists.newArrayList();
        for (int i = 0; i < keyColumns.size(); ++i) {
            String key = keyColumns.get(i);
            String value = this.keyValues.get(i);
            Type type = schema.getColumn(key).getType();
            if (value == null) {
                tests.add("isNull(strval(" + FilterDescUtils.getGrelQuotedString(key) + "))");
                continue;
            }
            String nullityCheck = "not(isNull(strval(" + FilterDescUtils.getGrelQuotedString(key) + ")))";
            if (type == Type.BOOLEAN) {
                if (booleanMeaning.parse(value)) {
                    tests.add(nullityCheck + " && isTrue(strval(" + FilterDescUtils.getGrelQuotedString(key) + "))");
                    continue;
                }
                tests.add(nullityCheck + " && isFalse(strval(" + FilterDescUtils.getGrelQuotedString(key) + "))");
                continue;
            }
            if (type.isNumeric()) {
                if (type.isInteger()) {
                    tests.add(nullityCheck + " && numval(" + FilterDescUtils.getGrelQuotedString(key) + ") == " + longMeaning.longValue(value));
                    continue;
                }
                tests.add(nullityCheck + " && numval(" + FilterDescUtils.getGrelQuotedString(key) + ") == '" + doubleMeaning.doubleValue(value) + "'.toNumber()");
                continue;
            }
            tests.add(nullityCheck + " && strval(" + FilterDescUtils.getGrelQuotedString(key) + ") == " + FilterDescUtils.getGrelQuotedString(value));
        }
        return "(" + Joiner.on((String)") && (").join((Iterable)tests) + ")";
    }

    public static class PivotedColumn {
        public final String source;
        public final String pivoted;

        public PivotedColumn(String source, String pivoted) {
            this.source = source;
            this.pivoted = pivoted;
        }
    }
}

