/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.GCSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.bigquery.BigQueryClient;
import com.dataiku.dip.sql.bigquery.BigQueryException;
import com.dataiku.dip.sql.bigquery.BigQuerySchemaHandler;
import com.dataiku.dip.sql.bigquery.CreateTemporaryTableInfo;
import com.dataiku.dip.sql.bigquery.ExtractAvroToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ExtractCsvToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ExtractJsonToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ExtractParquetToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.ExtractToCloudStorageOptions;
import com.dataiku.dip.sql.bigquery.TableResource;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class BigQueryToGCS
extends SISORecipeExecutor {
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final int PARTITION_TEMPORARY_TABLE_TTL_HOURS = 48;
    private static final String GCS_FILENAME = "out-*";
    static final String CSV_COMPRESS_GZIP_VALUE = "gz";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.bigquerytogcs");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status, SerializedRecipe.RecipeOutput recipeOutput) {
        SISORecipeExecutor.CompatibilityCheck compatibilityCheck = BigQueryToGCS.isCompatible(inputDS, outputDS, recipeOutput);
        if (compatibilityCheck.isOk()) {
            status.isSelectable = true;
        } else {
            status.markAsNonSelectable(compatibilityCheck.errorMessage, RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    @Override
    public void run() throws Exception {
        AbstractSQLDatasetHandler.AbstractSQLConfig inputConfig = this.inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(this.inputDS.getProjectKey());
        BigQueryClient.TableRef inputTable = new BigQueryClient.TableRef(inputConfig.catalog, inputConfig.schema, inputConfig.table);
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             GCSDatasetHandler gcsdh = (GCSDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            BigQuerySQLDialect dialect = (BigQuerySQLDialect)connData.getDialect();
            String destinationUri = this.buildDestinationUri(gcsdh);
            SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();
            try {
                if (FastpathUtils.hasInputPartitions(this.inputPartitions)) {
                    this.extractPartitionedData(this.authCtx, connData, conn, inputTable, destinationUri, dialect);
                } else {
                    this.extractNonPartitionedData(connData, conn, inputTable, destinationUri, dialect);
                }
                conn.close();
            }
            catch (Exception e) {
                logger.error((Object)"BigQuery extract failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(conn);
                throw e;
            }
        }
    }

    private void extractNonPartitionedData(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, BigQueryClient.TableRef inputTable, String destinationUri, BigQuerySQLDialect dialect) throws Exception {
        BigQueryClient restClient = ((SQLConnectionProvider.BigQuerySQLConnectionData)connData).getRestClient(this.authCtx);
        boolean outputIsCsv = "csv".equals(this.outputDS.getFormatType());
        if (this.needsAdjustment(this.inputDS, outputIsCsv, dialect)) {
            this.createAndExtractTemporaryData(restClient, conn, inputTable, destinationUri, false, dialect);
        } else {
            this.performExtractionJob(conn, dialect, restClient, inputTable, destinationUri);
        }
    }

    private void extractPartitionedData(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, BigQueryClient.TableRef inputTable, String destinationUri, BigQuerySQLDialect dialect) throws Exception {
        BigQueryClient restClient = ((SQLConnectionProvider.BigQuerySQLConnectionData)connData).getRestClient(authCtx);
        this.createAndExtractTemporaryData(restClient, conn, inputTable, destinationUri, true, dialect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndExtractTemporaryData(BigQueryClient restClient, SQLConnectionProvider.SQLConnectionWrapper conn, BigQueryClient.TableRef inputTable, String destinationUri, boolean isPartitionTable, BigQuerySQLDialect dialect) throws Exception {
        Schema temporaryTableSchema = FastpathUtils.getTemporaryTableSchemaForCloudSync(this.inputDS, this.outputDS);
        String temporaryTableId = this.createTemporaryTable(restClient, inputTable.getDatasetRef(), temporaryTableSchema);
        BigQueryClient.TableRef temporaryTable = new BigQueryClient.TableRef(inputTable.getDatasetRef(), temporaryTableId);
        try {
            this.fillTemporaryTable(conn, dialect, inputTable, temporaryTable, temporaryTableSchema, isPartitionTable);
            this.performExtractionJob(conn, dialect, restClient, temporaryTable, destinationUri);
        }
        finally {
            this.tryDeletingTemporaryTable(restClient, temporaryTable);
        }
    }

    private String createTemporaryTable(BigQueryClient restClient, BigQueryClient.DatasetRef outputDataset, Schema temporaryTableSchema) throws IOException {
        logger.info((Object)"creating temporary BigQuery table for partition content preparation");
        CreateTemporaryTableInfo temporaryTableInfo = new CreateTemporaryTableInfo();
        boolean outputIsCsv = "csv".equals(this.outputDS.getFormatType());
        boolean temporalAsString = outputIsCsv || this.outputDS.getDkuPropertiesAsParams().getBoolParam("bigquery.unload.temporalAsString", false);
        temporaryTableInfo.schema = BigQuerySchemaHandler.createBigQuerySchema(temporaryTableSchema, temporalAsString, outputIsCsv);
        temporaryTableInfo.expirationTime = DateTime.now().plusHours(48).getMillis();
        TableResource temporaryTable = restClient.createTemporaryTable(outputDataset, temporaryTableInfo);
        return temporaryTable.tableReference.tableId;
    }

    private void fillTemporaryTable(SQLConnectionProvider.SQLConnectionWrapper conn, BigQuerySQLDialect dialect, BigQueryClient.TableRef inputTable, BigQueryClient.TableRef temporaryTable, Schema temporaryTableSchema, boolean isPartitionTable) throws SQLException {
        logger.info((Object)"filling temporary BigQuery table from INSERT SELECT");
        String sql = this.createInsertSelectSqlRequest(dialect, inputTable, temporaryTable, temporaryTableSchema, isPartitionTable);
        SQLUtils.safeExec(conn, sql, true);
    }

    private String createInsertSelectSqlRequest(BigQuerySQLDialect dialect, BigQueryClient.TableRef inputTable, BigQueryClient.TableRef outputTable, Schema temporaryTableSchema, boolean isPartitionTable) {
        StringBuilder request = new StringBuilder();
        request.append("INSERT ").append(dialect.getQuotedTableFullName(outputTable));
        request.append(" (").append(Joiner.on((String)",").join(BigQueryToGCS.getColumnNames(temporaryTableSchema, dialect))).append(")");
        request.append("\n");
        request.append("SELECT ").append(Joiner.on((String)",").join(BigQueryToGCS.getAdjustedColumns(this.outputDS, this.inputDS, temporaryTableSchema, dialect)));
        request.append("\n");
        request.append("FROM ").append(dialect.getQuotedTableFullName(inputTable));
        if (isPartitionTable) {
            request.append("\n");
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.inputDS.getPartitioningSchema(), this.inputDS, (List<Partition>)this.inputPartitions, (SQLDialect)dialect);
            request.append("WHERE ").append(partitionFilterExpression.toSQL(dialect));
        }
        return request.toString();
    }

    @VisibleForTesting
    boolean needsAdjustment(Dataset dataset, boolean outputIsCsv, BigQuerySQLDialect dialect) {
        return dataset.getSchema().columns.stream().anyMatch(schemaColumn -> schemaColumn.getType().isTemporal() || outputIsCsv && (schemaColumn.getType() == Type.OBJECT || schemaColumn.getType() == Type.ARRAY) || dialect.needCast((SchemaColumn)schemaColumn, dataset.isManaged()));
    }

    private void performExtractionJob(SQLConnectionProvider.SQLConnectionWrapper conn, BigQuerySQLDialect dialect, BigQueryClient restClient, BigQueryClient.TableRef table, String destinationUri) throws BigQueryException, InterruptedException, SQLException {
        ExtractToCloudStorageOptions options = this.buildExtractOptions(this.outputDS);
        TableResource tableResource = restClient.getTable(table);
        if ("TABLE".equals(tableResource.type)) {
            try {
                logger.info((Object)String.format("Extracting BigQuery %s %s into GCS bucket using a Job", tableResource.type, table));
                restClient.extractToCloudStorageSync(Collections.singletonList(destinationUri), table, options);
            }
            catch (BigQueryException e) {
                logger.info((Object)"Failed to extract BigQuery table using Job, trying using GoogleSQL", (Throwable)e);
                try {
                    String sql = this.createExtractToCloudStorageSQL(dialect, destinationUri, table, options);
                    SQLUtils.safeExec(conn, sql, true);
                }
                catch (SQLException e2) {
                    logger.warn((Object)"Failed to extract BigQuery table using GoogleSQL", (Throwable)e2);
                    throw e;
                }
            }
        } else {
            logger.info((Object)String.format("Extracting BigQuery %s %s into GCS bucket using GoogleSQL", tableResource.type, table));
            String sql = this.createExtractToCloudStorageSQL(dialect, destinationUri, table, options);
            SQLUtils.safeExec(conn, sql, true);
        }
    }

    private String createExtractToCloudStorageSQL(BigQuerySQLDialect dialect, String destinationUri, BigQueryClient.TableRef table, ExtractToCloudStorageOptions options) {
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        optionsMap.put("uri", dialect.quoteString(destinationUri));
        String format = options.getDestinationFormatSQL();
        optionsMap.put("format", dialect.quoteString(format));
        if (options.compression != null && !"NONE".equals(options.compression)) {
            optionsMap.put("compression", dialect.quoteString(options.compression));
        }
        if ("CSV".equals(format)) {
            if (options.printHeader != null) {
                optionsMap.put("header", options.printHeader != false ? "true" : "false");
            }
            if (options instanceof ExtractCsvToCloudStorageOptions) {
                ExtractCsvToCloudStorageOptions csvOptions = (ExtractCsvToCloudStorageOptions)options;
                if (csvOptions.fieldDelimiter != '\u0000') {
                    String delimiter = csvOptions.fieldDelimiter == '\t' ? "'\\t'" : dialect.quoteString(String.valueOf(csvOptions.fieldDelimiter));
                    optionsMap.put("field_delimiter", delimiter);
                }
            }
        }
        optionsMap.put("overwrite", "true");
        String sqlOptions = Joiner.on((String)", ").join((Iterable)optionsMap.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()));
        String sql = String.format("EXPORT DATA OPTIONS(%s) AS SELECT * FROM %s", sqlOptions, dialect.getQuotedTableFullName(table));
        logger.debug((Object)("Performing following SQL to extract data: " + sql));
        return sql;
    }

    private void tryDeletingTemporaryTable(BigQueryClient restClient, BigQueryClient.TableRef temporaryTable) {
        try {
            logger.info((Object)"deleting temporary BigQuery table");
            restClient.deleteTableIfExist(temporaryTable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn((Object)String.format("Unable to delete temporary BigQuery table %s", temporaryTable), (Throwable)e);
        }
        catch (BigQueryException e) {
            logger.warn((Object)String.format("Unable to delete temporary BigQuery table %s", temporaryTable), (Throwable)e);
        }
    }

    @VisibleForTesting
    ExtractToCloudStorageOptions buildExtractOptions(Dataset dataset) {
        switch (dataset.getFormatType()) {
            case "csv": {
                CSVFormatConfig csvFormatConfig = dataset.getFormatParamsAs(CSVFormatConfig.class);
                ExtractCsvToCloudStorageOptions csvOptions = new ExtractCsvToCloudStorageOptions();
                csvOptions.fieldDelimiter = csvFormatConfig.getSeparatorChar();
                csvOptions.compression = CSV_COMPRESS_GZIP_VALUE.equals(csvFormatConfig.compress) ? csvOptions.createCompression("GZIP") : csvOptions.createCompression(csvFormatConfig.compress);
                csvOptions.printHeader = csvFormatConfig.parseHeaderRow;
                return csvOptions;
            }
            case "avro": {
                AvroFormatConfig avroFormatConfig = dataset.getFormatParamsAs(AvroFormatConfig.class);
                ExtractAvroToCloudStorageOptions avroOptions = new ExtractAvroToCloudStorageOptions();
                if (avroFormatConfig.avroCompressionMethod == null) {
                    avroOptions.compression = avroOptions.createCompression("NONE");
                } else {
                    switch (avroFormatConfig.avroCompressionMethod) {
                        case NONE: {
                            avroOptions.compression = avroOptions.createCompression("NONE");
                            break;
                        }
                        case DEFLATE_1: 
                        case DEFLATE_5: 
                        case DEFLATE_9: {
                            avroOptions.compression = avroOptions.createCompression("DEFLATE");
                            break;
                        }
                        case SNAPPY: {
                            avroOptions.compression = avroOptions.createCompression("SNAPPY");
                        }
                    }
                }
                return avroOptions;
            }
            case "json": {
                ExtractJsonToCloudStorageOptions jsonOptions = new ExtractJsonToCloudStorageOptions();
                jsonOptions.compression = jsonOptions.createCompression("NONE");
                return jsonOptions;
            }
            case "parquet": {
                ParquetFormatConfig parquetFormatConfig = dataset.getFormatParamsAs(ParquetFormatConfig.class);
                ExtractParquetToCloudStorageOptions parquetOptions = new ExtractParquetToCloudStorageOptions();
                if (parquetFormatConfig.parquetCompressionMethod == null) {
                    parquetOptions.compression = parquetOptions.createCompression("NONE");
                } else {
                    switch (parquetFormatConfig.parquetCompressionMethod) {
                        case UNCOMPRESSED: {
                            parquetOptions.compression = parquetOptions.createCompression("NONE");
                            break;
                        }
                        case GZIP: {
                            parquetOptions.compression = parquetOptions.createCompression("GZIP");
                            break;
                        }
                        case SNAPPY: {
                            parquetOptions.compression = parquetOptions.createCompression("SNAPPY");
                            break;
                        }
                        case ZSTD: {
                            parquetOptions.compression = parquetOptions.createCompression("ZSTD");
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Cannot export to lzo compressed parquet");
                        }
                    }
                }
                return parquetOptions;
            }
        }
        throw new IllegalStateException("Unhandled dataset format type: " + dataset.getFormatType());
    }

    private String buildDestinationUri(GCSDatasetHandler gcsdh) throws IOException, DKUSecurityException, CodedException {
        String destinationUri = this.createFilePath(gcsdh) + this.createFileNameWithExtension();
        logger.debug((Object)("Generating destinationUris: " + destinationUri));
        return destinationUri;
    }

    private String createFilePath(GCSDatasetHandler gcsDatasetHandler) throws IOException, DKUSecurityException, CodedException {
        StringBuilder filePath = new StringBuilder();
        filePath.append(gcsDatasetHandler.getProviderRootPath());
        PartitioningScheme scheme = this.outputPartition.getScheme();
        if (scheme != null && scheme.isPartitioned()) {
            filePath.append(FilePartitioner.computePartitionRelPathAsFolder(this.outputPartition, scheme));
        }
        if (!filePath.toString().endsWith("/")) {
            filePath.append("/");
        }
        return filePath.toString();
    }

    private String createFileNameWithExtension() {
        return GCS_FILENAME + this.createFileExtension(this.outputDS);
    }

    @VisibleForTesting
    String createFileExtension(Dataset dataset) {
        StringBuilder fileExtension = new StringBuilder();
        fileExtension.append(".");
        fileExtension.append(dataset.getFormatType());
        block6 : switch (dataset.getFormatType()) {
            case "csv": {
                CSVFormatConfig csvFormatConfig = dataset.getFormatParamsAs(CSVFormatConfig.class);
                if (!CSV_COMPRESS_GZIP_VALUE.equals(csvFormatConfig.compress)) break;
                fileExtension.append(".gz");
                break;
            }
            case "avro": {
                AvroFormatConfig avroFormatConfig = dataset.getFormatParamsAs(AvroFormatConfig.class);
                if (avroFormatConfig.avroCompressionMethod == null) break;
                switch (avroFormatConfig.avroCompressionMethod) {
                    case NONE: {
                        break block6;
                    }
                    case DEFLATE_1: 
                    case DEFLATE_5: 
                    case DEFLATE_9: {
                        fileExtension.append(".deflate");
                        break block6;
                    }
                    case SNAPPY: {
                        fileExtension.append(".snappy");
                        break block6;
                    }
                }
                throw new IllegalStateException("Unhandled compression format type: " + String.valueOf((Object)avroFormatConfig.avroCompressionMethod));
            }
            case "json": {
                break;
            }
            case "parquet": {
                ParquetFormatConfig parquetFormatConfig = dataset.getFormatParamsAs(ParquetFormatConfig.class);
                if (parquetFormatConfig.parquetCompressionMethod == null) break;
                switch (parquetFormatConfig.parquetCompressionMethod) {
                    case UNCOMPRESSED: {
                        break block6;
                    }
                    case GZIP: {
                        fileExtension.append(".gz");
                        break block6;
                    }
                    case SNAPPY: {
                        fileExtension.append(".snappy");
                        break block6;
                    }
                    case ZSTD: {
                        fileExtension.append(".zst");
                        break block6;
                    }
                }
                throw new IllegalStateException("Unhandled compression format type: " + String.valueOf((Object)parquetFormatConfig.parquetCompressionMethod));
            }
            default: {
                throw new IllegalStateException("Unhandled dataset format type: " + dataset.getFormatType());
            }
        }
        return fileExtension.toString();
    }

    private static List<String> getColumnNames(Schema temporaryTableSchema, BigQuerySQLDialect dialect) {
        return temporaryTableSchema.getColumns().stream().map(c2 -> dialect.quoteIdentifier(c2.getName())).collect(Collectors.toList());
    }

    private static List<String> getAdjustedColumns(Dataset outputDS, Dataset inputDS, Schema temporaryTableSchema, BigQuerySQLDialect dialect) {
        ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
        return temporaryTableSchema.getColumns().stream().map(input -> {
            switch (input.getType()) {
                case DATE: 
                case DATEONLY: 
                case DATETIMENOTZ: {
                    boolean outputIsCsv = "csv".equals(outputDS.getFormatType());
                    boolean temporalAsString = outputIsCsv || outputDS.getDkuPropertiesAsParams().getBoolParam("bigquery.unload.temporalAsString", false);
                    return BigQueryToGCS.getReplacedDate(inputDS, input, ebf, temporalAsString).toSQL(dialect);
                }
                case ARRAY: 
                case OBJECT: {
                    switch (outputDS.getFormatType()) {
                        case "csv": {
                            String inputCol = dialect.quoteIdentifier(input.getName());
                            return "(IF(" + inputCol + " IS NULL, \"\", TO_JSON_STRING(" + inputCol + ")))";
                        }
                        case "avro": 
                        case "json": {
                            return ExpressionUtils.getAdjustedColumn(ebf.col(input.getName()), input, inputDS, (SQLDialect)dialect).toSQL(dialect);
                        }
                        case "parquet": {
                            return ebf.col(input.getName()).toSQL(dialect);
                        }
                        default: {
                            throw new IllegalStateException("Unhandled dataset format type: " + outputDS.getFormatType());
                        }
                        case "default": 
                    }
                }
            }
            return ExpressionUtils.getAdjustedColumn(ebf.col(input.getName()), input, inputDS, (SQLDialect)dialect).toSQL(dialect);
        }).collect(Collectors.toList());
    }

    private static ExpressionBuilder getReplacedDate(Dataset inputDS, SchemaColumn outputColumn, ExpressionBuilder.ExpressionBuilderFactory ebf, boolean temporalAsString) {
        String columnName = outputColumn.getName();
        SchemaColumn inputColumn = inputDS.getSchema().getColumn(columnName);
        ExpressionBuilder col = ebf.col(columnName);
        if (!inputDS.isManaged() && inputColumn != null && StringUtils.isNotBlank((String)inputColumn.originalSQLType)) {
            String assumedTz = inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getAssumedJavaTzForUnknownTz();
            if ("date".equalsIgnoreCase(inputColumn.originalSQLType)) {
                if (inputColumn.getType() == Type.DATE) {
                    col = col.convertFromTz(assumedTz);
                    if (temporalAsString) {
                        return col.format(Type.DATE, ISO8601_FORMAT);
                    }
                    return col;
                }
                if (temporalAsString || inputColumn.getType() == Type.STRING) {
                    return col.format(inputColumn.getType(), "yyyy-MM-dd");
                }
                return col;
            }
            if ("datetime".equalsIgnoreCase(inputColumn.originalSQLType)) {
                if (inputColumn.getType() == Type.DATE) {
                    col = col.convertFromTz(assumedTz);
                    if (temporalAsString) {
                        return col.format(Type.DATE, ISO8601_FORMAT);
                    }
                    return col;
                }
                if (temporalAsString || inputColumn.getType() == Type.STRING) {
                    return col.format(inputColumn.getType(), "yyyy-MM-dd HH:mm:ss");
                }
                return col;
            }
            if (temporalAsString) {
                return col.format(inputColumn.getType(), ISO8601_FORMAT);
            }
            return col;
        }
        if (temporalAsString) {
            return col.format(inputColumn.getType(), ISO8601_FORMAT);
        }
        return col;
    }

    private static SISORecipeExecutor.CompatibilityCheck isCompatible(Dataset inputDS, Dataset outputDS, SerializedRecipe.RecipeOutput recipeOutput) {
        if (recipeOutput.appendMode) {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("Not compatible with append mode");
        }
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        if (inputMeta != BuiltinSQLDatasets.BIGQUERY_META) {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("Input dataset is not in Google BigQuery");
        }
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, "GCS")) {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("Output dataset is not in Google Cloud Storage");
        }
        if (DatasetUtils.isInQueryMode(inputDS)) {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("BigQuery datasets in 'query' mode are not supported");
        }
        switch (outputDS.getFormatType()) {
            case "csv": {
                CSVFormatConfig csvFormatConfig = outputDS.getFormatParamsAs(CSVFormatConfig.class);
                return BigQueryToGCS.isCsvSupported(csvFormatConfig);
            }
            case "avro": {
                return SISORecipeExecutor.CompatibilityCheck.ok();
            }
            case "parquet": {
                return SISORecipeExecutor.CompatibilityCheck.ok();
            }
        }
        return SISORecipeExecutor.CompatibilityCheck.unsupported("Input format not supported: " + inputDS.getFormatType());
    }

    private static SISORecipeExecutor.CompatibilityCheck isCsvSupported(CSVFormatConfig config) {
        char separatorChar = config.getSeparatorChar();
        if (separatorChar == '\u0000' || separatorChar > '\u007f') {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("Input separator not supported: '" + config.getSeparatorStr() + "'");
        }
        String compress = config.compress;
        if (compress == null) {
            return SISORecipeExecutor.CompatibilityCheck.unsupported("Compress parameter cannot be null");
        }
        return SISORecipeExecutor.CompatibilityCheck.ok();
    }
}

