/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.dataflow.exec.sync.S3ToRedshift;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLQueryDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeEngineParams;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RedshiftToS3
extends SISORecipeExecutor {
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private final VisualSQLRecipeEngineParams.RedshiftEngineParams engineParams;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.s3toredshift");

    public RedshiftToS3(VisualSQLRecipeEngineParams.RedshiftEngineParams engineParams) {
        this.engineParams = engineParams;
    }

    @VisibleForTesting
    static S3ToRedshift.CopyMode getCopyMode(Dataset outputDS) {
        S3ToRedshift.CopyMode mode = new S3ToRedshift.CopyMode();
        switch (outputDS.getFormatType()) {
            case "csv": {
                mode.setOutputCSVCopyMode(outputDS.getFormatParamsAs(CSVFormatConfig.class));
                break;
            }
            case "parquet": {
                mode.setParquetCopyMode(outputDS);
                break;
            }
            default: {
                throw new RedshiftToS3Exception("Output format not supported: " + outputDS.getFormatType());
            }
        }
        return mode;
    }

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status, SerializedRecipe.RecipeOutput recipeOutput) {
        DatasetHandler.DatasetMeta<?, ?> inputMeta = DatasetHandlerFactory.getMeta(inputDS);
        status.isSelectable = true;
        if (recipeOutput.appendMode) {
            status.setStatus("Not compatible with append mode", RecipeEngineStatus.WarningLevel.ERROR);
            status.isSelectable = false;
        } else if (inputMeta != BuiltinSQLDatasets.REDSHIFT_META) {
            status.setStatus("Input dataset is not in Redshift", RecipeEngineStatus.WarningLevel.ERROR);
            status.isSelectable = false;
        } else if (!new FastPathDatasetTypeStraightener().isEquivalentTo(outputDS, "S3")) {
            status.setStatus("Output dataset is not in S3", RecipeEngineStatus.WarningLevel.ERROR);
            status.isSelectable = false;
        } else {
            try {
                RedshiftToS3.getCopyMode(outputDS);
            }
            catch (RedshiftToS3Exception e) {
                logger.info((Object)"Could not prepare copy mode", (Throwable)e);
                status.markAsNonSelectable(ExceptionUtils.getMessageWithCauses((Throwable)e), RecipeEngineStatus.WarningLevel.ERROR);
            }
            status.isSelectable = true;
        }
    }

    @Override
    public void run() throws Exception {
        assert (this.writeMode == Output.WriteMode.APPEND);
        try (AbstractSQLDatasetHandler vti = (AbstractSQLDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.inputDS);
             S3DatasetHandler s3dh = (S3DatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.outputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLDialect dialect = connData.getDialect();
            S3ToRedshift.CopyMode copyMode = RedshiftToS3.getCopyMode(this.outputDS);
            String selectColumnNames = this.getSelectColumnNames(this.inputDS, dialect, copyMode);
            AbstractSQLDatasetHandler.AbstractSQLConfig inputConfig = this.inputDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            ArrayList<String> selectChunks = new ArrayList<String>();
            switch (inputConfig.mode) {
                case "table": {
                    SQLUtils.SQLTable table = ((AbstractSQLTableDatasetHandler)vti).getResolvedTable();
                    selectChunks.add(String.format("'SELECT %s from %s %s'", selectColumnNames, dialect.getQuotedTableFullName(table), this.getWhereClause(dialect)));
                    break;
                }
                case "query": {
                    for (Partition p : this.inputPartitions) {
                        String unescapedQuery = ((AbstractSQLQueryDatasetHandler)vti).expandQueryForPartition(p);
                        String escapedQuery = unescapedQuery.replace("\\", "\\\\").replace("'", "\\'").replaceFirst(";$", "");
                        selectChunks.add(String.format("'SELECT %s FROM (%s) __inner'", selectColumnNames, escapedQuery));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mode in input dataset: " + inputConfig.mode);
                }
            }
            EC2Connection ec2 = s3dh.getConnection();
            String s3Credentials = ec2.getS3CredentialsForRedshift(this.inputDS, this.authCtx, this.symetricCryptoService);
            String displayableS3Credentials = RedshiftToS3.getDisplayableS3Credentials(s3Credentials);
            String baseFileAddress = s3dh.getInformationalRootPath() + this.getPartitionFilePath() + "out-s";
            try (SQLConnectionProvider.SQLConnectionWrapper conn = vti.newConnection();){
                int chunkIdx = 0;
                for (String selectChunk : selectChunks) {
                    String fileAddress = chunkIdx == 0 ? baseFileAddress : baseFileAddress + "-" + chunkIdx + "-";
                    String copyStatement = String.format("UNLOAD (%s) to '%s' ALLOWOVERWRITE %s %s ", selectChunk, fileAddress, copyMode.redshiftOptions(true), s3Credentials);
                    String displayableCopyStatement = String.format("UNLOAD (%s) to '%s' ALLOWOVERWRITE %s %s ", selectChunk, fileAddress, copyMode.redshiftOptions(true), displayableS3Credentials);
                    try (Statement statement = conn.createStatement();){
                        SQLUtils.execute(conn, statement, copyStatement, displayableCopyStatement, true, true);
                        logger.info((Object)"Committing Redshift transaction");
                        conn.commit();
                    }
                    ++chunkIdx;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Redshift unload failed", (Throwable)e);
                if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"The bucket you are attempting to access must be addressed using the specified endpoint")) {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_SYNC_AWS_DIFFERENT_REGIONS, "Redshift to S3 engine cannot be used when input Redshift cluster and output S3 bucket are in different AWS regions");
                }
                throw e;
            }
        }
    }

    private static boolean hasTimeZoneInformation(String originalType) {
        return "TIMESTAMPTZ".equalsIgnoreCase(originalType);
    }

    private static String castColumn(SchemaColumn column, Dataset dataset, SQLDialect dialect, S3ToRedshift.CopyMode copyMode, boolean writesDatesAsDates) {
        Object castColumn;
        switch (column.getType()) {
            case DATE: {
                Object columnToFormat;
                if (!dataset.isManaged() && !RedshiftToS3.hasTimeZoneInformation(column.originalType)) {
                    String assumedTz = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getAssumedJavaTzForUnknownTz();
                    columnToFormat = "CONVERT_TIMEZONE(\\'" + assumedTz + "\\', \\'UTC\\', " + dialect.quoteIdentifier(column.getName()) + ")";
                } else {
                    columnToFormat = dialect.quoteIdentifier(column.getName());
                }
                columnToFormat = "CAST(" + (String)columnToFormat + " AS TIMESTAMPTZ)";
                castColumn = writesDatesAsDates ? columnToFormat : "TO_CHAR(" + (String)columnToFormat + ", \\'YYYY-MM-DDThh24:MI:SS.MSZ\\')";
                break;
            }
            case DATETIMENOTZ: {
                castColumn = dialect.quoteIdentifier(column.getName());
                if (copyMode.type != S3ToRedshift.CopyMode.CopyModeType.PARQUET) break;
                castColumn = "TO_CHAR(" + (String)castColumn + ", \\'YYYY-MM-DD hh24:MI:SS.MS\\')";
                break;
            }
            case BOOLEAN: {
                castColumn = "CASE WHEN " + dialect.quoteIdentifier(column.getName()) + " IS TRUE THEN \\'true\\' WHEN " + dialect.quoteIdentifier(column.getName()) + " IS FALSE THEN \\'false\\' END";
                break;
            }
            case STRING: {
                if (!copyMode.escape && copyMode.quote == '\"') {
                    castColumn = "REPLACE(" + dialect.quoteIdentifier(column.getName()) + ",\\'\"\\',\\'\"\"\\')";
                    break;
                }
                castColumn = dialect.quoteIdentifier(column.getName());
                break;
            }
            default: {
                castColumn = dialect.quoteIdentifier(column.getName());
            }
        }
        return castColumn;
    }

    private String getSelectColumnNames(Dataset dataset, SQLDialect dialect, S3ToRedshift.CopyMode copyMode) {
        Schema selectedColumnsSchema = FastpathUtils.getTemporaryTableSchemaForCloudSync(this.inputDS, this.outputDS);
        ArrayList<CallSite> selectColumnNamesL = new ArrayList<CallSite>();
        boolean writeAsDates = this.engineParams != null && copyMode.type == S3ToRedshift.CopyMode.CopyModeType.PARQUET ? this.engineParams.writeDatesInParquet : false;
        for (SchemaColumn col : selectedColumnsSchema.columns) {
            if (this.inputDS.getSchema().getColumn(col.getName()) != null) {
                selectColumnNamesL.add((CallSite)((Object)(RedshiftToS3.castColumn(col, dataset, dialect, copyMode, writeAsDates) + " AS " + dialect.quoteIdentifier(col.getName()))));
                continue;
            }
            selectColumnNamesL.add((CallSite)((Object)(FastpathUtils.getPartitionValue(col.getName(), this.outputPartition) + " AS " + dialect.quoteIdentifier(col.getName()))));
        }
        return Joiner.on((String)",").join(selectColumnNamesL);
    }

    private String getPartitionFilePath() {
        Boolean isPartitioned;
        String partitionPath = "/";
        PartitioningScheme scheme = this.outputPartition.getScheme();
        if (scheme != null && (isPartitioned = Boolean.valueOf(scheme.isPartitioned())).booleanValue()) {
            FilePartitioner filePartitioner = new FilePartitioner(scheme);
            partitionPath = FilePartitioner.computePartitionRelPathAsFolder(this.outputPartition, scheme);
        }
        return partitionPath;
    }

    private String getWhereClause(SQLDialect dialect) {
        PartitioningScheme scheme = this.inputDS.getPartitioningSchema();
        String whereClause = "";
        if (scheme != null && scheme.getDimensionNames().size() > 0) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(scheme, this.inputDS, (List<Partition>)this.inputPartitions, dialect);
            SelectQueryBuilder query = new SelectQueryBuilder();
            SelectQueryBuilder subQuery = query.where(partitionFilterExpression);
            String sqlString = subQuery.toSQL(dialect);
            int index = sqlString.indexOf("WHERE");
            whereClause = sqlString.substring(index);
        }
        return whereClause.replace("'", "\\'");
    }

    static String getDisplayableS3Credentials(String redshifts3Credentials) {
        String displayableS3Credentials = redshifts3Credentials.contains("CREDENTIALS") ? "CREDENTIALS" : "IAM_ROLE";
        return displayableS3Credentials;
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    public static class RedshiftToS3Exception
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        RedshiftToS3Exception(String message) {
            super(message);
        }
    }
}

