/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.UpsertRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public class UpsertRecipeCreator
extends SISORecipeCreator {
    private UpsertRecipeService service = new UpsertRecipeService();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.upsert.creator");

    public UpsertRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        Dataset inputDataset = this.getInputDataset(recipe);
        UpsertRecipePayloadParams params = this.service.loadParams(payload, recipe);
        Schema outputSchema = this.service.getOutputSchemaAfterOverride(inputDataset, params, false, null);
        outputDataset.setSchema(outputSchema);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        UpsertRecipeCreationSettings settings = (UpsertRecipeCreationSettings)JSON.parse((JsonElement)data, UpsertRecipeCreationSettings.class);
        UpsertRecipePayloadParams params = new UpsertRecipePayloadParams();
        UpsertRecipePayloadParams.UpsertKey keycol = new UpsertRecipePayloadParams.UpsertKey();
        keycol.column = settings.upsertKey;
        params.keys.add(keycol);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        if (DatasetInspector.isSQL(inputDataset) && DatasetInspector.isSQL(outputDataset)) {
            String inputConnection = inputDataset.getParams().getConnection();
            String outputConnection = outputDataset.getParams().getConnection();
            if (StringUtils.isNotBlank((String)inputConnection) && StringUtils.equals((String)inputConnection, (String)outputConnection)) {
                try {
                    AbstractSQLConnection connection = (AbstractSQLConnection)ConnectionsDAO.get().getMandatoryConnectionUnsafeUnexpanded(this.authCtx, inputConnection);
                    SQLDialect dialect = connection.getDialect();
                    SQLDialect.UpsertWriter upsertWriter = dialect.getUpsertWriter();
                    if (upsertWriter != null) {
                        params.upsertSQLMode = UpsertRecipePayloadParams.UpsertSQLMode.DIRECT;
                        if (upsertWriter.usesIndex()) {
                            params.upsertIndexMode = UpsertRecipePayloadParams.UpsertIndexMode.TEMPORARY;
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to test if direct upsert is possible, leaving default mode", (Throwable)e);
                }
            }
        }
        return JSON.json((Object)params);
    }

    public static class UpsertRecipeCreationSettings
    extends SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings {
        public String upsertKey;
    }
}

