/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.window.Windower;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WindowRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    private WindowRecipePayloadParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.window");

    public WindowRecipeBuiltinRunner(JobActivity activity, WindowRecipePayloadParams params) {
        super(activity);
        this.params = params;
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        FlowDataset inputFD = this.activity.getSubgraph().getSingleTargetDataset();
        Dataset inputDS = inputFD.getMandatory(this.datasetsDAO);
        OracleSQLDialect dialect = inputDS.getType().equals(BuiltinSQLDatasets.ORACLE_META.getType()) ? new OracleSQLDialect(this.authCtxService.getAuthCtx(), inputDS) : null;
        GrelExpression preFilterExpression = FilterDescUtils.willFilter(this.params.preFilter) ? FilterDescUtils.getGrelFilterExpression(this.params.preFilter) : null;
        GrelExpression postFilterExpression = FilterDescUtils.willFilter(this.params.postFilter) ? FilterDescUtils.getGrelFilterExpression(this.params.postFilter) : null;
        List<WindowRecipePayloadParams.WindowValue> resolvedWindowValues = this.params.getResolvedWindowValues(input.schema);
        if (this.params.preFilter != null && this.params.preFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(input.schema, new File(tempDirectory, "prefilter")));
        }
        if (preFilterExpression != null) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
        }
        Schema schemaAfterComputedCols = new Schema(input.schema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns));
            for (ComputedColumn cc : this.params.computedColumns) {
                schemaAfterComputedCols.addColumn(cc.name, Type.forName((String)cc.type));
            }
        }
        int p = 0;
        Schema computedOutputSchema = schemaAfterComputedCols;
        for (WindowRecipePayloadParams.WindowDesc windowDesc : this.params.windows) {
            int[] ntilesDesc = this.params.ntile ? this.params.getNtileValues() : null;
            Windower windower = new Windower(windowDesc, resolvedWindowValues, this.params.rank, this.params.denseRank, this.params.rowNumber, this.params.cumeDist, ntilesDesc, new File(tempDirectory, "window" + p), this.mergeSortParams, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), this.params.legacyUnboundedWindowStreamBehavior);
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.WindowerThread(windower, computedOutputSchema));
            computedOutputSchema = windower.getOutputSchema(computedOutputSchema);
            ++p;
        }
        if (postFilterExpression != null) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(postFilterExpression));
        }
        Schema cleanComputedOutputSchema = new Schema();
        for (Object column : computedOutputSchema.getColumns()) {
            if (input.schema.getColumn(column.getName()) != null) {
                boolean retrieve = resolvedWindowValues.stream().filter(arg_0 -> WindowRecipeBuiltinRunner.lambda$prepareStages$0((SchemaColumn)column, arg_0)).findFirst().map(value -> value.value).orElse(false);
                if (!retrieve) continue;
                cleanComputedOutputSchema.addColumn((SchemaColumn)column);
                continue;
            }
            cleanComputedOutputSchema.addColumn((SchemaColumn)column);
        }
        logger.info((Object)("Computed schema after windows is " + JSON.log((Object)cleanComputedOutputSchema)));
        if (this.params.postFilter != null && this.params.postFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(cleanComputedOutputSchema, new File(tempDirectory, "postfilter")));
        }
        if (this.params.outputColumnNameOverrides != null && !this.params.outputColumnNameOverrides.keySet().isEmpty()) {
            ColumnRenamer.Parameter parameter = new ColumnRenamer.Parameter();
            for (String from : this.params.outputColumnNameOverrides.keySet()) {
                String to = this.params.outputColumnNameOverrides.get(from);
                if (!StringUtils.isNotBlank((String)from) || !StringUtils.isNotBlank((String)to)) continue;
                parameter.renamings.add(new FindReplace.Substitution(from, to));
            }
            ColumnRenamer columnRenamer = new ColumnRenamer(parameter);
            columnRenamer.setColumnFactory((ColumnFactory)output.cf);
            columnRenamer.init();
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamer, cleanComputedOutputSchema));
        }
        return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
    }

    private static /* synthetic */ boolean lambda$prepareStages$0(SchemaColumn column, WindowRecipePayloadParams.WindowValue value) {
        return column.getName().equals(value.column);
    }
}

