/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ConcatAggregation
extends WindowAggregation {
    private final List<String> bufferContents = Lists.newArrayList();
    private final String separator;
    private boolean needsReset = false;
    private final boolean distinct;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, Type.STRING);
    }

    public ConcatAggregation(Column column, Column result, SchemaColumn schemaColumn, String separator, boolean distinct) {
        super(column, result, schemaColumn, ConcatAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        this.distinct = distinct;
        this.separator = separator == null ? "" : separator;
    }

    @Override
    public boolean needsReset() {
        return this.needsReset;
    }

    @Override
    public void reset() {
        this.bufferContents.clear();
        this.needsReset = false;
    }

    @Override
    public void expand(Row row) {
        String value = row.get(this.column);
        this.bufferContents.add(value == null ? "" : value);
    }

    @Override
    public void shrink(Row row) {
        this.bufferContents.remove(0);
    }

    @Override
    public Object produceValueInternal() {
        AbstractCollection toJoin = this.distinct ? new HashSet() : new ArrayList();
        for (String s : this.bufferContents) {
            if (s == null || s.isEmpty()) continue;
            toJoin.add(s);
        }
        return Joiner.on((String)this.separator).join(toJoin);
    }

    @Override
    public void expandInternal(Object value) {
        throw new Error("unreachable");
    }

    @Override
    public void shrinkInternal(Object value) {
        throw new Error("unreachable");
    }
}

