/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sample.SampleDatasetConfig;
import com.dataiku.dip.datasets.sample.SampleDatasetDesc;
import com.dataiku.dip.datasets.sample.SampleDatasetMetaDataLogo;
import com.dataiku.dip.datasets.sample.SampleDatasetsService;
import com.dataiku.dip.meanings.MeaningsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SampleDatasetDescValidator
extends PluginComponentDescValidator {
    private final SampleDatasetDesc desc;
    private final File resourceFolder;
    private final File componentFolder;
    private final TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.resourcefile");

    public SampleDatasetDescValidator(String componentId, SampleDatasetDesc desc, File resourceFolder, File componentFolder, TransactionService transactionService) {
        super(componentId);
        this.desc = desc;
        this.resourceFolder = resourceFolder;
        this.componentFolder = componentFolder;
        this.transactionService = transactionService;
    }

    @Override
    public InfoMessage.InfoMessages validate() {
        this.genericValidateMeta(this.desc.meta);
        this.validateLogo();
        if (!this.validateVersions()) {
            return this.messages;
        }
        if (!this.validateDataFolders()) {
            return this.messages;
        }
        this.validateConfigs();
        return this.messages;
    }

    private static String invalidExtensionMessage(String logo) {
        int index = logo.lastIndexOf(46);
        return index == -1 ? String.format("Logo file (\"%s\") does not have a file extension.", logo) : String.format("Logo file extension (\"%s\") is not supported.", logo.substring(index));
    }

    private void validateLogo() {
        String logo = this.desc.meta.getLogo();
        if (logo == null) {
            return;
        }
        boolean extensionIsValid = SampleDatasetMetaDataLogo.logoFileExtensionIsValid(logo);
        boolean filenameIsValid = SampleDatasetMetaDataLogo.logoFilenameIsValid(logo);
        if (!extensionIsValid) {
            this.withFatal(SampleDatasetDescValidator.invalidExtensionMessage(logo));
        }
        if (!filenameIsValid) {
            this.withWarning(String.format("Logo filename \"%s\" contains unsupported characters.", logo));
        }
        if (extensionIsValid && filenameIsValid) {
            File logoFile = DKUFileUtils.getWithin((File)this.resourceFolder, (String[])new String[]{logo});
            if (!SampleDatasetMetaDataLogo.logoFileExists(logoFile, logo)) {
                this.withWarning(String.format("Logo file \"resource/%s\" does not exist.", logo));
            } else if (!SampleDatasetMetaDataLogo.logoFileSizeIsValid(logoFile)) {
                this.withWarning(String.format("Logo file \"resource/%s\" exceeds %dMb.", logo, SampleDatasetMetaDataLogo.SIZE_LIMIT_IN_MB));
            }
        }
    }

    private void validateColumns(List<SchemaColumn> columns, String fileName) {
        Set<String> meaningsSet = null;
        try (Transaction t = this.transactionService.beginRead();){
            meaningsSet = ((MeaningsService)SpringUtils.getBean(MeaningsService.class)).listAll().labelsMap.keySet();
        }
        catch (IOException e) {
            logger.warn((Object)"Could not list meanings");
        }
        if (columns == null || columns.isEmpty()) {
            this.withFatal(String.format("[%s] Field columns is not set or empty", fileName));
        } else {
            columns.stream().filter(col -> StringUtils.isBlank((String)col.getName())).findAny().ifPresent(col -> this.withFatal(String.format("[%s] One or several columns are either unset or empty", fileName)));
            columns.stream().map(SchemaColumn::getName).filter(Objects::nonNull).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).forEach(colName -> this.withFatal(String.format("[%s] Column name is duplicated: \"%s\"", fileName, colName)));
            columns.stream().filter(col -> col.getTypeString() == null).forEach(col -> this.withFatal(String.format("[%s] Type is not set for column: \"%s\"", fileName, col.getName())));
            columns.stream().filter(col -> col.getTypeString() != null).filter(col -> !Type.exists((String)col.getTypeString())).forEach(col -> this.withFatal(String.format("[%s] Type \"%s\" is unknown for column: \"%s\"", fileName, col.getTypeString(), col.getName())));
            if (meaningsSet == null) {
                this.withWarning("Could not fetch the list of meanings");
            } else {
                Set<String> finalMeaningsSet = meaningsSet;
                columns.stream().filter(col -> col.getMeaning() != null).filter(col -> !finalMeaningsSet.contains(col.getMeaning())).forEach(col -> this.withWarning(String.format("[%s] Meaning \"%s\" is unknown for column: \"%s\"", fileName, col.getMeaning(), col.getName())));
            }
        }
    }

    private boolean validateVersions() {
        List<String> invalidVersions;
        boolean validated = true;
        if (this.desc.meta.versions.isEmpty()) {
            this.desc.meta.versions.add("");
        }
        if (!(invalidVersions = this.desc.meta.versions.stream().filter(version -> !this.isVersionNameValid((String)version)).toList()).isEmpty()) {
            this.withFatal(String.format("Version \"%s\" contains unsupported characters or is null. Versions should only contain alphanumeric characters or hyphens.", invalidVersions));
            return false;
        }
        this.desc.meta.versions.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(m -> (Long)m.getValue() > 1L).map(Map.Entry::getKey).forEach(colName -> this.withFatal(String.format("Version is duplicated: \"%s\"", colName)));
        if (!this.desc.meta.versions.contains(this.desc.meta.activeVersion)) {
            this.withFatal(String.format("Active version \"%s\" has not been found in the list of versions \"%s\".", this.desc.meta.activeVersion, this.desc.meta.versions));
            validated = false;
        }
        return validated;
    }

    private boolean validateDataFolders() {
        if (this.desc.meta.versions.isEmpty()) {
            return this.checkDataFolder("");
        }
        boolean validated = true;
        for (String version : this.desc.meta.versions) {
            validated = this.checkDataFolder(version) && validated;
        }
        return validated;
    }

    private boolean checkDataFolder(String version) {
        File dataFile = DKUFileUtils.getWithin((File)this.componentFolder, (String[])new String[]{SampleDatasetsService.getDataFolderName(version)});
        if (!dataFile.exists()) {
            this.withFatal(String.format("Data folder \"%s\" has not been found.", dataFile.getName()));
            return false;
        }
        if (!dataFile.isDirectory()) {
            this.withFatal(String.format("Data folder \"%s\" must be a directory.", dataFile.getName()));
            return false;
        }
        return true;
    }

    private boolean isVersionNameValid(String version) {
        Pattern filenamePattern = Pattern.compile("^[a-zA-Z0-9-]*$");
        return version != null && filenamePattern.matcher(version).matches();
    }

    private void validateConfigs() {
        boolean mustValidateDescColumns = this.desc.meta.versions.isEmpty();
        for (String version : this.desc.meta.versions) {
            File configFile = DKUFileUtils.getWithin((File)this.componentFolder, (String[])new String[]{SampleDatasetsService.getConfigFileName(version)});
            if (!configFile.exists()) {
                mustValidateDescColumns = true;
                continue;
            }
            try {
                SampleDatasetConfig config = (SampleDatasetConfig)JSON.parseFile((File)configFile, SampleDatasetConfig.class);
                this.validateColumns(config.columns, configFile.getName());
            }
            catch (IOException e) {
                this.withFatal(String.format("Config file \"%s\" could not be read.", configFile.getName()));
            }
        }
        if (mustValidateDescColumns) {
            this.validateColumns(this.desc.columns, "dataset.json");
        }
    }
}

