/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetConfig;
import com.dataiku.dip.datasets.sample.SampleDatasetDesc;
import com.dataiku.dip.datasets.sample.SampleDatasetDescValidator;
import com.dataiku.dip.datasets.sample.SampleDatasetMeta;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.plugins.exceptions.DuplicateComponentException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SampleDatasetsService
extends AbstractElementService<SampleDatasetDesc, LoadedSampleDataset> {
    @Autowired
    private TransactionService transactionService;

    @Override
    public String getFolderName() {
        return "sample-datasets";
    }

    @Override
    public String getPrefix() {
        return "dataset";
    }

    @Override
    protected String getCodeExtension(LoadedSampleDataset desc) {
        return null;
    }

    @Override
    protected void removeElement(LoadedSampleDataset desc) {
        DatasetHandlerFactory.deregisterDatasetType(desc.getType());
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "Sample_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedSampleDataset load(String elementType, String pluginId, String elementId, File file) throws IOException, DuplicateComponentException {
        HashMap<String, SampleDatasetConfig> configMap = new HashMap<String, SampleDatasetConfig>();
        SampleDatasetDesc desc = SampleDatasetDesc.build(file, this.pluginsService.getPluginResourceFolder(pluginId), pluginId);
        if (desc.meta.versions.isEmpty()) {
            desc.meta.versions.add("");
        }
        for (String string : desc.meta.versions) {
            File file2 = DKUFileUtils.getWithin((File)file.getParentFile(), (String[])new String[]{SampleDatasetsService.getConfigFileName(string)});
            if (file2.exists()) {
                configMap.put(string, SampleDatasetConfig.build(file2));
                continue;
            }
            configMap.put(string, SampleDatasetConfig.buildFromLegacySampleDatasetDesc(desc));
        }
        HashMap<String, LoadedSampleDataset.AvailableDataset> datasetMap = new HashMap<String, LoadedSampleDataset.AvailableDataset>();
        for (Map.Entry entry : configMap.entrySet()) {
            String version = (String)entry.getKey();
            LoadedSampleDataset.AvailableDataset dataset = new LoadedSampleDataset.AvailableDataset();
            dataset.label = desc.meta.label;
            dataset.path = this.getSamplePath(file.getParent(), elementId, version);
            dataset.description = desc.meta.description;
            dataset.columns = ((SampleDatasetConfig)entry.getValue()).columns;
            dataset.rowCount = ((SampleDatasetConfig)entry.getValue()).rowCount;
            datasetMap.put(version, dataset);
        }
        LoadedSampleDataset loadedSampleDataset = new LoadedSampleDataset(elementId, pluginId, elementType, desc, datasetMap, desc.meta.activeVersion);
        SampleDatasetMeta sampleDatasetMeta = new SampleDatasetMeta(loadedSampleDataset);
        DatasetHandlerFactory.checkDuplicateDatasetMeta(pluginId, elementId, elementType, SampleDatasetMeta.class);
        DatasetHandlerFactory.registerDatasetType(sampleDatasetMeta);
        return loadedSampleDataset;
    }

    private String getDataPath(String elementId, String version) {
        return Paths.get(this.getFolderName(), elementId, SampleDatasetsService.getDataFolderName(version)).toString();
    }

    private String getSamplePath(String pluginComponentDirectory, String elementId, String version) throws FileNotFoundException {
        List<String> sampleValidExtensions = List.of(".csv", ".csv.gz");
        String path = DKUFileUtils.getWithin((File)new File(pluginComponentDirectory), (String[])new String[]{SampleDatasetsService.getDataFolderName(version)}).getPath();
        File dataFolder = new File(path);
        if (!dataFolder.exists() || !dataFolder.isDirectory()) {
            throw new FileNotFoundException(String.format("The data folder does not exist or is not a directory: %s", this.getDataPath(elementId, version)));
        }
        File[] files = dataFolder.listFiles();
        if (files == null || files.length == 0) {
            throw new FileNotFoundException(String.format("The data folder is empty: %s", this.getDataPath(elementId, version)));
        }
        List<String> invalidFiles = Arrays.stream(files).map(File::getName).map(name -> name.toLowerCase(Locale.ROOT)).filter(name -> sampleValidExtensions.stream().noneMatch(name::endsWith)).toList();
        if (!invalidFiles.isEmpty()) {
            throw new FileNotFoundException(String.format("Only the following extensions are allowed: %s. The data folder (%s) contains files with invalid extensions: %s.", sampleValidExtensions, this.getDataPath(elementId, version), invalidFiles));
        }
        return path;
    }

    @Override
    public Class<SampleDatasetDesc> getDescClass() {
        return SampleDatasetDesc.class;
    }

    @Override
    public Class<LoadedSampleDataset> getLoadedDescClass() {
        return LoadedSampleDataset.class;
    }

    public static String getConfigFileName(String version) {
        return "config" + (String)(version.isEmpty() ? "" : "_" + version) + ".json";
    }

    public static String getDataFolderName(String version) {
        return "data" + (String)(version.isEmpty() ? "" : "_" + version);
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, SampleDatasetDesc desc) {
        SampleDatasetDescValidator validator = new SampleDatasetDescValidator(componentId, desc, new File(this.getResourceFolder(this.makeType(pluginId, componentId))), DKUFileUtils.getWithin((File)this.pluginsService.getActualPluginFolder(pluginId), (String[])new String[]{this.getFolderName(), componentId}), this.transactionService);
        return validator.validate();
    }
}

